# define PRINTOP 257
# define SYMBOL 258
# define LSYMBOL 259
# define DSYMBOL 260
# define NUMBER 261
# define PREG 262
# define PPSW 263
# define DIVIDE 264
# define DOTDOT 265
# define FLTREG 266
# define REG 267
# define BRKP 268
# define GO 269
# define CONT 270
# define SS 271
# define BREAKS 272
# define CLEAR 273
# define SAVE 274
# define RST 275
# define COPY 276
# define CMD 277
# define COMMENT 278
# define ARRAY 279
# define PATTERN 280
# define IF 281
# define MACRO 282
# define ENTER 283
# define EXIT 284
# define NE 285
# define EQ 286
# define LE 287
# define GE 288
# define AND 289
# define OR 290
# define INC 291
# define DEC 292
# define LEXERR 293
# define REDIR 294
# define DO 295
# define SYSTEM 296
# define ARGS 297
# define XCTMACRO 298
# define INDIR 299

# line 25 "cmd.y"
#include "dcon.h"
#include <sys/types.h>
#include <sys/stat.h>

#define BUMPDOWN (PRINST ? (dotdot -= instlen) : (dot -= prtlen))
#define BUMPUP (PRINST ? (dotdot += instlen) : (dot += prtlen))
#define BUMPDOT (PRINST ? tnode(DOTDOT, 0, 0, 0) : &dotnode)
#define PRINTPSW printf("psw = %8x %8x\n", state.ps_ps, state.ps_pc);

static struct tnode dotnode { '.', 0, 0, 0 };
static int ifflg = 0;
int realpattern;
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;

# line 40 "cmd.y"
BP *bpp;
# define YYERRCODE 256

# line 155 "cmd.y"

yyerror(s) char *s; { }

/*
 * synerr - report a syntax error
 *	the basic error recovery is gobble tokens until a newline,
 *	assuming of course that the token being choked on (yychar) is not
 *	a newline.  The statements "yyclearin" and "yyerrok" are special
 *	YACC commands.  Basically, "yyclearin" says forget about the
 *	current input token, and "yyerrok" says parse as though no error
 *	had occurred.
 */

synerr(){

	argsflag = 0;
	error(0, "syntax error");
	if (yychar != '\n') {
		gobble();
		yyclearin;
		}
	yyerrok;
	}

/*
 * process the '=' operation of assignment, i.e. target = source
 * there are 3 cases
 *	(1) the target is a NUMBER which is the address where the source goes
 *	(2) the target is a SYMBOL, i.e. a symbol table pointer
 *	    there are 3 different types of symbols which must be handled
 *		a debugger symbol (beginning with '#')
 *		a symbol for a register variable
 *		anything else (has value of a memory address)
 *	(3) the target is explicitly a register (i.e. ;r10 = 0)
 */

assign(t1, v, t, savflag)
struct tnode *t1;
int v, t, savflag;{

	register SYM *s;
	register struct arrayelt *a;
	int i, temp;

	switch(t) {
		case SYMBOL:
			s = t1;
			t = map(symval(s));
			if (s->sclass == REGVAR) {
				state.ps_gpr[s->val] = v;
				return(v);
				}
			if (s->sclass == GLOBL) {
				addmod(v, symval(s));
				}
			poke(v, t);
			return(s->val);
		case DSYMBOL:
			s = t1;
			if ((s->type == ARRAY) && (dim >= 0)) {
				a = s->val;
				for (i=0; i<dim; i++)
					if (a->nexta)
					        a = a->nexta;
					else {
					        error(0,"array bound error");
					        dim = -1;
					        return(v);
					        }
				dim = -1;
				return(a->arrayval = v);
				}
			if ((s->type != ARRAY) && (dim == -1))
				return(s->val = v);
			error(0, "array type error");
			dim = -1;
			return(0);
		case LSYMBOL:
			s = t1;
			t = map(lsymval(s));
			if (s->sclass == REGVAR) {
				state.ps_gpr[s->val] = v;
				return(v);
				}
			if (s->sclass == GLOBL) {       /*shouldn't be  */
				addmod(v, lsymval(s));
				}
			poke(v, t);
			return(s->val);
		case NUMBER:
			t = map(temp=doreq(t1, savflag));
			addmod(v, temp);
			poke(v, t);
			return(v);
		case REG:
			t = t1;
			state.ps_gpr[t] = v;
			return(v);
		}
	}

struct tnode *tnode(o, v, l, r)
int o, v;
struct tnode *l, *r;{

	register struct tnode *p;

	if ((p = calloc(1, sizeof(struct tnode))) == NULL)
		error(1, "out of memory");
	p->t_op = o;
	p->t_val = v;
	p->t_left = l;
	p->t_right = r;
	return(p);
	}

/*
 * doreq - execute a request that is stored in a tree
 *	savflag is set if the caller does not want his tree discarded
 *	after use, e.g. bp_cmd must be retained until the bp is cleared
 */



doreq(p, savflag)
struct tnode *p;
int savflag;{

	extern char *Null;
	register int v;
	register struct tnode *t1, *t2;
	struct stat stbuf;
	int r, v1, v2;
	int i, addr, w, rc;
	int len, otype;
	int fild;
	struct optab *pop;
	BP *bpp;
	FILE *fd;
	int savfildes;
	int savloc;
	SYM *s;
	struct arrayelt *a;
	int numbytes;
	int base;

	v = p->t_val;
	t1 = p->t_left;
	t2 = p->t_right;
	r = 0;
	switch(p->t_op) {
		case PRINTOP:
			setpr(v);
			prtval(doreq(t1, savflag), 0);
			break;

		case ',':
			setpr(v);
			printlist(doreq(t1, savflag), doreq(t2, savflag));
			break;

		case '=':
			v2 = doreq(t2, savflag);
			r = assign(t1, v2, v, savflag);
			break;

	/*
	 * some fudging must be done here using "ifflg"
	 * because in an if-expression you want the value of
	 * a symbol, rather than the normal address
	 */
		case IF:
			ifflg++;
			v = doreq(t1, savflag);
			--ifflg;
			if (v) doreq(t2, savflag);
			break;

		case '?':
			setpr(v);
			printstack();
			break;

		case PREG:
			setpr(v);
			printregs();
			break;

		case PPSW:
			setpr(v);
			PRINTPSW
			break;

		case BRKP:
			bpp = qbp(doreq(t1, savflag));
			if (bpp != NULL) {
				bpp->bp_cmd = t2;
				if (v) bpp->bp_comment = v;
				}
			break;

		case GO:
			go(v);
			break;

		case CONT:
			if (t1) cont(doreq(t1, savflag));
			else cont(lastbp);
			break;

		case SS:
			if (t1) v = doreq(t1, savflag);
			else v = lastbp;
			if (ss(v) == 0) {
				printf("%6x ", dotdot);
				prinst(dotdot, 1);
				if ((bpp = bplook(dotdot)) != NULL) {
					printf("\t(break point");
					if (bpp->bp_comment != Null)
						printf(": %s", bpp->bp_comment);
					putchar(')');
					}
				putchar('\n');
				if (t2) doreq(t2, savflag);
				}
			lastbp = dotdot;
			break;

		case SAVE:
			if (t1) {
				getcmt(savloc=doreq(t1,savflag));
				save(savloc);
				}
			else {
				getcmt(ALL_LOCS);
				save(ALL_LOCS);
				}
			break;

		case RST:
			if (t1)
				rst(doreq(t1,savflag));
			else rst(ALL_LOCS);
			break;

		case COPY:
			savfildes = fildes;
			if (v == 0) error(0, "no input file specified");
			else {
				rc = stat(objname, &stbuf);
				if (rc < 0)
					error(0, "can't open %s",objname);
				fildes = creat(v, stbuf.st_mode);
				free(v);
				if (fildes == -1)
					error(0, "can't write %s", v);
				else {
					copyfile(savfildes);
					save(ALL_LOCS);
                                        }
				}
			fildes = savfildes;
			break;

		case BREAKS:
			dbrks();
			break;

		case CLEAR:
			if (t1) bpclear(doreq(t1, savflag));
			else bptail = NULL;
			break;

		case ';':
			doreq(t1, savflag);
			doreq(t2, savflag);
			break;

		case PATTERN:
			inpattern = 1;
			switch(v) {
				case 'f':  numbytes = 4;
				           base = 10;
				           break;
				case 'b':  numbytes = 1;
				           base = 2;
				           break;
				case 'h':  numbytes = 2;
				           base = 10;
				           break;
				case 'x':  numbytes = 1;
				           base = 16;
				           break;
				case 'c':  numbytes = 1;
				           base = 0;
				           break;
				case 'i':  numbytes = BPW;
				           base = 0;
				           break;
				default:   numbytes = 0;
				           base = 0;
				           error(0,"cannot match on this pattern type");
				           break;
				}
			prtlen = 0;
			if (!numbytes) break;
			addr = dot;
			realpattern = cnvrt(v, base);   /* c or i => pattern; */
			                                /* else base 10 int   */
			if (realpattern != -1)          /* if not error */
			                                /* while not match    */
			        while( !compare(v, addr, numbytes))
			                addr = addr + incr(addr,v,numbytes);
			r = addr;
			inpattern = 0;
			break;

		case NUMBER:
			r = v;
			break;

		case SYMBOL:
			r = symval(v);
			if (ifflg) r = peek(map(r));
			break;

		case DSYMBOL:
			r = symval(v);
			break;

		case LSYMBOL:
			r = lsymval(v);
			if (ifflg) r = peek(map(r));
			break;

		case ARGS:
			if (v) r = v;
			else error(0,"tried to execute zero-valued args");
			break;

		case MACRO:
			if ((s = lookup(v)) == NULL)
				error(0,"macro name not in sym tab");
			else  s->val = tnode(MACRO, 0, t1, t2);
					/* Value gets tree w/left subtr*/
					/* of arglist & rt subtr of req*/
			break;

		case XCTMACRO:
			/* v:DSYMBOL; t1:real args in a tnode;          */
			/* v->val->t1:dummy args; v->val->t2;tree to xct*/
                        if (v->val==0) {
                                error(0, "macro never defined");
                                break;
			}
                        /* change dummys to actuals in v->val->t_right */
                        expand(v->val->t_left, t1, v->val->t_right);
                        doreq(v->val->t_right, savflag);
			break;

	/*
	 * a little hanky-panky here, we "switch" the prtlen
	 * so registers look like everybody else
	 * this is a kludge but so is the 470!
	 */
		case REG:
			r = state.ps_gpr[v];
			savplen = prtlen;
			prtlen = 0;
			break;

		case ENTER:
			r = ((SYM *) v)->val + PROLOG;
			break;

		case EXIT:
			r = ((SYM *) v)->val + PROLOG;
			w = peek(map(r));
	
					/* search for bcr reg 14        */
			while(! ((w.opcode==BCR) && (w.r1==15) && (w.r2==14)) ) {
				switch(w.opcode) {
				    case BC:
				    	pop = brlookup(w.r1, BRANCH);
				    	break;
				    case BCR:
				    	pop = brlookup(w.r1, BRANCHR);
				    	break;
				    case SVC:
				    	len = BPHW;
				    	break;
				    default:
				    	if ((pop = oplookup(w.opcode)) == NULL)
				            if (w.sopcode > 0xff)
						 pop = oplookup(w.sopcode);
				    	break;
				    }
	
				if (pop == NULL)  instlen = BPHW;  /*not found */
				otype = pop->op_type;
				switch(otype) {
					case RR:
					case BRANCHR:
						len = BPHW;
						break;
					case BRANCH:
					case RX:
					case RS1:
					case RS2:
					case SI1:
					case SI2:
						len = BPW;
						break;
					case SS1:
					case SS2:
					case SS3:
						len = BPW + BPHW;
						break;
					}
				r = r + len;    /* incr. by instr. lg   */
				w = peek(map(r));
				}
	
			r = r - 4;              /* back above lm instr. */
			break;

		case '+':
		case '-':
		case '*':
		case DIVIDE:
		case EQ:
		case NE:
		case '~':
		case '<':
		case LE:
		case '>':
		case GE:
		case AND:
		case OR:
		case INDIR:
			r = calc(p->t_op, t1, t2, savflag);
			break;

		case DOTDOT:
			r = dotdot;
			break;

		case '$':
			r = fend-stacksize-offset;
			break;

	/*
	 * NB:  this case does a RETURN instead of a BREAK
	 * This is because we don't want to cfree(&dotnode).
	 */
		case '.':
			return(dot);

		case DEC:
			if (PRINST) r = dotdot -= instlen;
			else r = dot -= prtlen;
			break;

		case REDIR:
			if (v == 0) out = stdout;
			else {
				out = fopen(v, "w");
				cfree(v);
				if (out == NULL) {
					out = stdout;
					error(0, "can't write %s", v);
					}
				}
			break;

		case DO:
			if (v == 0) error(0, "no input file specified");
			else {
				fd = fopen(v, "r");
				cfree(v);
				if (fd == NULL)
					error(0, "can't read %s", v);
				else pushin(fd);
				}
			break;

		case SYSTEM:
			r = system(v);
			cfree(v);
			printf("!\n");
			break;

		default:
			error(1, "unknown request %d", p->t_op);
		}
	if (savflag == 0) cfree(p);
	return(r);
	}

calc(op, t1, t2, savflag)
int op;
struct tnode *t1, *t2;
int savflag;{

	register int v1, v2;

	v1 = doreq(t1, savflag);
	if (t2) v2 = doreq(t2, savflag);
	switch(op) {
		case '+':
			return(v1+v2);
		case '-':
			return(v1-v2);
		case '*':
			return(v1*v2);
		case DIVIDE:
			return(v1/v2);
		case EQ:
			return(v1 == v2);
		case NE:
			return(v1 != v2);
		case '~':
			return(!v1);
		case '<':
			return(v1 < v2);
		case LE:
			return(v1 <= v2);
		case '>':
			return(v1 > v2);
		case GE:
			return(v1 >= v2);
		case AND:
			return(v1 && v2);
		case OR:
			return(v1 || v2);
		case INDIR:
			return(peek(map(v1))&STACKTOP);
		default:
			error(1, "unknown op %d", op);
		}
	}

/*
 * symval - figure out the address associated with a symbol
 *	easy for globals, hocus pocus for locals
 * If you don't understand the C calling sequence,
 * this function will make little sense to you.
 */

symval(p)
SYM *p;{

	register SYM *s;
	register int *savereg, *lastfunc;
	SYM *funcsym;
	int r, *lastsreg;
	int i;
	struct arrayelt *ap;

	if (p->name[0] == '#') {
		savplen = prtlen;
		prtlen = 0;
		if ((p->type == ARRAY) && (dim >= 0)) {
			ap = p->val;
			for(i=0; i<dim; i++)
				if (ap->nexta)
				        ap = ap->nexta;
				else {
				        if (decl && (i+1 == dim))  /* handling  */
				                decl = 0;       /* declaration  */
				        else error(0,"array bound error");
				        dim = -1;
				        return(0);
				        }
			dim = -1;
			return(ap->arrayval);
			}
		if ((p->type != ARRAY) && (dim == -1))
		        return(p->val);
		error(0, "array type error");
		dim = -1;
		return(0);
		}
	if (!trace && p->sclass == GLOBL) return(p->val);
	if (trace) {
		lastsreg = 0;
		savereg = state.ps_gpr[12]&STACKTOP;
		lastfunc = state.ps_gpr[10];
		while (savereg != 0) {
			funcsym = valp[vlook(lastfunc, N_TEXT)];

			for (s = p; s != NULL; s = s->next) {
				if (s->func==funcsym && strcmp(p->name, s->name)==0)
					return(sval(s, savereg, lastsreg));
				}
			lastfunc = peek(map(savereg+10));
			lastsreg = savereg;
			savereg = peek(map(savereg+12))&STACKTOP;
			}
		}
	for (s = p; s != NULL; s = s->next)
		if (s->func==NULL && strcmp(s->name, p->name)==0)
			return(s->val);
	error(0, "%s not active", p->name);
	if (p->sclass == REGVAR) {
		savplen = prtlen;
		prtlen = 0;
		}
	return(p->val);
	}

/*
 * for local symbols whose function is specified
 */

lsymval(p)
SYM *p;{

	register SYM *s;
	register int *savereg, *lastfunc;
	SYM *funcsym;
	int r, *lastsreg;

	if (trace) {
		lastsreg = 0;
		savereg = state.ps_gpr[12]&STACKTOP;
		lastfunc = state.ps_gpr[10];
		while (savereg != 0) {
			funcsym = valp[vlook(lastfunc, N_TEXT)];

			for (s = p; s != NULL; s = s->next) {

	/* p->func, not s->func cuz don't vary func throughout the      */
	/*   chain but stay with func requested                         */

				if (p->func==funcsym && strcmp(p->name, s->name)==0) {
					return(sval(s, savereg, lastsreg));
					}
				}
			lastfunc = peek(map(savereg+10));
			lastsreg = savereg;
			savereg = peek(map(savereg+12))&STACKTOP;
			}
		}
	error(0, "%s not active", p->name);
	if (p->sclass == REGVAR) {
		savplen = prtlen;
		prtlen = 0;
		}
	return(p->val);
	}

/*
 * symval function was getting out of hand
 * this function returns the "address" associated with
 * a local variable
 *	Note that we fudge for register variables by silently
 *	changing prtlen to 0 (the 'a' print length).
 */

static sval(p, r, lastr)
register SYM *p;
register int *r, *lastr;{

	if (p->sclass == REGVAR) {
		if (lastr != 0) return(lastr+p->val);
		else {
			savplen = prtlen;
			prtlen = 0;
			return(state.ps_gpr[p->val]);
			}
		}
	else return((peek(map(r+13))&STACKTOP)+p->val);
	}



/*
 *  move down tree x looking for substitutable macro quantity
 */

expand(da, ra, x)
struct tnode *da, *ra, *x;
{
	switch(x->t_op) {
		case ENTER:
		case EXIT:
			subst(da, ra, &x->t_val);
			break;
		case SYMBOL:
			subst(da, ra, &x->t_val);
			break;
		case '=':
			subst(da, ra, &x->t_left);
			break;
		default:
			if (x->t_left  != NULL) expand(da,ra,x->t_left);
			if (x->t_right != NULL) expand(da,ra,x->t_right);
			if ((x->t_left == NULL) && (x->t_right == NULL))
			        error(0,"macros can't substitute for this op\n");
		}
}



/*
 *  replace dummy arg with real arg if dummy arg matches tree's symbol
 */

subst(da, ra, t)
struct tnode *da, *ra;
SYM **t;
{
	SYM *s;
	while (da->t_right != NULL)
		if (strcmp(da->t_left, (*t)->name)==0) {  /*match dummy?*/
			if ((s = lookup(ra->t_left)) == NULL) {
				error("real arg to macro is symbol not found");
				return;
				}
			*t = s;         /* replace dum char* w/SYM *    */
			}
		else {
			da = da->t_right;          /* move down arglist */
			ra = ra->t_right;          /* move down arglist */
		}
	/* is null => 1 more arg to check */
	if (strcmp(da->t_left, (*t)->name)==0) {          /*match dummy?*/
		if ((s = lookup(ra->t_left)) == NULL) {
			error("real arg to macro is symbol not found");
			return;
			}
		*t = s;
	        }

}



/*
 * compare:  pattern type, address to check, #bytes to compare at once
 *           compare vs. global 'realpattern': desired pattern to match
 *           return 1 for match, return 0 for not match
 */

compare(type, addr, numbytes)
char *type;
int addr;
int numbytes;
{
	int k;
	register w, x;
	register struct optab *pop;
	int sysp;
	int loopaddr;
	char *c;

	k = peek(map(addr));
	if (quitread) {                         /* peek into bad area   */
		quitread = 0;
		return (1);                     /* stop checking        */
		}
	switch(numbytes) {
		case 1:  k = k & 0377;
			 break;
		case 2:  k = k & 0177777;
			 break;
		case 4:  break;
		default: error(0,"can't recognize pattern with this number of bytes");
		}

	switch(type) {
		case 'f':
		case 'b':
		case 'h':
		case 'x':
	                if (k == realpattern) return(1);
		                else return(0);
	                break;
		case 'c':
	                c = realpattern;
	                loopaddr = addr;
			while (*c) {
				k = peek(map(loopaddr++));
				if (quitread) {    /* peek into bad area*/
					quitread = 0;
					return (1);     /* stop checking*/
					}
		                k = ((k >> 24) & 0377);
				if (!cmprunit(k,*c++)) return(0);
				}
	                return(1);
	                break;
		case 'i':
                        w = peek(map(addr));
			if (quitread) {            /* peek into bad area*/
				quitread = 0;
				return (1);             /* stop checking*/
				}
	                switch(x = w.opcode) {
	                        case BC:
	                                pop = brlookup(w.r1, BRANCH);
	                                if (pop == NULL) {
	                                        error(0, "pattern not found");
	                                        return(1); /*stop chekng*/
	                                        }
	                                return(!strcmp(realpattern,pop->op_name));
	                                break;
	                        case BCR:
	                                pop = brlookup(w.r1, BRANCHR);
	                                if (pop == NULL) {
	                                        error(0, "pattern not found");
	                                        return(1); /*stop chekng*/
	                                        }
	                                return(!strcmp(realpattern,pop->op_name));
	                                break;
	                        case SVC:
	                                x = (w.r1 << 4) | w.r2;
	                                sysp = syslookup(x);
	                                if (sysp == NULL) {
	                                        error(0, "pattern not found");
	                                        return(1); /*stop chekng*/
	                                        }
                                        if (sysp != -1)
                                                return(!strcmp(realpattern,sys[sysp].sys_name));
                                        else return(!strcmp(realpattern,x));
	                        default:
	                                if ((pop = oplookup(x)) == NULL)
	                                        if (w.sopcode > 0xff)
	                                                pop = oplookup(w.sopcode);
	                                if (pop == NULL) {
	                                        error(0, "pattern not found");
	                                        return(1); /*stop chekng*/
	                                        }
	                                return(!strcmp(realpattern,pop->op_name));
	                        }
		}

}



/*
 *  convert pattern to true value, depending on pattern type
 */

cnvrt(type, base)
char type;
int base;
{
	switch(type) {
		case 'f':
		case 'b':
		case 'h':
		case 'x':
			return(tobinary(&pattern, base));
			break;
		case 'c':
			return(pattern);
			break;
		case 'i':
			return(pattern);
			break;
		}

}



/*
 *  determine amount to increment address for next search
 */

incr(addr, type, numbytes)
int addr;
char type;
int numbytes;
{
	register w, x;
	register struct optab *pop;

	switch(type) {
		case 'f':
		case 'b':
		case 'h':
		case 'x':
		case 'c':
			return(numbytes);
			break;
		case 'i':
	                w = peek(map(addr));
	                switch(x = w.opcode) {
	                        case BC:
	                                pop = brlookup(w.r1, BRANCH);
	                                break;
	                        case BCR:
	                                pop = brlookup(w.r1, BRANCHR);
	                                break;
	                        case SVC:
	                                return(BPHW);
	                                break;
	                        default:
	                                if ((pop = oplookup(x)) == NULL)
	                                        if (w.sopcode > 0xff)
	                                                pop = oplookup(w.sopcode);
	                                break;
	                        }
			if (pop == NULL) return(BPHW);
			switch(pop->op_type) {
	                        case RX:
	                        case RS1:
	                        case RS2:
	                        case SI1:
	                        case SI2:
	                        case S:
	                        case BRANCH:
	                                return(BPW);
	                                break;
	                        case RR:
	                        case BRANCHR:
	                                return(BPHW);
	                                break;
	                        case SS1:
	                        case SS2:
	                        case SS3:
	                                return(BPHW+BPW);
	                                break;
	                        }
			break;
		}

}



/*
 *  compare single character unit of string
 */

cmprunit(addr, pat)
int addr;
char pat;
{

	if (pat == '?') return(1);
	if (addr == pat) return(1);
		else return(0);

}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 90
# define YYLAST 802
short yyact[]={

  41,  94, 127, 131,  36, 150,  16,   7, 140,   8,
  39,  98,  97,  62, 126,   4,  77, 136,  78,  63,
   2,  50,  48,  79,  49,  60,  60,  15,  50,  75,
  74,  73,  60, 146, 134, 133, 147,  78,  80,  76,
  45,  41, 139, 122,  99,  36,  32,  16,   7,  93,
   8,  39,   1,   0,   0,   0,   0,  46,   0,   0,
  50,  48,   0,  49,  60,   0,  72,   0,  15,  89,
  61,  61,   0,  81,  82,  84,  85,  61,  54,   0,
  56,   0,   0, 135,   0,   0,   0,  44,  41, 144,
  35,   0,  36,   0,  16,   7,   0,   8,  39,   0,
   0,   0,   0,   0,   0,   0, 128,  50,  48,  61,
  49,  60,  65,   0,   9,  15,  50,  48,  47,  49,
  60,   0, 116,   0,   0,  54,   0,  56,  44, 117,
   0,  35,   0, 125,  54, 129,  56,   0,   0,   0,
 142,   0, 141,  50,  48, 128,  49,  60, 143,  50,
  48,   0,  49,  60,   0,   0,  61,   9,   0, 137,
   0,  54,   0,  56,   0,  61,   0,  54,   0,  56,
   0,   0,   0, 114,   0,  44,   0,   0,  35,   0,
 132,  50,  48,   0,  49,  60,   0,   0,  44,   0,
   0,   0,  61,  50,  48,   0,  49,  60,  61,  54,
 138,  56,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  54,   0,  56,   0,   0,   0,   0,   0,   0,
  33,   6,  10,  11,  12,  37,  17,  18,   0,  40,
  61,  13,  19,  20,  21,  22,  26,  27,  23,  24,
  25,   0,  61,  51,  38,  14,  31,  42,  43,   9,
  51,   0,   0,   0,   9,   0,   9,  34,  28,  29,
  30,  33,   6,  10,  11,  12,  37,  17,  18,   0,
  40,   0,  13,  19,  20,  21,  22,  26,  27,  23,
  24,  25,  51,  41,   0,  38,  14,  31,  42,  43,
   0,   0,   0,  39,   0,   0,   0,   0,  34,  28,
  29,  30,   0,  53,  52,  55,  57,  58,  33,   6,
  10,  11,  12,  37,  17,  18,   0,  40,   0,  13,
  19,  20,  21,  22,  26,  27,  23,  24,  25,  51,
   0,  62,  38,  14,  31,  42,  43,   0,  51,   0,
   0,   0,   0, 127,   0,  34,  28,  29,  30,   0,
  53,  52,  55,  57,  58,  59,   0,   0,   0,  53,
  52,  55,  57,  58,  59,  51,   0,   3,  41,   0,
   0,  51,  36,   0,  70,   0,   0,   0,  39,   0,
   0,  50,  48,   0,  49,  60,  53,  52,  55,  57,
  58,  59,  53,  52,  55,  57,  58,  59,   0,  54,
   0,  56,   0,  51,   0,   0,   0,   0,  62,   0,
   0,   0, 100,  50,  48,  51,  49,  60,   0,   0,
   0,   0,   0,   0,  53,  52,  55,  57,  58,  59,
  61,  54,   0,  56,   0,   0,  53,  52,  55,  57,
  58,  59,   0,  50,  48,   0,  49,  60,   0,  50,
  48,   0,  49,  60,   0,  44,  50,  48,  35,  49,
  60,  54,  61,  56,   0,   0,   0,  54,   0,  56,
   0,   0,   0,   0,  54,  41,  56,   0,   0,  36,
   0,  70,   0,   0,   0,  39,   0,  41,   0,   0,
   0,  36,  61,  70,  44,   0,   0,  39,  61,   0,
   0,   0,   0,   0, 145,  61,   0,   0,  37, 148,
   0, 149,  40,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  38,   0,   0,
  42,  43,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  35,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  35,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  66,  67,  68,  37,   0,   0,   0,  40,   0,  69,
   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,
   0,   0,  38,   0,   0,  42,  43, 130,   0,   0,
   0,   0,   0,   0,  53,  52,  55,  57,  58,  59,
   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  53,  52,  55,  57,
  58,  59,   0,   0,   0,  51,   0,   0,   0,   0,
   0,  51,   0,   0,   0,   0,   0,   0,  51,   0,
   0,   0,   0,   0,   0,   0,  53,  52,  55,  57,
  58,  59,  53,  52,  55,  57,  62,  66,  67,  68,
  37,  55,  57,   0,  40,   0,  69,   0,   0,  66,
  67,  68,  37,   0,   0,   0,  40,   0,  69,  38,
   5,   0,  42,  43,   0,   0,   0,   0,  64,  71,
   0,  38,   0,   0,  42,  43,   0,  83,   0,   0,
  86,   0,  87,  88,  90,  91,   0,   0,  92,   0,
   0,   0,   0,   0,   0,   0,  95,  96,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 101, 102,
 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
 113,   0, 115,   0,   0,   0,   0,   0,   0,   0,
   0,  83,   0,   0, 118, 119, 120, 121,   0,   0,
 123, 124 };
short yypact[]={

-1000,   5,-1000,  30,-1000,  74,-1000, 451, 439, -30,
 -31, -32, -22, -38,  -2,-244, 439,-244,-244, 451,
-1000, 451, 332, 451, 451,-1000,-1000, 451,-1000,-1000,
-1000,-1000,-1000,-292,-1000, 451, 451,-1000,-1000,-1000,
-1000,-1000,-246,-247,  52,-1000,-1000, 451, 451, 451,
 451, 451, 451, 451, 451, 451, 451, 451, 451, 451,
 247, 451,-1000,-1000, 151,-1000,-1000,-1000,-1000,-1000,
 451, 151,-1000, 451, 451, 451, 451,-1000,-1000, 451,
 451,-1000,-1000, -20,-1000,-1000,  65, 401, 371,-1000,
 339, 401, 401,-257,-1000, -14, 139,  -6,  -7, -42,
-1000, 151, -14, -14, -20, -20, 414, 414, -21, -21,
 -21, -21, 407,  18,-1000, 107,-1000,-1000, 401, 401,
 401, 401,-250, 401, 101,-276,-1000,-1000,-1000,-1000,
-1000,  -3,-1000,-1000,-1000,-1000, -36,-1000,-1000,  -8,
-1000,  52,-1000,  52,-1000,-1000,-1000,-253,-1000,-1000,
-1000 };
short yypgo[]={

   0,  52, 367,  19, 720,  57, 112,  46,  14,  49,
  16,  44,  43,  42 };
short yyr1[]={

   0,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   9,   2,   2,   2,   2,   2,   2,   5,   5,
   7,   7,  12,  10,  13,  13,   8,   8,  11,  11,
   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
   4,   4,   6,   6,   6,   6,   6,   6,   6,   3 };
short yyr2[]={

   0,   3,   2,   1,   2,   1,   4,   3,   3,   2,
   3,   3,   3,   3,   3,   5,   2,   2,   2,   2,
   4,   3,   1,   2,   1,   3,   2,   2,   1,   3,
   2,   1,   2,   1,   1,   1,   2,   1,   1,   1,
   1,   0,   5,   2,   1,   1,   2,   1,   1,   1,
   3,   4,   0,   4,   3,   1,   1,   1,   3,   1,
   1,   1,   1,   1,   1,   3,   3,   3,   3,   3,
   3,   2,   3,   3,   3,   3,   3,   3,   3,   4,
   2,   3,   1,   1,   1,   1,   1,   3,   3,   0 };
short yychk[]={

-1000,  -1,  -3,  -2,  10,  -4, 257,  43,  45,  -6,
 258, 259, 260, 267, 281,  63,  42, 262, 263, 268,
 269, 270, 271, 274, 275, 276, 272, 273, 294, 295,
 296, 282,  -7, 256, 293, 126,  40, 261, 280,  46,
 265,  36, 283, 284, 123,  10,  -5,  44,  43,  45,
  42, 264, 286, 285,  60, 287,  62, 288, 289, 290,
  46,  91, 257,  -3,  -4,  -6, 258, 259, 260, 267,
  42,  -4,  -5,  61,  61,  61,  61, -10,  40,  61,
  40,  -5,  -5,  -4,  -5,  -5,  -4,  -4,  -4,  -7,
  -4,  -4,  -4,  -9, 293,  -4,  -4, 258, 258, -11,
  -2,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,
  -4,  -4,  -4,  -4,  -6,  -4,  -5,  -5,  -4,  -4,
  -4,  -4, -12,  -4,  -4,  -7,  -8, 278,  -3,  -7,
 278, 260,  41,  41,  41, 125,  59,  -5,  93, -13,
 258,  41,  -8, -10, 125,  -2,  41,  44,  -2,  -2,
 258 };
short yydef[]={

  89,  -2,   3,   0,   2,  89,   5,   0,  89,  60,
  61,  62,  63,  64,   0,  89,  89,  89,  89,   0,
  22,  24,  28,  31,  33,  34,  35,  37,  38,  39,
  40,  41,  44,  45,  47,   0,   0,  82,  83,  84,
  85,  86,   0,   0,   0,   1,   4,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  48,  49,  89,  60,  61,  62,  63,  64,
   0,  89,   9,   0,   0,   0,   0,  43,  52,   0,
   0,  16,  17,  80,  18,  19,  89,  23,  27,  26,
  30,  32,  36,   0,  46,  71,   0,   0,   0,   0,
  59,  89,  65,  66,  67,  68,  69,  70,  72,  73,
  74,  75,  76,  77,  78,   0,   7,   8,  10,  11,
  12,  13,   0,  14,   0,  89,  21,  56,  57,  25,
  29,   0,  81,  87,  88,  50,   0,   6,  79,   0,
  55,   0,  20,   0,  51,  58,  53,   0,  15,  42,
  54 };
#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

int yydebug = 0; /* 1 for debugging */
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

			if( yydebug ) printf( "error recovery discards char %d\n", yychar );

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

		if( yydebug ) printf("reduce %d\n",yyn);
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 43 "cmd.y"
{ if (yypvt[-1]) doreq(yypvt[-1], 0); } break;
case 2:
# line 44 "cmd.y"
{ prtval(BUMPUP, 0); } break;
case 4:
# line 48 "cmd.y"
{ yyval = tnode(PRINTOP, yypvt[-0], yypvt[-1], 0); } break;
case 5:
# line 49 "cmd.y"
{ yyval = tnode(PRINTOP, yypvt[-0], &dotnode, 0); } break;
case 6:
# line 50 "cmd.y"
{ yyval = tnode(',', yypvt[-0], yypvt[-3], yypvt[-1]); } break;
case 7:
# line 51 "cmd.y"
{ yyval = tnode(PRINTOP, yypvt[-0],
					tnode('+', 0, BUMPDOT, yypvt[-1]), 0); } break;
case 8:
# line 53 "cmd.y"
{ yyval = tnode(PRINTOP, yypvt[-0],
					tnode('-', 0, BUMPDOT, yypvt[-1]), 0); } break;
case 9:
# line 55 "cmd.y"
{ yyval = tnode(PRINTOP, yypvt[-0],
					tnode(DEC, 0, 0, 0), 0); } break;
case 10:
# line 57 "cmd.y"
{ yyval = tnode('=', NUMBER, yypvt[-2], yypvt[-0]); } break;
case 11:
# line 58 "cmd.y"
{ yyval = tnode('=', SYMBOL, yypvt[-2], yypvt[-0]); } break;
case 12:
# line 59 "cmd.y"
{ yyval = tnode('=', LSYMBOL, yypvt[-2], yypvt[-0]); } break;
case 13:
# line 60 "cmd.y"
{ yyval = tnode('=', DSYMBOL, yypvt[-2], yypvt[-0]); } break;
case 14:
# line 61 "cmd.y"
{ yyval = tnode('=', REG, yypvt[-2], yypvt[-0]); } break;
case 15:
# line 62 "cmd.y"
{ yyval = tnode(IF, 0, yypvt[-2], yypvt[-0]); } break;
case 16:
# line 63 "cmd.y"
{ yyval = tnode('?', yypvt[-0], 0, 0); } break;
case 17:
# line 64 "cmd.y"
{ yyval = tnode(PRINTOP, yypvt[-0],
			                tnode(INDIR, 0, &dotnode, 0), 0); } break;
case 18:
# line 66 "cmd.y"
{ yyval = tnode(PREG, yypvt[-0], 0, 0); } break;
case 19:
# line 67 "cmd.y"
{ yyval = tnode(PPSW, yypvt[-0], 0, 0); } break;
case 20:
# line 68 "cmd.y"
{ yyval = tnode(BRKP, yypvt[-0], yypvt[-2], yypvt[-1]); } break;
case 21:
# line 69 "cmd.y"
{ yyval = tnode(BRKP, yypvt[-0], yypvt[-1], 0); } break;
case 22:
# line 70 "cmd.y"
{ yyval = tnode(GO, yypvt[-0], 0, 0); } break;
case 23:
# line 71 "cmd.y"
{ yyval = tnode(CONT, 0, yypvt[-0], 0); } break;
case 24:
# line 72 "cmd.y"
{ yyval = tnode(CONT, 0, 0, 0); } break;
case 25:
# line 73 "cmd.y"
{ yyval = tnode(SS, 0, yypvt[-1], yypvt[-0]); } break;
case 26:
# line 74 "cmd.y"
{ yyval = tnode(SS, 0, 0, yypvt[-0]); } break;
case 27:
# line 75 "cmd.y"
{ yyval = tnode(SS, 0, yypvt[-0], 0); } break;
case 28:
# line 76 "cmd.y"
{ yyval = tnode(SS, 0, 0, 0); } break;
case 29:
# line 77 "cmd.y"
{ yyval = tnode(SAVE, yypvt[-0], yypvt[-1], 0); } break;
case 30:
# line 78 "cmd.y"
{ yyval = tnode(SAVE, 0, yypvt[-0], 0); } break;
case 31:
# line 79 "cmd.y"
{ yyval = tnode(SAVE, 0, 0, 0); } break;
case 32:
# line 80 "cmd.y"
{ yyval = tnode(RST, 0, yypvt[-0], 0); } break;
case 33:
# line 81 "cmd.y"
{ yyval = tnode(RST, 0, 0, 0); } break;
case 34:
# line 82 "cmd.y"
{ yyval = tnode(COPY, yypvt[-0], 0, 0); } break;
case 35:
# line 83 "cmd.y"
{ yyval = tnode(BREAKS, 0, 0, 0); } break;
case 36:
# line 84 "cmd.y"
{ yyval = tnode(CLEAR, 0, yypvt[-0], 0); } break;
case 37:
# line 85 "cmd.y"
{ yyval = tnode(CLEAR, 0, 0, 0); } break;
case 38:
# line 86 "cmd.y"
{ yyval = tnode(REDIR, yypvt[-0], 0, 0); } break;
case 39:
# line 87 "cmd.y"
{ yyval = tnode(DO, yypvt[-0], 0, 0); } break;
case 40:
# line 88 "cmd.y"
{ yyval = tnode(SYSTEM, yypvt[-0], 0, 0); } break;
case 41:
# line 89 "cmd.y"
{ argsflag++; } break;
case 42:
# line 90 "cmd.y"
{ if (argsflag) argsflag--; yyval = tnode(MACRO, yypvt[-2], yypvt[-1], yypvt[-0]); } break;
case 43:
# line 91 "cmd.y"
{ yyval = tnode(XCTMACRO, yypvt[-1], yypvt[-0], 0); } break;
case 45:
# line 93 "cmd.y"
{ synerr(); yyval = 0; } break;
case 46:
# line 94 "cmd.y"
{ yyval = 0; } break;
case 47:
# line 95 "cmd.y"
{ yyval = 0; } break;
case 48:
# line 98 "cmd.y"
{ yyval = yypvt[-0]; } break;
case 49:
# line 99 "cmd.y"
{ yyval = 0; } break;
case 50:
# line 102 "cmd.y"
{ yyval = yypvt[-1]; } break;
case 51:
# line 103 "cmd.y"
{ yyval = yypvt[-2]; } break;
case 52:
# line 106 "cmd.y"
{ argsflag++; } break;
case 53:
# line 107 "cmd.y"
{ argsflag--; yyval = yypvt[-1]; } break;
case 54:
# line 110 "cmd.y"
{ yyval = tnode(ARGS, 0, yypvt[-0], yypvt[-2]); } break;
case 55:
# line 111 "cmd.y"
{ yyval = tnode(ARGS, 0, yypvt[-0], 0); } break;
case 57:
# line 115 "cmd.y"
{ yyval = 0; } break;
case 58:
# line 118 "cmd.y"
{ yyval = tnode(';', 0, yypvt[-2], yypvt[-0]); } break;
case 61:
# line 123 "cmd.y"
{ yyval = tnode(SYMBOL, yypvt[-0], 0, 0); } break;
case 62:
# line 124 "cmd.y"
{ yyval = tnode(LSYMBOL, yypvt[-0], 0, 0); } break;
case 63:
# line 125 "cmd.y"
{ yyval = tnode(DSYMBOL, yypvt[-0], 0, 0); } break;
case 64:
# line 126 "cmd.y"
{ yyval = tnode(REG, yypvt[-0], 0, 0); } break;
case 65:
# line 127 "cmd.y"
{ yyval = tnode('+', 0, yypvt[-2], yypvt[-0]); } break;
case 66:
# line 128 "cmd.y"
{ yyval = tnode('-', 0, yypvt[-2], yypvt[-0]); } break;
case 67:
# line 129 "cmd.y"
{ yyval = tnode('*', 0, yypvt[-2], yypvt[-0]); } break;
case 68:
# line 130 "cmd.y"
{ yyval = tnode(DIVIDE, 0, yypvt[-2], yypvt[-0]); } break;
case 69:
# line 131 "cmd.y"
{ yyval = tnode(EQ, 0, yypvt[-2], yypvt[-0]); } break;
case 70:
# line 132 "cmd.y"
{ yyval = tnode(NE, 0, yypvt[-2], yypvt[-0]); } break;
case 71:
# line 133 "cmd.y"
{ yyval = tnode('~', 0, yypvt[-0], 0); } break;
case 72:
# line 134 "cmd.y"
{ yyval = tnode('<', 0, yypvt[-2], yypvt[-0]); } break;
case 73:
# line 135 "cmd.y"
{ yyval = tnode(LE, 0, yypvt[-2], yypvt[-0]); } break;
case 74:
# line 136 "cmd.y"
{ yyval = tnode('>', 0, yypvt[-2], yypvt[-0]); } break;
case 75:
# line 137 "cmd.y"
{ yyval = tnode(GE, 0, yypvt[-2], yypvt[-0]); } break;
case 76:
# line 138 "cmd.y"
{ yyval = tnode(AND, 0, yypvt[-2], yypvt[-0]); } break;
case 77:
# line 139 "cmd.y"
{ yyval = tnode(OR, 0, yypvt[-2], yypvt[-0]); } break;
case 78:
# line 140 "cmd.y"
{ yyval = tnode('+', 0, yypvt[-2], yypvt[-0]); } break;
case 79:
# line 141 "cmd.y"
{ yyval = tnode('+', 0, yypvt[-3], yypvt[-1]); } break;
case 80:
# line 142 "cmd.y"
{ yyval = tnode(INDIR, 0, yypvt[-0], 0); } break;
case 81:
# line 143 "cmd.y"
{ yyval = yypvt[-1]; } break;
case 82:
# line 146 "cmd.y"
{ yyval = tnode(NUMBER, yypvt[-0], 0, 0); } break;
case 83:
# line 147 "cmd.y"
{ yyval = tnode(PATTERN, yypvt[-0], 0, 0); } break;
case 84:
# line 148 "cmd.y"
{ yyval = &dotnode; } break;
case 85:
# line 149 "cmd.y"
{ yyval = tnode(DOTDOT, 0, 0, 0); } break;
case 86:
# line 150 "cmd.y"
{ yyval = tnode('$', 0, 0, 0); } break;
case 87:
# line 151 "cmd.y"
{ yyval = tnode(ENTER, yypvt[-1], 0, 0); } break;
case 88:
# line 152 "cmd.y"
{ yyval = tnode(EXIT,  yypvt[-1], 0, 0); } break;
		}
		goto yystack;  /* stack new state and value */

	}
