/*
*  Synopsis: ident [-u userid] [-d dept] [-n name]
*                  [-o office] [-p phone]
*
*  With no arguments, ident displays the current user's identity
*  record.  If arguments are given, it updates the record with
*  the given information.
*
*  The -u flag allows specification of a different username (only
*  the super-user may update a different user's record).
*/
#include <stdio.h>
#include <pwd.h>
#include <signal.h>
#include <ctype.h>

char    tfile[] = "/tmp/itmp";
char    ifile[] = "/etc/identity";
FILE    *fid;
char    record[200];

int     updt, ruid;
int     dflg, nflg, oflg, pflg, mflg;
char    uname[10], name[50], office[12], phone[10], ms[10];
char    dept [10];
int     i;
struct  passwd *pw;
struct  passwd *getpwuid();

char    usage[] = "Usage: ident [-u userid] [-d dept] [-n name]";
char    usag2[] = "             [-o office] [-p phone] [-m mail-stop]";

struct rec {
        char usname[10];
        int  uid;
        int  gid;
        char rname[50];
        char rdept[10];
        char roffice[10];
        char rphone[10];
        char rms[10];
} rec;


main(argc, argv) char **argv;
{

        while(--argc > 0 && *argv[1]=='-') {
                argv++;
                while(*++*argv) switch(**argv) {
                        case 'd':
                                strcpy(dept, *++argv);
                                --argc;
                                ++updt;
                                ++dflg;
                                goto nextarg;
                        case 'n':
                                strcpy(name, *++argv);
                                --argc;
                                ++updt;
                                ++nflg;
                                while(*argv[0] && argc > 1 && *argv[1] && *argv[1]!='-') {
                                        strcat(name, " ");
                                        strcat(name, *++argv);
                                        --argc;
                                }
                                goto nextarg;
                        case 'o':
                                strcpy(office, *++argv);
                                --argc;
                                ++updt;
                                ++oflg;
                                goto nextarg;
                        case 'p':
                                strcpy(phone, *++argv);
                                --argc;
                                ++updt;
                                ++pflg;
                                goto nextarg;
                        case 'u':
                                strcpy(uname, *++argv);
                                --argc;
                                goto nextarg;
                        case 'm':
                                strcpy(ms, *++argv);
                                --argc;
                                ++updt;
                                ++mflg;
                                goto nextarg;
                        default:
                                printf("%s\n%s\n", usage, usag2);
                                exit(1);
                }
nextarg:        ;
        }

        if(argc != 0) {
                printf("%s\n%s\n", usage,usag2);
                exit(1);
        }
        ruid = getuid();
        if (uname[0] && updt && ruid!=0) {
                printf("Permission denied.\n");
                exit(1);
        }

        if (uname[0])
                i = getrec(uname);
        else {
                pw = getpwuid(ruid);
                if (pw==0){
                        printf("Not valid user.\n");
                        exit(1);
                }
	        else {
	                strcpy(uname, pw->pw_name);
	                i = getrec(uname);
		}
        }
        if (i==0) {
                printf("no identity file entry\n");
                exit(1);
        }

        if (!updt)
                display();
        else
                update();
        exit(0);
}


display()
{
        char line[200];

        rewind(fid);
        printf("%s", fgets(line, 200, fid));
        printf("%s", record);
}


update()
{
        char buf[200];
        int  len;
        FILE *tfd;

        verify();

        signal(SIGHUP,SIG_IGN);
        signal(SIGINT,SIG_IGN);
        signal(SIGQUIT,SIG_IGN);
        if (stat(tfile, buf) >= 0) {
                printf("Temporary file busy -- try again\n");
                exit(1);
        }
        if ((tfd = fopen(tfile, "w")) == NULL) {
                printf("Cannot open temporary file\n");
                exit(1);
        }
        rewind(fid);
        while (fgets(buf, 200, fid)!=NULL) {
                len = strlen(buf);
                if (buf[len-1]!='\n')
                        goto ill;
                if (eqname(uname, buf))
                        makerec(buf);
                fputs(buf, tfd);
        }
        fclose(tfd);
        fclose(fid);
        if ((tfd = fopen(tfile, "r")) == NULL) {
                printf("Urk\n");
                goto out;
        }
        if ((fid = fopen(ifile, "w")) == NULL) {
                printf("Cannot create /etc/identity file\n");
                goto out;
        }
        while (fgets(buf, 200, tfd) != NULL)
                fputs(buf, fid);
        fclose(fid);
        fclose(tfd);
        unlink(tfile);
        return;

ill:    printf("Identity file illformed!\n");
out:    unlink(tfile);
        exit(1);
}


eqname(s1, s2) char *s1, *s2;
{
        while(*s1++ == *s2++) ;
        if ((*--s1 == NULL)  &&  (*--s2 == ' '))
                return(1);
        return(0);
}


getrec(user) char *user;
{
        char n1[30], n2[30];

        fid = fopen(ifile, "r");
        if (fid == NULL) {
                printf("Cannot open /etc/identity file\n");
                exit(1);
        }
        while(fgets(record, 200, fid) != NULL) {
                if (eqname(user, record)) {
                        move(record, rec.usname, 10);
                        move(record+10, n1, 4);
                        move(record+15, n2, 4);
                        move(record+23, rec.rdept, 6);
                        move(record+31, rec.roffice, 9);
                        move(record+41, rec.rphone, 6);
                        move(record+47, rec.rms, 3);
                        move(record+53, rec.rname, strlen(record)-48);
                        n1[4]         = NULL;
                        n2[4]         = NULL;
                        rec.uid = atoi(strip(n1));
                        rec.gid = atoi(strip(n2));
                        strip(rec.usname);
                        strip(rec.rdept);
                        strip(rec.roffice);
                        strip(rec.rphone);
                        strip(rec.rname);
                        return(1);
                }
        }
        return(0);
}


makerec(buf) char *buf;
{
        sprintf(buf, "%-10s%4d/%-8d%-8s%-10s%-6s%-6s%s\n",
        rec.usname,
        rec.uid,
        rec.gid,
        rec.rdept,
        rec.roffice,
        rec.rphone,
        rec.rms,
        rec.rname);
}


verify()
{
        int  error;

        error = 0;
        if (pflg) {
                if (phone[0] && (strlen(phone)!=4 || !number(phone))) {
                        printf("Invalid phone extension=%s\n", phone);
                        error++;
                }
                strcpy(rec.rphone, phone);
        }
        if (oflg) {
                if (office[0] && strlen(office)>9) {
                        printf("Invalid office (too long)=%s\n", office);
                        error++;
                }
                strcpy(rec.roffice, office);
        }
        if (nflg) {
                strcpy(rec.rname, name);
        }
        if (dflg) {
                if (dept[0] && (strlen(dept)!=4 || !number(dept))) {
                        printf("Invalid dept=%s\n", dept);
                        error++;
                }
                strcpy(rec.rdept, dept);
        }
        if (mflg) {
                if (ms[0] && (strlen(ms)!=3 || !number(ms))) {
                        printf("Invalid m/s=%s\n", ms);
                        error++;
                }
                strcpy(rec.rms, ms);
        }
        if (error)
                exit(1);
}


number(s)  char *s;
{
        while (*s)
                if (!isdigit(*s++))
                        return(0);
        return(1);
}


char *strip(s) char *s;
{
        register char *t, *f;
        int fflag;

        t = f = s;
        fflag = 1;
        while(*f) {
                if (fflag && isspace(*f)) f++;
                else {
                        *t++ = *f++;
                        fflag = 0;
                }
        }
        *t-- = NULL;
        while (isspace(*t)) *t-- = NULL;
        return(s);
}
