/*
 * This file contains all the "new" stuff, i.e.
 * code not already present in ed.
 */

#include <stdio.h>
#include <sgtty.h>
#include <signal.h>
#include <setjmp.h>

#define getline(x)  ((char *) (x & ~01))  /* For historical reasons. */

#define NDISP   5              /* number of display formats */
#define NNPF    3              /* number of pf key levels */
#define NPF     30             /* number of pf keys */
#define PFSIZE  80             /* chars per pf key */
#define SCRWIDTH 74            /* screen width */
#define SCRHEIGHT 24           /* screen height */
#define NTABS   100            /* number of input tab stops */
#define ERRLEN  50             /* error messge length */
#define CMDLEN  100            /* length of saved primary commands */
#define CCLEN   256            /* length of -c primary commands */
#define MAXBLK  4095           /* max block no - for ed tmp file */
/* fs stuff */
#define ERW     0x05
#define WRB     0x01
#define RESTORE 0x02
#define ALARM   0x04
#define BRIGHT  0x08
#define PROT    0x30
#define PA1     25
#define PA2     26
#define TESTREQ 29
#define EOF     (-1)

int     itabs;
int     itab[NTABS];           /* input tabs */

/*
 * Line addresses from ed.
 */
extern  int     *zero;
extern  int     *dot;
extern  int     *dol;
extern  int     *addr1;
extern  int     *addr2;

extern  int     fchange;
extern  int     nlall;
extern  char    savedfile[];
int     bell;
int     mode = 0666;            /* file creation mode */

extern  int     fskp, fscol, fsrow;   /* fs stuff */

/*
 * Error message storage.
 */
char    errmsg[ERRLEN];
char    *errmsgptr = errmsg;

/*
 * Command redisplay.
 */
char    savecmd[CMDLEN];
char    nextcmd[CMDLEN];
char    ccmds[CCLEN];

/*
 * Addresses of lines on the screen.
 */
int     n_scraddr;               /* actual number of lines displayed */
int     *scraddr[SCRHEIGHT + 2]; /* addrs of lines on screen */

/*
 * Control of cursor positioning.
 */
int     *cur_addr;
int     *null_addr;
int     cur_rowcol;
int     eolflg;                /* for 'Pe' cmd */

/*
 * Autosave stuff.
 */
int     alt;                   /* alt count */
int     A = 15;                /* autosave count */
char    autofile[] = "ned.autoXXXXXX";
char    autotmp1[] = "ned.tmp1XXXXXX";
char    autotmp2[] = "ned.tmp2XXXXXX";

int     shift;                 /* data left shift */
int     *line_addr;            /* needed in dolines */
int     *z_addr;               /* addr of z line cmd */
int     z_mode;                /* z mode flag */
int     spf;                   /* "super" pf number */
char    *Ffile = 0;            /* file name for F cmd */
int     listf;                 /* flag for 'l' primary command */
int     nskip;                 /* passed from linecmd to dolines */
int     dotpri;                /* priority for placing dot */
int     curpri;                /* priority for placing cursor */

int     roflg;                 /* read only flag */
int     rc;                    /* return code */
int     debug;                 /* debug mode */

int     cols;                  /* display cols flag */
char    *colp = "----+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2----+----3----+----4----+----5----+----6----+----7----+";

int     amode;                 /* append moce */
int     imode;                 /* insert mode */
int     cmode;                 /* change mode */

int     K;                     /* COI or Memorex flag */
int     N;                     /* Nulls or nonulls flag */
int     U;                     /* Uppercase flag */
int     V = 1;                 /* Verbose flag */
int     Z = 1;                 /* Dot display line */
extern  jmp_buf savej;

/*
 * Variables for double char line commands.
 */
int     *dbla1;
int     *dbla2;
int     *dbltgt;
int     *dblbef;
int     dblnum;
char    dblcmd;
int     *jaddr1;
int     *jaddr2;
char    jcmd;

extern char *cmdname;

struct  disp_parms {           /* screen display parameters */
	int     fn_row;        /* filename row, col */
	int     fn_col;
	int     cmd_row;       /* primary command row, col */
	int     cmd_col;
	int     arrow_flg;     /* ==> for primary command flag */
	int     err_row;       /* error message row, col */
	int     err_col;
	int     line_row;      /* first data line row, col */
	int     line_col;
	int     num_lines;     /* number of lines */
	int     num_col;       /* line number column */
	int     num_flg;       /* line numbers displayed? */
	int     lno_row;       /* number of lines in buffer row, col */
	int     lno_col;
	int     alt_flg;       /* display "Alt" before alt count? */
	int     alt_row;       /* alt count row, col */
	int     alt_col;
}       disp_parms[NDISP] = {
			    /*  fn     cmd  a   err   line  lines num flg  lno     alt    */
			       0, 0, 0,  0,  0, 0, 40, 1, 0,  23,  75, 0, 0, 0,  0, 0, 0,
			       0, 3, 1,  4,  1, 0, 30, 2, 0,  22,  75, 1, 0, 70, 1, 0, 55,
			       0, 3, 1,  4,  1, 0, 30, 2, 5,  22,  0,  1, 0, 70, 1, 0, 55,
			       0, 0, 0,  0,  0, 0, 40, 1, 0,  23,  75, 0, 0, 0,  0, 0, 75,
			       0, 0, 0,  0,  0, 0, 40, 1, 0,  22,  75, 0, 0, 0,  0, 0, 0,
};
struct  disp_parms *d;
int     disp_no = 1;           /* display number */

char    pf[NNPF][NPF+1][PFSIZE] = {      /* pf key strings */
/* pf level 0 */
			    "", ";H",   "n",    ";x;q", /* 3 */
				";??",  ";//",  "s",    /* 6 */
				";-11", ";+11", "j",    /* 9 */
				";L8",  ";R8",  ";Ph",  /* 12 */
				"",     "",     "",     /* 15 */
				"",     "",     "",     /* 18 */
				"",     "",     "",     /* 21 */
				"",     "",     "",     /* 24 */
				"",     "",     "",     /* 27 */
				"",     ";q",   "",     /* 30 */
/* pf level 1 */
			    "", "",     "",     "",     /* 3 */
				"",     "",     "",     /* 6 */
				";-22", ";+22", "",     /* 9 */
				";L16", ";R16", "",     /* 12 */
				"",     "",     "",     /* 15 */
				"",     "",     "",     /* 18 */
				"",     "",     "",     /* 21 */
				"",     "",     "",     /* 24 */
				"",     "",     "",     /* 27 */
				"",     "",     "",     /* 30 */
/* pf level 2 */
			    "", "",     "",     "",     /* 3 */
				"",     "",     "",     /* 6 */
				";-44", ";+44", "",     /* 9 */
				";L32", ";R32", "",     /* 12 */
				"",     "",     "",     /* 15 */
				"",     "",     "",     /* 18 */
				"",     "",     "",     /* 21 */
				"",     "",     "",     /* 24 */
				"",     "",     "",     /* 27 */
				"",     "",     "",     /* 30 */
};

/* These make lint happy. */
extern char *trie();
extern char *trei();
extern char *mknum();
extern char *fsgetfld();
extern char *transline();
extern char *malloc();
extern char *puttabs();

main(argc, argv)
int     argc;
char    **argv;
{
	int     dodotned;
	char    tmp[100];
	struct  sgttyb tty_data;
	extern  int io, kflag, xflag, getfile();
	extern  char perm[], key[];

	setbuf(stdout, (char *) NULL);
	/*
	 * Ed startup.
	 */
	zero = (int *) malloc(nlall * sizeof(int));
	if (zero == NULL) {
		printf("%s: malloc: insufficient memory\n", cmdname);
		exit(2);
	}
	init();
	/*
	 * Set double chars off if Memorex tube.
	 */
	if (gtty(2, &tty_data) == 0 && (tty_data.sg_flags & ODBL) == 0)
		K = 1;
	dodotned = 1;
	/*
	 * Process arguments.
	 */
	argc--;
	argv++;
	while (argc && argv[0][0] == '-') {
		switch (argv[0][1]) {
		case '\0':
			io = 0;
			if (setjmp(savej) == 0)
				append(getfile, zero);
			dot = zero;
			io = -1;
			fchange = 0;
			argc--;
			argv++;
			break;

		case 'd':
			debug = 1;
			argc--;
			argv++;
			break;

		case 'p':
			dodotned = 0;
			argc--;
			argv++;
			break;

		case 'r':
			roflg++;
			argc--;
			argv++;
			break;

		case 'x':
			getkey();
			xflag = 1;
			kflag = crinit(key, perm);
			argc--;
			argv++;
			break;

		case 'c':           /* primary command */
			if (argc > 1) {
				strcat(ccmds, argv[1]);
				strcat(ccmds, "\n");
				if (strlen(ccmds) > CCLEN) {
					printf("%s: -c commands too long.\n", cmdname);
					exit(2);
				}
				argc -= 2;
				argv += 2;
			} else {
				usage();
				exit(2);
			}
			break;

		case 'F':
			if (argc > 1) {
				Ffile = argv[1];
				argc -= 2;
				argv += 2;
			} else {
				usage();
				exit(2);
			}
			break;

		default:
			usage();
			exit(2);
			break;
		}
	}
	if (dodotned)
		dotned();
	if (argc) {        /* file argument */
		strcpy(tmp, "e ");
		strcat(tmp, *argv);
		if (setjmp(savej) == 0)
			edcmd(tmp);
	}
	if (Ffile) {
		strcpy(tmp, "F ");
		strcat(tmp, Ffile);
		if (setjmp(savej) == 0)
			edcmd(tmp);
	}
	if (ccmds[0])
		if (setjmp(savej) == 0)
			edcmd(ccmds);

	mktemp(autofile);
	mktemp(autotmp1);
	mktemp(autotmp2);

	sigsetup();
	for(;;) {
		generate();
		display();
		process();
	}
}

/*
 * Print ned usage message.
 */
usage()
{
	extern char *cmdname;

	printf("Usage: %s [-p] [-r] [-x] [-F filename] [-c command] [-] [filename]\n", cmdname);
}

/*
 * Execute the ned profile file.
 */
dotned()
{
	char    *cp;
	char    tmp[100];
	char    *getenv();

	if (setjmp(savej))
		return;
	strcpy(tmp, "F .ned");
	if (access(tmp+2, 4) == 0)
		edcmd(tmp);
	else {
		cp = getenv("HOME");
		if (cp != NULL) {
			strcpy(tmp+2, cp);
			strcat(tmp, "/.../ned");
			if (access(tmp+2, 4) == 0)
				edcmd(tmp);
		}
	}
}

/*
 * If zero moves, many addresses must be changed.
 */
newzero(delta)
register int delta;
{
	register int i;

	for (i = 0; i < SCRHEIGHT + 2; i++)
		if (scraddr[i])
			scraddr[i] += delta;
	if (cur_addr)
		cur_addr += delta;
	if (null_addr)
		null_addr += delta;
	if (z_addr)
		z_addr += delta;
	if (dbla1)
		dbla1 += delta;
	if (dbla2)
		dbla2 += delta;
	if (dbltgt)
		dbltgt += delta;
	if (dblbef)
		dblbef += delta;
	if (line_addr)
		line_addr += delta;
	if (jaddr1)
		jaddr1 += delta;
	if (jaddr2)
		jaddr2 += delta;
}

/*
 * Generate a screen image.
 */
generate()
{
	if (debug)
		printf("Generate entered.\n");
	fsbfinit(RESTORE + (bell ? ALARM : 0));
	bell = 0;
	d = &disp_parms[disp_no];
	n_scraddr = d->num_lines - cols;
/* why is dot control such a mess?? */
	if (dot < zero || dot > dol || (dot == zero && !amode && !cmode && !imode))
		if (zero < dol)
			dot = zero + 1;
		else
			dot = zero;
	mkhdr();
	decide();
	putcursor();
	if (debug)
		printf("Generate calling translate.\n");
	translate();
}

/*
 * Make the header - the top part of the screen above the data.
 */
mkhdr()
{
	int     row, col;
	char    str[15];

	if (d->arrow_flg) {
		col = d->cmd_col - 4;
		row = d->cmd_row;
		if (col < 0) {
			col += 80;
			row -= 1;
			if (row < 0)
				row += 24;
		}
		fsputfld("==>", row, col, 3, BRIGHT + PROT);
	}
	fsputfld(trie(nextcmd), d->cmd_row, d->cmd_col, 45, 0);
	if (d->fn_col)
		fsputfld(savedfile, d->fn_row, d->fn_col, 40, BRIGHT);
	if (d->lno_col) {
		if (dol - zero == 1)
			fsputfld("1 line", d->lno_row, d->lno_col, 10, BRIGHT + PROT);
		else {
			sprintf(str, "%d Lines", dol - zero);
			fsputfld(str, d->lno_row, d->lno_col, 10, BRIGHT + PROT);
		}
	}
	if (d->alt_col) {
		if (d->alt_flg) {
			sprintf(str, "Alt %d", alt);
			fsputfld(str, d->alt_row, d->alt_col, 10, BRIGHT + PROT);
		} else {
			sprintf(str, "%d", alt);
			fsputfld(str, d->alt_row, d->alt_col, 10, BRIGHT + PROT);
		}
	}
	*errmsgptr = '\0';
	if (errmsg[0] == '\0' && (dbla1 || dbla2 || dbltgt))
		strcpy(errmsg, "Block command pending.");
	if (errmsg[0]) {
		if (savecmd[0] && errmsgptr < &errmsg[ERRLEN-5]) {
			if (errmsgptr[-1] == '.')
				*--errmsgptr = '\0';
			strcat(errmsg, ": ");
			strncat(errmsg, savecmd, ERRLEN - (errmsgptr - errmsg) - 1);
		}
		fsputfld(trie(errmsg), d->err_row, d->err_col, 35, BRIGHT + PROT);
		errmsgptr = errmsg;
		errmsg[0] = '\0';
	}
	savecmd[0] = '\0';
	if (cols)
		fsputfld(&colp[shift%100], d->line_row, d->line_col, SCRWIDTH, PROT);
}

/*
 * Decide where to put the cursor.
 * Unbelievably complicated, yet still makes mistakes.
 */
putcursor()
{
	int     row, mincol, maxcol;

	fscol -= shift;
	if (cur_rowcol) {
		fscursor(cur_rowcol);
		cur_rowcol = 0;
		return;
	}
	if (amode) {
		row = d->line_row + cols + 1;
		fscol = 0;
	} else if (cmode) {
		row = d->line_row + cols;
		fscol = 0;
	} else if (imode) {
		row = d->line_row + cols;
		fscol = 0;
	} else if (z_addr) {
		for (row = n_scraddr; row > 0; row--)
			if (scraddr[row] == z_addr)
				break;
		row += d->line_row + cols;
		fscol = d->line_col;
		if (fscol > 80)
			fscol -= 80;
	} else {
		for (row = n_scraddr; row > 0; row--)
			if (scraddr[row] == cur_addr)
				break;
		if (row && cur_addr > zero && cur_addr <= dol) {
			row += d->line_row + cols - 1;
			if (d->line_col > d->num_col) {
				maxcol = 79;
				mincol = d->line_col;
			} else {
				maxcol = d->num_col - 1;
				mincol = 0;
			}
			if (eolflg) {
				if (setjmp(savej)) {  /* in case getline bombs */
					if (fscol < mincol || fscol > maxcol)
						fscol = mincol;
				} else {
					fscol = strlen(trie(getline(*cur_addr))) - shift + d->line_col;
					if (fscol > maxcol)
						fscol = maxcol;
					if (fscol < mincol)
						fscol = mincol;
				}
				eolflg = 0;
			} else {
				if (fscol < mincol || fscol > maxcol)
					fscol = mincol;
			}
		} else {
			row = d->cmd_row;
			fscol = d->cmd_col + strlen(nextcmd);
		}
	}
	if (fscol >= 80) {
		fscol -= 80;
		row += 1;
		if (row >= 24)
			row -= 24;
	}
	fscursor(row * 80 + fscol);
}

/*
 * Decide what lines to put on the screen.
 * Put the line addresses into the scraddr array.
 */
decide()
{
	int     *addr;
	int     i;

	if (dot < zero && dol > zero)
		dot = zero + 1;
	if (amode || cmode || imode) {
		for (i = 1; i <= n_scraddr; i++)
			scraddr[i] = NULL;
		if (dot == zero) {
			scraddr[0] = zero;
		} else if (amode) {
			scraddr[1] = dot;
			scraddr[0] = dot - 1;
		} else if (cmode) {
			scraddr[0] = dot - 1;
		} else if (imode) {
			scraddr[0] = dot- 1;
			scraddr[n_scraddr] = dot;
		}
	} else {
		if (z_addr == dot - Z + n_scraddr)
			dot++;
		/* at dot and above */
		addr = dot;
		i = Z;
		while (i && addr != zero) {
			scraddr[i--] = addr--;
			if (addr == z_addr)
				scraddr[i--] = NULL;
		}
		if (addr == zero)
			while (i)
				scraddr[i--] = NULL;
		scraddr[i] = addr;
		/* below dot */
		i = Z + 1;
		if (z_addr == dot)
			scraddr[i++] = NULL;
		addr = dot + 1;
		while (i <= n_scraddr && addr <= dol) {
			scraddr[i++] = addr;
			if (addr++ == z_addr)
				scraddr[i++] = NULL;
		}
		if (addr > dol)
			while (i <= n_scraddr)
				scraddr[i++] = NULL;
	}
}

/*
 * Translate the lines to EBCDIC and pass them to quickscreen.
 */
translate()
{
	char    *ip, *op;
	int     *a1;
	int     i, j, l, n;

	if (setjmp(savej))
		nederr("Internal error in translate.");

	for(i = 1; i <= n_scraddr; i++) {
		a1 = scraddr[i];
		if (a1 == NULL)
			ip = "";
		else
			ip = getline(*a1);
		op = trie(ip);
		n = shift;
		while(n-- && *op)
			op++;
		l = strlen(op);
		if (N && null_addr != a1)
			for (j = l; j < SCRWIDTH + 5; j++)
				op[j] = ' ';
		if (a1 == NULL)
			fsputfld(op, i - 1 + d->line_row + cols, 0, 79, 0);
		else {
			fsputfld(op, i - 1 + d->line_row + cols, d->line_col, SCRWIDTH, 0);
			op = mknum(a1, d->num_flg);
			if (a1 == dot && Z > 1) {
				*op = '.';
				*(op + 1) = ' ';
			}
			if (l > SCRWIDTH) {
				*op = '*';
				*(op + 1) = ' ';
			}
			if (a1 == dbla1 || a1 == dbla2) {
				*op = dblcmd;
				if (dbla1 != dbla2)
					*(op + 1) = dblcmd;
			}
			if (a1 == dbltgt)
				*op = 't';
			if (a1 == dblbef)
				*op = 'b';
			fsputfld(op, i - 1 + d->line_row + cols, d->num_col, 78 - SCRWIDTH, BRIGHT);
		}
	}
	null_addr = 0;
}

/*
 * Make line command area.
 */
char *
mknum(a1, numflg)
int     *a1, numflg;
{
	int     n;
	char    *cp;
	static  char buf[5];

	*(cp = buf + 4) = '\0';
	if ((n = a1 - zero) < 0 || numflg == 0)
		while (--cp >= buf)
			*cp = '\0';
	else
		while (--cp >= buf) {
			*cp = n % 10 + '0';
			n = n / 10;
		}
	return (buf);
}

/*
 * Diaplay screen, read in user's response.
 */
display()
{
	if (debug)
		printf("display\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
	fswrite(ERW);
	fsread();
	while (fskp == PA1 || fskp == PA2) {
		switch (fskp) {
		case PA1:
			spf = 1;
			break;
		case PA2:
			spf = 2;
			break;
		}
		fsbfinit(RESTORE);
		fswrite(WRB);
		fsread();
	}
	if (debug)
		fsclose();
}

/*
 * Process the user's input.
 */
process()
{
	char    *p, *cp, *cp2;
	char    buf[100];
	static char lastcmd[100];

	if (debug)
		printf("Process entered.\n");
	listf = 0;
	/*
	 * New filename?
	 */
	if (d->fn_col && (cp = fsgetfld(d->fn_row, d->fn_col))) {
		cp2 = savedfile;
		while (*cp2++ = *cp++)
			;
		cp2--;  /* trim trailing blanks */
		while (*--cp2 == ' ')
			;
		*++cp2 = '\0';
		alt++;
		fchange = 1;
	}
	/*
	 * Process changed lines.
	 */
	if (setjmp(savej) == 0) {
		dolines();
		dodbl();
	} else
		nederr(errmsg);
	if (jcmd) {            /* This is a bit of a kluge. */
		nedjoin(jcmd, jaddr1, jaddr2);
		if (curpospri(3))
			cur_addr = jaddr1;
		jcmd = '\0';
		jaddr1 = jaddr2 = NULL;
	}
	/*
	 * Process primary command.
	 */
	p = fsgetfld(d->cmd_row, d->cmd_col);
	if (p)
		p = trei(p, 0);
	else
		strcpy(p = buf, nextcmd);
	nextcmd[0] = '\0';
	if (p[0] == '&' && p[1] == '\0')
		strcpy(nextcmd, lastcmd);
	else if (p[0] == '&') {
		strcpy(nextcmd, p);
		strcpy(lastcmd, p);
		if (setjmp(savej) == 0)
			edcmd(p + 1);
	} else if (p[0]) {
		if (setjmp(savej) == 0) {
			edcmd(p);
			strcpy(lastcmd, p);
		} else
			strcpy(nextcmd, p);
	}
	/*
	 * Finally, process pf key and do autosave.
	 */
	if (setjmp(savej) == 0)
		dopf();
	if (A && alt >= A)
		autosave();
}

/*
 * Process changed lines.
 */
dolines()
{
	int     i, offset, n, irow;
	char    *cp;

	if (debug)
		printf("dolines.\n");
	line_addr = scraddr[0];
	fscol += shift;
	irow = fsrow + 1 - d->line_row - cols;
	z_mode = 0;
	dotpri = 0;   /* where should this really be? */
	curpri = 0;   /* this too */
	cur_addr = 0;
	offset = 0;
	for (i = 1; i <= n_scraddr; i++) {
		if (scraddr[i] == NULL) { 	/* New line */
			if (cp = fsgetfld(d->line_row + i - 1 + cols, 0)) {
				/* line entered */
				cp = transline((int *)NULL, cp);
				addline(cp, line_addr);
				if (amode || cmode)
					newdot(line_addr + 1, 5);
				else if (imode)
					newdot(line_addr + 2, 5);
				if (z_addr == line_addr) {
					z_mode = 1;
					z_addr = line_addr + 1;
				}
				offset++;
				line_addr++;
				alt++;
				fchange = 1;
			}
		} else { 	/* existing line */
			line_addr = scraddr[i] + offset;
			if (i == Z)
				newdot(line_addr, 1);
			if (cp = fsgetfld(d->line_row + i - 1 + cols, d->line_col)) {
				/* line changed */
				cp = transline(line_addr, cp);
				replline(cp, line_addr);
				alt++;
				fchange = 1;
			}
			if (irow == i && pf[spf][fskp][0] && pf[spf][fskp][0] != ';') {
				/* pf key line command */
				n = linecmd(pf[spf][fskp], line_addr);
				offset += n;
				line_addr += n;
			} else if (cp = fsgetfld(d->line_row + i - 1 + cols, d->num_col)) {
				/* user entered line command */
				n = linecmd(cp, line_addr);
				offset += n;
				line_addr += n;
			}
		}
		if (irow == i && curpospri(1))
			cur_addr = line_addr;
		i += nskip;
		nskip = 0;
	}
	if (z_mode == 0)
		z_addr = NULL;
	if (amode || cmode || imode) {
		curpospri(7);
		cur_addr = 0;
		amode = cmode = imode = 0;
	}
}

/*
 * Set new dot value, taking priority into account.
 */
newdot(addr, pri)
int *addr;
int pri;
{
	if (pri >= dotpri) {
		dotpri = pri;
		dot = addr;
	}
}

/*
 * Decide whether cursor should be repositioned, based on priority.
 */
curpospri(pri)
int pri;
{
	if (pri > curpri) {
		curpri = pri;
		return(1);
	} else
		return(0);
}

/*
 * Process changed line.
 */
char *
transline(addr, newp)
int     *addr;
char    *newp;
{
	int     oldlen, newlen;
	static  char out[512];
	char    *oldp;
	char    old[512], new[512];
	int     i, j, k;

	/* fetch old copy of addressed line */
	if (addr > zero && addr <= dol)
		oldp = getline(*addr);
	else
		oldp = "";
	/* translate to external form, and expand tabs */
	expand(trie(oldp), old);
	/* expand tabs of new line */
	if (itabs > 0)
		expandi(newp, new);
	else
		expand(newp, new);
	oldlen = strlen(old);
	newlen = strlen(new);
	i = j = 0;
	/* handle part of line to left of screen */
	if (shift > 0)
		if (oldlen < shift) {
			for (; i < oldlen; i++)
				out[i] = old[i];
			for (; i < shift; i++)
				out[i] = ' ';
		} else
			for (; i < shift; i++)
				out[i] = old[i];
	/* handle part of line on screen */
	while (j < newlen)
		out[i++] = new[j++];
	/* handle part of line to right of screen */
	if (oldlen > shift + SCRWIDTH) {
		while (i < shift + SCRWIDTH)
			out[i++] = ' ';
		j = shift + SCRWIDTH;
		while (j < oldlen)
			out[i++] = old[j++];
	}
	/* remove trailing blanks */
	while (--i >= 0 && out[i] == ' ')
		;
	out[++i] = '\0';
	if (itabs == 0 && (*oldp == '\t' || *newp == '\t'))
		return(trei(puttabs(out), 1));
	else
		return(trei(out, 1));
}

char *
puttabs(cp)
char cp[];
{
	register i, ntabs;

	i = 0;
	while(cp[i] == ' ')
		i++;
	ntabs = i/8;
	i = ntabs * 8;
	while (ntabs--)
		cp[--i] = '\t';
	return(&cp[i]);
}

expand(in, out)
register char *in, *out;
{
	register char c, *op;
	register n;

	op = out;
	while (c = *in++) {
		if (c == '\t') {
			n = 8 - (op - out + shift) % 8;
			while (n--)
				*op++ = ' ';
		} else
			*op++ = c;
	}
	*op = '\0';
}

expandi(in, out)
char    *in, *out;
{
	int     i, j, k;
	char    c;

	i = j = 0;
	while (c = in[i++])
		if (c == '\t') {
			k = itabstop(j);
			while (j < k)
				out[j++] = ' ';
		} else
			out[j++] = c;
	out[j] = '\0';
}

itabstop(t)
int     t;
{
	int     i;

	t++;
	for (i = 0; i < itabs; i++)
		if (itab[i] > t)
			break;
	if (i >= itabs)
		return(t);
	else
		return(itab[i] - 1);
}

/*
 * Process line command.
 */
linecmd(cp, addr)
char    *cp;
int     *addr;
{
	int     n, ret;

	ret = n = 0;
	while (*cp >= '0' && *cp <= '9')
		n = 10 * n + *cp++ - '0';
	switch(*cp) {
	case ' ':
	case '\0':
		if (addr == dbla1)
			dbla1 = 0;
		if (addr == dbla2)
			dbla2 = 0;
		if (addr == dbltgt)
			dbltgt = 0;
		if (addr == dblbef)
			dblbef = 0;
		if (dbla1 == 0)
			if (dbla2) {
				dbla1 = dbla2;
				dbla2 = 0;
			} else
				dblcmd = '\0';
		break;
	case 'a':
		if (n == 0)
			n = 1;
		ret = n;
		alt++;
		fchange = 1;
		while (n--)
			addr += addline("", addr);
		if (curpospri(5)) {
			cur_addr = addr + 1;
			fscol = 0;
		}
		break;
	case 'b':
		dblbef = addr;
		break;
	case 'c':
		dbl('c', addr);
		if (*++cp != 'c')
			dbl('c', addr);
		break;
	case 'd':
		if (n == 0)
			n = 1;
		if (*++cp == 'd')
			dbl('d', addr);
		else {
			ret = -n;
			nskip = n - 1;
			delline(addr, n);
			if (curpospri(3))
				cur_addr = addr;
		}
		break;
	case 'i':
		if (n == 0)
			n = 1;
		ret = n;
		addr--;
		alt++;
		fchange = 1;
		while (n--)
			addr += addline("", addr);
		if (curpospri(5)) {
			cur_addr = addr + 1;
			fscol = 0;
		}
		break;
	case 'j':
		if (*++cp == 'j')
			dbl('j', addr);
		else {
			if (n < 2)
				n = 2;
			jcmd = 'j';
			jaddr1 = addr;
			jaddr2 = addr + n - 1;
		}
		break;
	case 'J':
		if (*++cp == 'J')
			dbl('J', addr);
		else {
			if (n < 2)
				n = 2;
			jcmd = 'J';
			jaddr1 = addr;
			jaddr2 = addr + n - 1;
		}
		break;
	case 'k':
		mark(*++cp, addr);
		break;
	case 'm':
		dbl('m', addr);
		if (*++cp != 'm')
			dbl('m', addr);
		break;
	case 'n':
		null_addr = addr;
		break;
	case 'r':
		if (*++cp == 'r') {
			dbl('r', addr);
			if (n)
				dblnum = n;
		} else {
			if (n == 0)
				n = 1;
			ret = n;
			alt++;
			fchange = 1;
			cp = getline(*addr);
			while (n--)
				addr += addline(cp, addr);
		}
		break;
	case 's':
		ret = split(addr);
		break;
	case 't':
		dbltgt = addr;
		break;
	case 'z':
		if (addr != NULL) {
			z_addr = addr;
			z_mode = 1;
		}
		break;
	case '>':
		if(*++cp == '>') {
			dbl('>', addr);
			if (n)
				dblnum = n;
		} else
			doshift(n ? n : 8, addr, addr);
		break;
	case '<':
		if(*++cp == '<') {
			dbl('<', addr);
			if (n)
				dblnum = n;
		} else
			doshift(n ? -n : -8, addr, addr);
		break;
	case '.':
		newdot(addr, 9);
		break;
	case ':':
		dot = addr - n_scraddr + Z;
		break;
	default:
		break;
	}
	return(ret);
}

/*
 * Read and remember double line command (block command).
 */
dbl(cmd, addr)
char    cmd;
int     *addr;
{
	if (dblcmd && dblcmd != cmd)
		return;
	dblcmd = cmd;
	if (dbla1 && dbla2 && (addr == dbla1 || addr == dbla2))
		return;
	if (dbla1 && addr > dbla1)
		dbla2 = addr;
	else {
		dbla2 = dbla1;
		dbla1 = addr;
	}
}

/*
 * Process double line command (block command).
 */
dodbl()
{
	if (debug)
		printf("dodbl\n");
	if (setjmp(savej))
		return;
	if (dbla1 && dbla2) {
		switch (dblcmd) {
		case 'd':
			delline(dbla1, dbla2 - dbla1 + 1);
			if (dbla1 >= dot && dbla1 <= dot + 22 && curpospri(3))
			       cur_addr = dbla1;
			if (dot >= dbla1 && dot <= dbla2)
				dot = dbla1 - 1;
			break;
		case 'c':
			if (dbltgt != 0)
				nedmove(1, dbla1, dbla2, dbltgt);
			else if (dblbef != 0)
				nedmove(1, dbla1, dbla2, dblbef-1);
			else
				return;
			if (dot >= dbla1 && dot <= dbla2)
				dot = dbla1 - 1;
			break;
		case 'j':
		case 'J':
			jcmd = dblcmd;
			jaddr1 = dbla1;
			jaddr2 = dbla2;
			break;
		case 'm':
			if (dbltgt != 0)
				nedmove(0, dbla1, dbla2, dbltgt);
			else if (dblbef != 0)
				nedmove(0, dbla1, dbla2, dblbef-1);
			else
				return;
			if (dot >= dbla1 && dot <= dbla2)
				dot = dbla1 - 1;
			break;
		case 'r':
			if (dblnum < 1)
				dblnum = 1;
			while (dblnum--)
				nedmove(1, dbla1, dbla2, dbla2);
			break;
		case '>':
			doshift(dblnum? dblnum: 8, dbla1, dbla2);
			if (curpospri(3))
				cur_addr = dbla1;
			dblnum = 0;
			break;
		case '<':
			doshift(dblnum? -dblnum: -8, dbla1, dbla2);
			if (curpospri(3))
				cur_addr = dbla1;
			dblnum = 0;
			break;
		}
		dbla1 = dbla2 = dbltgt = dblbef = 0;
		dblcmd = '\0';
		dblnum = 0;
	}
}

/*
 * Do left or right shift command.
 * Should handle tabs much better.
 */
doshift(n, ad1, ad2)
int     n, *ad1, *ad2;
{
	char    buf[512];
	char    *cp;
	int     i;

	alt++;
	fchange = 1;
	if (n < 0) {
		n = -n;
		while (ad1 <= ad2) {
			expand(cp = getline(*ad1), buf);
			for (i = 0; i < n; i++)
				if (buf[i] == '\0')
					break;
			if (itabs == 0 && *cp == '\t')
				replline(puttabs(&buf[i]), ad1);
			else
			        replline(&buf[i], ad1);
			ad1++;
		}
	} else {
		while (ad1 <= ad2) {
			for (i = 0; i < n; i++)
				buf[i] = ' ';
			expand(cp = getline(*ad1), &buf[n]);
			if (buf[n]) {
				if (itabs == 0 && *cp == '\t')
				        replline(puttabs(buf), ad1);
				else
				        replline(buf, ad1);
			} else
				replline("", ad1);
			ad1++;
		}
	}
}

/*
 * Split a line.
 */
split(addr)
int     *addr;
{
	int     i, j, ntabs;
	char    buf[512], *cp;

	cp = getline(*addr);
	expand(trie(cp), buf);
	i = fscol - d->line_col;
	if (i < 0 || i > SCRWIDTH + shift)
		return(0);
	for (j = 0; j <= i; j++)
		if (buf[j] == '\0')
			return(0);
	if (itabs == 0 && *cp == '\t')
	        addr += addline(trei(puttabs(&buf[i]), 1), addr);
	else
	        addr += addline(trei(&buf[i], 1), addr);
	/*
	 * delete trailing blanks
	 */
	while (i && buf[i-1] == ' ') {
		i--;
		if (cur_addr == 0)
			fscol--;   /* back up cursor */
	}
	buf[i] = '\0';
	if (itabs == 0 && *cp == '\t')
		replline(trei(puttabs(buf), 1), addr);
	else
		replline(trei(buf, 1), addr);
	alt++;
	fchange = 1;
	if (curpospri(4))
		cur_addr = addr;
	return(1);
}

/*
 * Get a number.
 * This is a utility for the following primary command subroutines.
 */
getnum()
{
	char    c;
	int     n;

	n = 0;
	while ((c = gtchar()) == ' ')
		;
	if (c < '0' || c > '9') {
		ungtchar(c);
		return(-1);
	}
	do {
		n = n * 10 + c - '0';
		c = gtchar();
	} while (c >= '0' && c <= '9');
	ungtchar(c);
	return(n);
}

/*
 * Do the action associated with a pf key.
 */
dopf()
{
	char    *cp, *bp, buf[PFSIZE];

	cp = pf[spf][fskp];
	spf = 0;
	while (*cp && (*cp != ';' || *(cp-1) == '\\'))
		cp++;
	while (*cp++ == ';') {  /* This is necessary to get decent error messages. */
				/* Is it really??? */
		bp = buf;
		while (*cp && *cp != ';')
			if (*cp == '\\' && *(cp+1) == ';') {
				*bp++ = ';';
				cp += 2;
			} else
				*bp++ = *cp++;
		*bp = '\0';
		if (setjmp(savej)) {
		 /*     strcpy(savecmd, buf);  this looks bad */
			return;
		} else
			edcmd(buf);
	}
}

/*
 * Automatically save the buffer as appropriate.
 */
autosave()
{
	extern  int io, count;
	extern  int *addr1, *addr2;
	register fd;

	if (dol == zero) {   /* no need to write file */
		alt = 0;
		return;
	}
	if (setjmp(savej))
		return;
	fd = creat(autotmp1, 0666);
	if (fd < 0) {
		puts("Cannot creat ned.auto.");
		return;
	}
	/* copy file out */
	addr1 = zero + 1;
	addr2 = dol;
	io = fd;
	putfile();
	io = -1;
	/* reset counters */
	count = 0;
	alt = 0;
	/* file manipulation to be sure nothing is lost */
	link(autofile, autotmp2);  /* save old autofile */
	unlink(autofile);          /* necessary for next link to work */
	link(autotmp1, autofile);  /* link to new autofile */
	unlink(autotmp1);          /* remove unneeded link */
	sync();                    /* ensure new autofile on disk */
	unlink(autotmp2);          /* remove old autofile */
	close(fd);
}

pcmd()
{
	char    c, *cp;
	register n, i;

	if ((c = gtchar()) == 'f')
		c = gtchar();
	while(c == ' ')
		c = gtchar();
	if (c != '\n') {
		ungtchar(c);
		if ((n = getnum()) == -1)
			error("Invalif pf key number.");
		if (n % 100 >= NPF || n / 100 > NNPF)
			error("Invalid pf key number.");
		while ((c = gtchar()) == ' ')
			;
		cp = pf[n/100][n%100];
		n = PFSIZE - 1;
		while (n-- && c != '\n') {
			*cp++ = c;
			c = gtchar();
		}
		*cp = '\0';
		if (!n)
			error("Pf command too long.");
		strcpy(pf[n/100][n%100], trei(pf[n/100][n%100], 0));
	} else {
		for (i = 0; i < NPF; i++) {
			strcpy(pf[0][i], trie(pf[0][i]));
			strcpy(pf[1][i], trie(pf[1][i]));
			strcpy(pf[2][i], trie(pf[2][i]));
		}
		pfdisp(pf);
		for (i = 0; i < NPF; i++) {
			strcpy(pf[0][i], trei(pf[0][i], 0));
			strcpy(pf[1][i], trei(pf[1][i], 0));
			strcpy(pf[2][i], trei(pf[2][i], 0));
		}
	}
}

Acmd()
{
	int     n;
	char    c;

	if (( c = gtchar()) == '?')
		putd(A);
	else {
		ungtchar(c);
		if ((n = getnum()) == -1)
			error("Invalid autosave number.");
		else
			A = n;
	}
}

Dcmd()
{
	register c, n;

	if ((n = getnum()) == -1) {
		if ((c = gtchar()) == '=' || c == '?') {
			putd(disp_no);
			return;
		} else
			ungtchar(c);
		disp_no = (disp_no + 1) % NDISP;
		return;
	}
	if (n >= 0 && n < NDISP)
		disp_no = n;
	else
		error("Invalid display number.");
}

Fcmd()
{
	char    fname[100], *fp, buf[512];
	char    cmd[100], *cp;
	int     c, i, n, fd;

	fp = fname;
	while ((c = gtchar()) == ' ')
		;
	if (c == '\n')
		error("No filename.");
	*fp++ = c;
	while((c = gtchar()) != '\n' && c != ';') {
		if (c == '\\') {     /* allow escaped semicolon */
			c = gtchar();
			if (c != ';') {
				ungtchar(c);
				c = '\\';
			}
		}
		*fp++ = c;
	}
	*fp = '\0';
	if ((fd = open(fname, 0)) < 0)
		error("Cannot open Ffile.");
	i = n = 0;
	cp = cmd;
	for (;;) {
		if (i == n) {
			n = read (fd, buf, 512);
			if (n == 0)
				c = ';';
			else
				c = *buf;
			i = 1;
		} else
			c = buf[i++];
		if (c == '\n') {
			*cp = '\0';
			if (*cmd) {
				strcpy(savecmd, cmd);
				edcmd(cmd);
				*savecmd = '\0';
			}
			cp = cmd;
		} else
			*cp++ = c;
		if (n == 0)
			break;
	}
	close(fd);
}

Lcmd()
{
	int     n;

	if ((n = getnum()) == -1)
		error("Invalid shift amount.");
	shift -= n;
	if (shift < 0)
		shift = 0;
}

Rcmd()
{
	int     n;

	if ((n = getnum()) == -1)
		error("Invalid shift amount.");
	shift += n;
	if (shift > 511)
		shift = 511;
}

Pcmd()
{
	int     n1, n2;
	char    c;

	if ((n1 = getnum()) == -1) {
		if ((c = gtchar()) == 'h') {
			curpospri(9);
			cur_addr = NULL;
		} else if (c == 'e') {
			eolflg = 1;
		} else if (c == ',' && (n2 = getnum()) != -1)
			fscol = n2 - 1;
		else
			error("Invalid comand syntax.");
	} else
		if (gtchar() == ',' && (n2 = getnum()) != -1)
			cur_rowcol = (n1 - 1) * 80 + (n2 - 1);
		else
			error("Invalid command syntax.");
}

Scmd(ad1, ad2)
int     *ad1, *ad2;
{
	char    c;
	int     n;

	while((c = gtchar()) == ' ')
		;
	if (c == '-') {
		n = -getnum();
		if (n == 1)
			error("Invalid shift amount.");
	} else {
		ungtchar(c);
		n = getnum();
		if (n == -1)
			error("Iinvalid shift amount.");
	}
	doshift(n, ad1, ad2);
}

Tcmd()
{
	int     i, n;
	char    c;

	while((c = gtchar()) == ' ')
		;
	if (c == '?') {
		if (itabs == 0)
			puts("Normal tabs.");
		else {
			putd(itab[0]);
			for (i = 1; i < itabs; i++) {
				ptchar(',');
				putd(itab[i]);
			}
		}
		return;
	}
	ungtchar(c);
	n = getnum();
	if (n == -1)
		error("No argument.");
	else if (n == 0)
		itabs = 0;
	else {
		itabs = 0;
		itab[itabs++] = n;
		while((c = gtchar()) == ',' && itabs <= NTABS)
			if ((n = getnum()) <= 0)
				break;
			else
				itab[itabs++] = n;
		ungtchar(c);
	}
}

Zcmd()
{
	int     n;

	n = getnum();
	if (n > 0 && n < 22)
		Z = n;
	else
		error("Invalid line number.");
}
