/*
 * This file contains the global file declarations for the PLI command
 * external buffers.  These declarations should be more or less
 * identical to those in the pli.h file.
 */

#define MAXFILES 20

struct {  /* the parms information */
        char jobname[9],
             account[14],
             bin[4],
             userid[9],
             name[17],
             cputime[4],
             outclass[2],
             e1bldg[4],
             unixfile[51],
             plinpt1[45],
             plinpt2[45],
             object[45],
             linkin1[45],
             linkin2[45],
             loadmod[45],
             linkops[51],
             testdt1[45],
             testdt2[45],
             testdt3[45],
             datadd1[9],
             datadd2[9],
             datadd3[9],
             goops[51],
             cops [51],
             fill[149];  /* padding for possible future options   */
} pm;

struct df { /* the saved list of UNIX files and their member names */
        char filename[51],
             memb[9];
        int  ltime;
} dfiles[MAXFILES];

int cflag, lflag, gflag, sflag, rflag, qflag;   /* duh, flags */

int files[MAXFILES];  /* index to current entries in dfiles */
int filecnt;            /* the number of files the user gave  */
int outfile;            /* file descp. for temp outfile       */
int mode;               /* 0 for C, 1 for CL, 2 for CLG       */

extern char *logdir(), *logname();
