#include        <stdio.h>
#include        <errno.h>
#include        <signal.h>
#include	"defs.h"

extern  int     errno;

/* service routines for `execute' */


initio(iop)
register struct  ionod   *iop;
{
	register char	*ion;
	register int  iof, fd = -1;
	FILE    *tfp, *ifp, *fp = NULL;

	while (iop != NULL) {
		iof = iop->iofile;
		ion = mactrim(iop->ioname);
		if (*ion && (flags & NOEXEC)==0) {
			if (iof & IODOC) {
				tfp = tmpfil();
				ifp = chkopen(ion, "r");
				subst(ifp, tfp);
				fclose(ifp);
				fclose(tfp);
				fp = chkopen(tmpout, "r");
				/*
				 * This unlink is really slimmy.
				 * Since the file is open, it really
				 * doesn't go away until it is closed.
				 */
				unlink(tmpout);
			} else if (iof & IOMOV) {
				if (eq(minus, ion)) {
					fd = -1;
					close(iof & IOUFD);
				} else if ((fd = stoi(ion)) >= USERIO)
					failed(ion, badfile);
				else
					fd = dup(fd);
			} else if ((iof & IOPUT) == 0) {
				fp = chkopen(ion, "r");
			} else if (flags & RSHFLG) {
				failed(ion, restricted);
			} else if (iof & IOAPP) {
				fp = chkopen(ion, "a");
			} else {
				fp = chkopen(ion, "w");
			}
			if (fp != NULL) {
				movefd(fileno(fp), iof & IOUFD);
			}
			if (fd >= 0) {
				movefd(fd, iof & IOUFD);
			}
		}
		free(ion);
		iop = iop->ionxt;
	}
}

char    *
getpath(s)
register char	*s;
{
	if (any('/', s)) {
		if (flags & RSHFLG)
			failed(s, restricted);
		else
			return(nullstr);
	}
	else if (pathnod.namval == NULL) {
		return(defpath);
	}
	return(pathnod.namval);
}

FILE    *
pathopen(path, name)
register char	*path, *name;
{
	register FILE   *fp;

	do {
		path = catpath(path, name);
	} while (((fp = fopen(buf, "r")) == NULL) && (path != NULL));
	return(fp);
}

char    *
catpath(path, name)
register char	*path;
register char	*name;
{
	register char   *scanp = path;
	register char *bp = buf;

	while (*scanp && *scanp!=COLON)
		*bp++ = *scanp++;
	*bp = '\0';
	if (scanp != path)
		strcpy(bp, "/");
	if (*scanp == COLON)
		scanp++;
	strcat(bp, name);
	return(*scanp? scanp: NULL);
}

static char	*xecmsg;
static char	**xecenv;

execa(at)
register char	*at[];
{
	register char	*path;
	register char	**t = at;
	int     exname();

	if ((flags & NOEXEC) == 0) {
		xecmsg = notfound;
		path = getpath(*t);
		namscan(exname);
		xecenv = setenv();
		while (path = execs(path, t))
			;
		failed(*t, xecmsg);
	}
}

char     *
execs(ap, t)
register char	*ap;
register char   *t[];
{
	register char   *prefix;

	prefix = catpath(ap, t[0]);
	trim(buf);
	sigchk();
	execve(buf, &t[0] , xecenv);
	switch (errno) {

	case ENOEXEC:
		flags = 0;
		flin = 0;
		clearup();
		if ((cfp = fopen(buf, "r")) == NULL)
			failed(buf, badopen);
		cflg = 0;
		/* set up new args */
		setargs(t);
		longjmp(subshell, 1);

	case ENOMEM:
		failed(buf, toobig);

	case E2BIG:
		failed(buf, arglist);

	case ETXTBSY:
		failed(buf, txtbsy);

	default:
		xecmsg = badexec;
	case ENOENT:
		return(prefix);
	}
}

/* for processes to be waited for */
#define MAXP 20
static int  pwlist[MAXP];
static int  pwc;

postclr()
{
	register int  *pw = pwlist;

	while (pw <= &pwlist[pwc]) {
		*pw++ = 0;
	}
	pwc=0;
}

post(pcsid)
register int	pcsid;
{
	register int  *pw = pwlist;

	if (pcsid) {
		while (*pw) {
			pw++;
		}
		if (pwc >= MAXP-1) {
			pw--;
		}
		else {
			pwc++;
		}
		*pw = pcsid;
	}
}

await(i)
register int	i;
{
	int  rc=0, wx=0;
	int  w;
	int  ipwc = pwc;
	extern char *sys_siglist[];

	post(i);
	while (pwc) {
		register int  p;
		register int  sig;
		int  w_hi;

		{
			register int  *pw=pwlist;
			p=wait(&w);
			while (pw <= &pwlist[ipwc]) {
				if (*pw==p) {
					*pw=0;
					pwc--;
				}
				else {
					pw++;
				}
			}
		}

		if (p == -1) {
			continue;
		}

		w_hi = (w>>8)&LOBYTE;

		sig = w&0177;
		if (sig) {
			if (sig == 0177) {     /* ptrace return */
				fprintf(stderr, "ptrace: ");
				sig = w_hi;
			}
			if (sig != SIGINTR) {
				if (i != p || (flags & PROMPT) == 0) {
					prp();
					fprintf(stderr, "%d: ", p);
				}
				fprintf(stderr, "%s", sys_siglist[sig]);
				if (w&0200) {
					fprintf(stderr, "%s", coredump);
				}
			}
			putc('\n', stderr);
		}

		if (rc==0) {
			rc = (sig ? sig|SIGFLG : w_hi);
		}
		wx |= w;
	}

	if (wx && (flags & ERRFLG)) {
		exitsh(rc);
	}
	exitval=rc;
	exitset();
}

char	nosubst;

trim(at)
register char	*at;
{
	register char	*p;
	register char	c;
	register char	q=0;

	if (p=at) {
		while (c = *p) {
			*p++=c&STRIP;
			q |= c;
		}
	}
	nosubst=q&QUOTE;
}

char    *
mactrim(s)
register char	*s;
{
	register char	*t=macro(s);

	trim(t);
	return(t);
}

char    **
scan(argn)
register int	argn;
{
	register struct argnod  *argp = gchain;
	register struct  argnod  *nxtargp;
	register char   **comargn, **comargm;
	int     compar();

	comargn = (char **) malloc((argn + 1)*sizeof(char *));

	comargm = comargn += argn;
	*comargn = NULL;

	while (argp != NULL) {
		*--comargn = argp->argval;
		nxtargp = argp->argnxt;
		free((char *) argp);
		if (argp = nxtargp) {
			trim(*comargn);
		}
		if (argp == 0 || argp->argmk) {
			qsort(comargn, comargm-comargn, sizeof(char *), compar);
			comargm = comargn;
		}
	}
	return(comargn);
}

compar(x, y)
register char    **x;
register char    **y;
{
	return(strcmp(*x, *y));
}


/* Argument list generation */

getarg(ac)
register union	node    *ac;
{
	register struct argnod  *argp;
	register int  count = 0;
	register union	node    *c;
	register char *s;

	if (c = ac) {
		argp = c->comnod.comarg;
		while (argp != NULL) {
			s = macro(argp->argval);
			count += split(s);
			free(s);
			argp = argp->argnxt;
		}
	}
	return(count);
}

split(s)
register char	*s;
{
	register struct argnod  *argp;
	register char   *bp;
	register int  c;
	register int  count = 0;

	for (;;) {
		sigchk();
		bp = buf;
		argp = (struct argnod *) malloc(sizeof(*argp));
		argp->argmk = 0;
		while ((c = *s++, !any(c, ifsnod.namval) && c)) {
			*bp++ = c;
		}
		if (bp == buf) {
			if (c) {
				continue;
			}
			else {
				break;
			}
		}
		else if (c==0) {
			s--;
		}
		*bp = '\0';
		argp->argval = malloc(strlen(buf) + 1);
		strcpy(argp->argval, buf);
		if (c = expand(argp->argval, 0)) {
			count += c;
		}
		else {
			makearg(argp);
			count++;
		}
		gchain->argmk = 1;
	}
	free((char *) argp);
	return(count);
}
