#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#define SPOOLSIG  4
#define ESRCH     3

/*
 * These externs are for the device specific routines.
 */
extern int opr();
extern int vmpunch();
extern int tape();

extern int errno;

struct daemon {
	char *da_as;
	char *da_name;
	int (*da_check)();
};

struct stat statnill;

/*
 * The spooler table.
 * First entry is what spooler was invoked as.
 * Second entry is the front of the spool file name, the only
 *    letter after the last slash must be differnt for each member.
 * Third entry is argument checker routine declared above.
 */

struct daemon spooler[] = {
	"opr",     "/usr/spool/out/o", opr,
	"vmpunch", "/usr/spool/out/p", vmpunch,
	"tape",    "/usr/spool/out/t", tape,
	 0,         0,                 0
};

char spoolpid[] = "/usr/spool/out/.spoolpid";
char prelim[]   = "/usr/spool/out/.tmp";


/*
 * User interface to the spooling system.
 */

main(argc, argv)
int argc;
char *argv[];
{
	FILE   *fdspool;
	FILE   *fd;
	struct daemon *todaem;
	char   outname[120];
	char   prename[120];
	char   *postslash();
	char   *as;
	int    ok;
	int    i;
	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	/*
	 * Find how interface was invoked, find table entry, use
	 * this to open spool file.
	 */
	todaem = spooler;
	as = postslash(argv[0]);
	while(todaem->da_as) {
		if(!strcmp(as, todaem->da_as))
			break;
		todaem++;
	}
	if(!todaem->da_as)
		die(as);
	ok = getpid();
	for(i=0; i<100; i++) {
	        sprintf(outname, "%s%d", todaem->da_name, ok);
	        sprintf(prename, "%s%d", prelim, ok);
		if(stat(outname, &statnill) && stat(prename, &statnill))
			break;
		ok++;
	}
	if(i == 100)
		die("Cannot find unique temporary file name");
	fd = freopen(prename, "w", stdout);
	if(fd == NULL) {
		fprintf(stderr, "%s ", prename);
		die("Cannot reopen stdout");
	}
	/*
	 * Invoke the argument checker.
	 * Returns 0 if failure, !0 if success.
	 */
	ok = (*todaem->da_check)(argc, argv);
        fclose(fd);
	if(ok) {
		chown(prename, getuid(), getgid());
		chmod(prename, 0600);
		if(link(prename, outname))
			die("Cannot link to preliminary file");
		unlink(prename);
		/*
		 * If spooler is not going start it,
		 * otherwise tell it to get to work.
		 */
		fdspool = fopen(spoolpid, "r");
		if(fdspool == NULL)
			gospool();
		else {
			if(fscanf(fdspool, "%d", &ok) == 1 && ok > 1)
                                i = kill(ok, SPOOLSIG);
                        else
                                ok = -1;
			fclose(fdspool);
			if(ok == -1 || (i == -1 && errno == ESRCH)) {
				fprintf(stderr, "Spooler restarted\n");
				gospool();
			}
		}
	}
	else
		unlink(prename);
}

die(why)
char *why;
{
	fprintf(stderr, "Spooler failure : %s.\n", why);
	exit(1);
}

char *postslash(to)
char *to;
{
	char *back;
	back = to;
	while(*to)
		if(*to++ == '/')
			back = to;
	return(back);
}

savespool(pid)
int pid;
{
	FILE *fd;

	umask(022); /* creat spoolpid file mode 644 */
	fd = fopen(spoolpid, "w");
	if(fd == NULL)
		die("Cannot open spool pid file");
	fprintf(fd, "%d\n", pid);
	fclose(fd);
	return;
}

gospool()
{
	int ok;
        ok = fork();
        if(ok == 0) {
		close(0);
		close(1);
		close(2);
		open("/dev/null", 2);
                dup(0);
                dup(0);
                execl("/etc/spooler/spooler", "spooler", 0);
                die("Cannot exec spooler");
        }
        if(ok == -1)
                die("Cannot fork for spooler");
        savespool(ok);
}
