/*
 * Format a dasd with BSIZE length blocks.
 */

#include <sys/param.h>
#include <stdio.h>
#include <sgtty.h>

char zeros[BSIZE*4];

struct size {
	int nblks;
	int blk_trk;
} size;

main(argc, argv)
int argc;
char **argv;
{
	register int fd;
	register int i, trksize, ntrks;

	if (argc != 2) {
		fprintf(stderr, "Usage: format fdisk\n");
		exit(1);
	}
	fd = open(argv[1], 1);
	if (fd < 0) {
		fprintf(stderr, "Cannot open %s\n", argv[1]);
		exit(1);
	}
	if (i = ioctl(fd, FASTFORM, &size)) {
		fprintf(stderr, "Ioctl failed on %s\n", argv[1]);
		exit(1);
	}
	if (ioctl(fd, FASTSIZE, &size)) {
		fprintf(stderr, "Ioctl failed on %s\n", argv[1]);
		exit(1);
	}
	trksize = BSIZE * size.blk_trk;
	ntrks = size.nblks / size.blk_trk;
	if (sizeof(zeros) < trksize) {
		fprintf(stderr, "Format: internal array too small.\n");
		exit(1);
	}
	for (i = 0; i < ntrks; i++)
                if (write(fd, zeros, trksize) != trksize) {
                        fprintf(stderr, "Write error on track %d of %s\n", i, argv[1]);
                        exit(1);
                }
}
