%{
/*
 * Description:
 *   This component contains the YACC grammar for the
 *   input to the I/O configurator.
 */
#include <stdio.h>

extern  int     errors;         /* record errors */
extern  char    yytext[];
char    devtype[30];
char    mountdir[30];
char    *mnt;
int     lowaddr,                /* beginning of an address range */
        highaddr;               /* end of the address range */
%}

%token  COMMENT
%token  ADDR DEVTYPE MOUNT
%%
input:
        input req '\n'
|       input '\n'
|       empty
;
req:
        COMMENT
|       addrrange
        DEVTYPE                 { strcpy(devtype, yytext); }
        mount                   { dodev(devtype, mnt); }
;
addrrange:
        ADDR                    { lowaddr = highaddr = $1; }
|       ADDR '-' ADDR           { lowaddr = $1; highaddr = $3; }
;
mount:
	MOUNT                   { strcpy(mountdir, yytext); mnt = mountdir; }
|       empty                   { mnt = NULL; }
;
empty:
;
%%
dodev(devtype, mount)
char    *devtype;
char    *mount;
{
        register i, rc;

	for (i = lowaddr;i <= highaddr; i++) {
		rc = dev(i, devtype, mount);
                /*
                 *  Check for errors (message
                 *  was issued by dev)
                 */
                switch (rc) {
                case 0:
                     continue;
                case 2:  /* go on with next */
                     errors += 1;
                     continue;
                case 1:  /* skip rest of this request */
                     errors += 1;
                     i = highaddr;
                     break;
                case 3:  /* quit */
                default:
                     error(1, "configuration not generated due to errors");
                }
        }
}
