/*
 * test for longs in C
 */

#define LLOAD(a,b,c)	a.high = b; a.low = c;
#define NOTEQ(a,b,c)	(a.high != b || a.low != c)


struct goo {
	int la, dee, da;
	unsigned shower;
	long notint;
	int ha;
} leppo, *p;

main(){
	ltst1();
	ltst2();
}

ltst1()
{
	long int a, b, c, *e;
	register r;
	struct { int high, low; };

	/*
	 * ++, --
	 */
	LLOAD(a, -1, -4);
	a++;
	if (NOTEQ(a, -1, -3))
		error("++", a);

	LLOAD(a, 0, 4);
	a++;
	if (NOTEQ(a, 0, 5))
		error("++", a);

	LLOAD(a, -1, -4);
	a--;
	if (NOTEQ(a, -1, -5))
		error("--", a);

	LLOAD(a, 0, 4);
	a--;
	if (NOTEQ(a, 0, 3))
		error("--", a);

	/*
	 * &, =&
	 */
	LLOAD(a, -1, -4);
	LLOAD(b, -1, -3);
	c = a&b;
	if (NOTEQ(c, -1, -4))
		error3("&", a, b, c);

	LLOAD(a, -1, 7);
	LLOAD(b, 0, 4);
	c = a&b;
	if (NOTEQ(c, 0, 4))
		error3("&", a, b, c);

	LLOAD(a, -1, -4);
	LLOAD(b, -1, -3);
	a &= b;
	if (NOTEQ(a, -1, -4))
		error2("&=", a, b);

	LLOAD(a, -1, 7);
	LLOAD(b, 0, 4);
	a &= b;
	if (NOTEQ(a, 0, 4))
		error2("&=", a, b);
	a = -2;
	r = -6;
	b = a&r;
	if (b != -6)
		error3("&", a, (long) r, b);
	a = -6;
	r = -2;
	a &= r;
	if (a != -6)
		error2("&=", a, (long) r);

	/*
	 * ~
	 */
	LLOAD(a, -1, -4);
	e = &a;
	c = ~(*e);
	if (NOTEQ(c, 0, 3))
		error2("~", *e, c);

	/*
	 * +, +=
	 */
	LLOAD(a, 0, 12);
	LLOAD(b, 0, 7);
	c = a+b;
	if (NOTEQ(c, 0, 19))
		error3("+", a, b, c);
	LLOAD(a, 0, 0xffffffff);
	c = a+b;
	if (NOTEQ(c, 1, 6))
		error3("+", a, b, c);
	LLOAD(a, -1, -10);
	LLOAD(b, 0, 10);
	c = a+b;
	if (NOTEQ(c, 0, 0))
		error3("+", a, b, c);
	a = -2;
	r = -6;
	b = a+r;
	if (b != -8)
		error3("+", a, (long) r, b);
	a = -6;
	r = -2;
	a += r;
	if (a != -8)
		error2("+=", a, (long) r);

	/*
	 * -, -=
	 */
	LLOAD(a, 0, 12);
	LLOAD(b, 0, 7);
	c = a-b;
	if (NOTEQ(c, 0, 5))
		error3("-", a, b, c);
	LLOAD(a, 1, 0);
	LLOAD(b, 0, 1);
	c = a-b;
	if (NOTEQ(c, 0, 0xffffffff))
		error3("-", a, b, c);
	a -= b;
	if (NOTEQ(a, 0, 0xffffffff))
		error2("-=", a, b);
	a = -2;
	r = -6;
	b = a-r;
	if (b != 4)
		error3("-", a, (long) r, b);
	a = -6;
	r = -2;
	a -= r;
	if (a != -4)
		error2("-=", a, (long) r);
}

ltst2()
{
	long int a, b, c;
	int notlong;
	register r;
	struct { int high, low; };

	/*
	 * negation
	 */
	LLOAD(a, 10, 10);
	b = -a;
	b = -b;
	if (NOTEQ(b, 10, 10))
		error2("negation", a, b);
	LLOAD(a, -1, -1);
	b = -a;
	if (NOTEQ(b, 0, 1))
		error2("negation", a, b);
	LLOAD(a, 0, 0);
	b = -a;
	if (NOTEQ(b, 0, 0))
		error2("negation", a, b);
	LLOAD(a, -1, 0x80000000);
	b = -a;
	if (NOTEQ(b, 0, 0x80000000))
		error2("negation", a, b);

	/*
	 * <<, >>, <<=, >>=
	 */
	LLOAD(a, 27, 3);
	b = a >> 1;
	if (NOTEQ(b, 13, 0x80000001))
		error2(">>", a, b);
	LLOAD(a, 0xffffffff, 0xffffffff);
	b = a >> 1;
	if (NOTEQ(b, 0x7fffffff, 0xffffffff))
		error2(">>", a, b);
	LLOAD(a, 2, 0x80000001);
	LLOAD(b, 0, 2);
	c = a << b;
	if (NOTEQ(c, 10, 4))
		error3("<<", a, b, c);
	a <<= b;
	if (NOTEQ(a, 10, 4))
		error2("<<=", a, b);
	LLOAD(a, 0, 4);
	LLOAD(b, 0, 2);
	a <<= (int) b;
	if (NOTEQ(a, 0, 16))
		error2("<<=", a, b);
	a = 6;
	r = 2;
	b = a << r;
	if (b != 24)
		error3("<<", a, (long) r, b);
	a = 6;
	r = 2;
	a <<= r;
	if (a != 24)
		error2("<<=", a, (long) r);
	a = 8;
	r = 2;
	b = a >> r;
	if (b != 2)
		error3(">>", a, (long) r, b);
	a = 8;
	r = 2;
	a >>= r;
	if (a != 2)
		error2(">>=", a, (long) r);

	/*
	 * comparisons
	 */
	LLOAD(a, 5, 3);
	LLOAD(b, 4, 20);
	if (a < b)
		error2("<", a, b);
	LLOAD(a, 4, 20);
	if (a != b)
		error2("!=", a, b);
	LLOAD(a, 0, 0xffffffff);
	LLOAD(b, 0, 0);
	if (b > a)
		error2(">", a, b);
	LLOAD(a, 0, 10);
	if (!a) error2("==0", a, 0L);

	/*
	 * long constants
	 */
	LLOAD(a, 1, 0);
	b = 4294967296;
	if (a != b)
		error2("LCON", a, b);
	b = 0x0000000100000000;
	if (a != b)
		error2("LCON(hex)", a, b);
	a = 0x80000000L;
	if (a != 0x80000000L)
		error2("LCON(comp)", a, 0x80000000L);

	/*
	 * /, /=
	 */
	a = 175; b = 25; c = a/b;
	if (c != 7)
		error3("/", a, b, c);
	a = -37; b = 4; c = a/b;
	if (c != -9)
		error3("/", a, b, c);
	a = -199; b = -10; a /= b;
	if (a != 19)
		error2("/=", a, b);
	a = 0x8000000000000000; b = -4; c = a/b;
	if (c != 0x2000000000000000)
		error3("/", a, b, c);
	a = 0x0000000100000000; b = 2; c = a/b;
	if (c != 0x80000000L)
		error3("/", a, b, c);
	a = -6;
	r = -2;
	b = a/r;
	if (b != 3)
		error3("/", a, (long) r, b);
	a = -6;
	r = -2;
	a /= r;
	if (a != 3)
		error2("/=", a, (long) r);

	/*
	 * *, *=
	 */
	a = 20; b = -1; c = a*b;
	if (c != -20) error3("*", a, b, c);
	a *= 10;
	if (a != 200) error2("*", a, 10L);
	c = 10*a;
	if (c != 2000) error3("*", a, 10l, c);
	a = -2;
	r = -6;
	b = a*r;
	if (b != 12)
		error3("*", a, (long) r, b);
	a = -6;
	r = -2;
	a *= r;
	if (a != 12)
		error2("*=", a, (long) r);

	/*
	 * structure test
	 */

	p = &leppo;

	p->notint = 30;
	notlong = 3;
	p->notint += notlong;
	if (p->notint != 33) error2("structure +=", p->notint, (long) notlong);

	p->notint = 30;
	notlong = 3;
	p->notint *= notlong;
	if (p->notint != 90) error2("structure *=", p->notint, (long) notlong);

	p->notint = 30;
	notlong = 3;
	p->notint = p->notint * notlong;
	if (p->notint != 90) error2("structure *", p->notint, (long) notlong);

	p->notint = 30;
	notlong = 3;
	p->notint -= notlong;
	if (p->notint != 27) error2("structure -=", p->notint, (long) notlong);

	p->notint = 30;
	notlong = 3;
	p->notint /= notlong;
	if (p->notint != 10) error2("structure /=", p->notint, (long) notlong);

	p->notint = 30;
	notlong = 3;
	p->notint %= notlong;
	if (p->notint != 0) error2("structure /=", p->notint, (long) notlong);
}

error(t1, l)
char *t1;
long l;
{

	printf("fatal error:  long %s: %8x%8x\n", t1, l);
	exit(2);
}

error2(s1, l1, l2)
char *s1;
long l1, l2;
{
	printf("fatal error:  long %s: %8x%8x, %8x%8x\n", s1, l1, l2);
	exit(2);
}

error3(s1, l1, l2, l3)
char *s1;
long l1, l2, l3;
{
	printf("fatal error:  long %s: %8x%8x, %8x%8x, %8x%8x\n", s1, l1, l2, l3);
	exit(2);
}
