# define BEFORE 257
# define AFTER 258
# define AGO 259
# define HENCE 260
# define NUMBER 261
# define UNIT 262
# define THIS 263
# define NEXT 264
# define LAST 265
# define MONTH 266
# define AM 267
# define PM 268
# define NOW 269
# define TODAY 270
# define SLASHD 271
# define COLONT 272
# define TOMORROW 273
# define YESTERDAY 274
# define WEEKDAY 275
# define DAYNUM 276
# define YEARNUM 277
# define HOURNUM 278
# define EPOCH 279

# line 56 "timec.y"
#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/timeb.h>
static int date(), index(), isdst();
static char *token();
static int number, slashd, colont, month, today, hday, unit;
static int unitval[] = { 1, 60, 60*60, 24*60*60, 7*24*60*60, 30*24*60*60, 365*24*60*60 };
static struct tm *have;
static int now, weekday;
static char *timestr;
static int req_tense;
static int tcval, tcerr;
static int abstime;
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 127 "timec.y"

/*
 * Main entry - just figure out the current time and call yyparse
 * On return, check for errors
 */
timec(tmstr, tense)
char *tmstr;
{
	int ndst, tdst;

	req_tense = tense;
	timestr = tmstr;
        now = time();
        have = localtime(now);
        today = now - (3600*have->tm_hour+60*have->tm_min+have->tm_sec);
	hday = today;
	tcerr = 0;
	abstime = 0;
	if(yyparse() || tcerr)
		return(-1);
	ndst = isdst(now);
	tdst = isdst(tcval);
	if(abstime) {
		if(tdst)
                        tcval -= 60*60;
	} else {
		if(ndst != tdst)
			if(ndst)
				tcval += 60*60;
			else
				tcval -= 60*60;
	}
	return(tcval);
}

/*
 * Error routine - just set error indication
 */
static yyerror(s)
char *s;
{
	tcerr = 1;
}

/*
 * Lexical analyzer:
 * Get a token and see if it's a slash date(2/23/80) or a colon time
 * (3:42:56) or a number or a word. If it's a noise word, repeat.
 */
static yylex()
{
	char *t, *token();
	int m,d,y,h,s,type;
loop:
	t = token();
	if(t == 0)
		return(0);
	if(index(t, '/')) {     /* slash date */
		m = 0;
		while(isdigit(*t))
			m = 10*m + *t++ - '0';
		if(*t++ != '/') yyerror("bad slash date");
		d = 0;
		while(isdigit(*t))
			d = 10*d + *t++ - '0';
		if(*t == '\0') {
			slashd = date(m, d, -1);
			return(SLASHD);
		}
		if(*t++ != '/') yyerror("bad slash date");
		y = 0;
		while(isdigit(*t))
			y = 10*y + *t++ - '0';
		slashd = date(m, d, y);
		return(SLASHD);
	}
	if(index(t, ':')) {     /* colon time */
		h = 0;
		while(isdigit(*t))
			h = 10*h + *t++ - '0';
		if(*t++ != ':') yyerror("bad colon time");
		m = 0;
		while(isdigit(*t))
			m = 10*m + *t++ - '0';
		if(h >= 24 || m >= 60)
			yyerror("bad colon time");
		if(*t == '\0') {
			colont = htime(h, m, 0);
			return(COLONT);
		}
		if(*t++ != ':') yyerror("bad colon time");
		s = 0;
		while(isdigit(*t))
			s = 10*s + *t++ - '0';
		if(s >= 60)
			yyerror("bad colon time");
		colont = htime(h, m, s);
		return(COLONT);
	}
	if(isdigit(*t)) {       /* number */
		number = atoi(t);
		if(number <= 12) return(HOURNUM);
		if(number <= 31) return(DAYNUM);
		if(number >= 70 && number <= 99) return(YEARNUM);
		if(number >= 1970 && number <= 1999) return(YEARNUM);
		return(NUMBER);
	}
	type = lookup(t);
	if(type == -1) goto loop;
	return(type);
}

/*
 * Get the next token from the input string
 */
static char *token()
{
	static char tok[50], eof;
	char *p;
	int c;

	if(eof) {
		eof = 0;
		return(0);
	}
	while((c = *timestr++) == ' ' || c == '\t' || c == '\n' ||
		c == ',');
	if(c == '\0') return(0);
	p = tok;
	*p++ = c;
	while((c = *timestr++) != ' ' && c != '\t' && c != '\n' &&
		c != ',' && c != '\0')
		*p++ =  c;
	if(c == '\0') eof = 1;
	*p = '\0';
	return(tok);
}


/*
 * Table of words and what they "mean".
 */
static struct word {
	char *name;
	int type;
	int value;
} words [] = {
	"the", -1, 0,
	"at", -1, 0,
	"in", -1, 0,
	"a", NUMBER, 1,
	"tomorrow", TOMORROW, 0,
	"yesterday", YESTERDAY, 0,
	"before", BEFORE, 0,
	"after", AFTER, 0,
	"ago", AGO, 0,
	"hence", HENCE, 0,
	"epoch", EPOCH, 0,
	"this", THIS, 0,
	"next", NEXT, 0,
	"last", LAST, 0,
	"now", NOW, 0,
	"today", TODAY, 0,
	"from", AFTER, 0,
	"second", UNIT, 0,
	"seconds", UNIT, 0,
	"minute", UNIT, 1,
	"minutes", UNIT, 1,
	"hour", UNIT, 2,
	"hours", UNIT, 2,
	"day", UNIT, 3,
	"days", UNIT, 3,
	"week", UNIT, 4,
	"weeks", UNIT, 4,
	"month", UNIT, 5,
	"months", UNIT, 5,
	"year", UNIT, 6,
	"years", UNIT, 6,
	"am", AM, 0,
	"a.m.", AM, 0,
	"morning", AM, 0,
	"pm", PM, 0,
	"p.m.", PM, 0,
	"afternoon", PM, 0,
	"january", MONTH, 1,
	"jan", MONTH, 1,
	"february", MONTH, 2,
	"feb", MONTH, 2,
	"march", MONTH, 3,
	"mar", MONTH, 3,
	"april", MONTH, 4,
	"apr", MONTH, 4,
	"may", MONTH, 5,
	"june", MONTH, 6,
	"jun", MONTH, 6,
	"july", MONTH, 7,
	"jul", MONTH, 7,
	"august", MONTH, 8,
	"aug", MONTH, 8,
	"september", MONTH, 9,
	"sep", MONTH, 9,
	"october", MONTH, 10,
	"oct", MONTH, 10,
	"november", MONTH, 11,
	"nov", MONTH, 11,
	"december", MONTH, 12,
	"dec", MONTH, 12,
	"sunday", WEEKDAY, 0,
	"sun", WEEKDAY, 0,
	"monday", WEEKDAY, 1,
	"mon", WEEKDAY, 1,
	"tuesday", WEEKDAY, 2,
	"tue", WEEKDAY, 2,
	"wednesday", WEEKDAY, 3,
	"wed", WEEKDAY, 3,
	"thursday", WEEKDAY, 4,
	"thu", WEEKDAY, 4,
	"friday", WEEKDAY, 5,
	"fri", WEEKDAY, 5,
	"saturday", WEEKDAY, 6,
	"sat", WEEKDAY, 6,
	"first", DAYNUM, 1,
	"second", DAYNUM, 2,
	"third", DAYNUM, 3,
	"fourth", DAYNUM, 4,
	"fifth", DAYNUM, 5,
	"sixth", DAYNUM, 6,
	"seventh", DAYNUM, 7,
	"eighth", DAYNUM, 8,
	"ninth", DAYNUM, 9,
	"tenth", DAYNUM, 10,
	"eleventh", DAYNUM, 11,
	"twelvth", DAYNUM, 12,
	"thirteenth", DAYNUM, 13,
	"fourteenth", DAYNUM, 14,
	"fifteenth", DAYNUM, 15,
	"sixteenth", DAYNUM, 16,
	"seventeenth", DAYNUM, 17,
	"eighteenth", DAYNUM, 18,
	"nineteenth", DAYNUM, 19,
	"twentieth", DAYNUM, 20,
	"twenty-first", DAYNUM, 21,
	"twenty-second", DAYNUM, 22,
	"twenty-third", DAYNUM, 23,
	"twenty-fourth", DAYNUM, 24,
	"twenty-fifth", DAYNUM, 25,
	"twenty-sixth", DAYNUM, 26,
	"twenty-seventh", DAYNUM, 27,
	"twenty-eighth", DAYNUM, 28,
	"twenty-ninth", DAYNUM, 29,
	"thirtieth", DAYNUM, 30,
	"thirty-first", DAYNUM, 31,
	"o'clock", -1, 0,
	"one", HOURNUM, 1,
	"two", HOURNUM, 2,
	"three", HOURNUM, 3,
	"four", HOURNUM, 4,
	"five", HOURNUM, 5,
	"six", HOURNUM, 6,
	"seven", HOURNUM, 7,
	"eight", HOURNUM, 8,
	"nine", HOURNUM, 9,
	"ten", HOURNUM, 10,
	"eleven", HOURNUM, 11,
	"twelve", HOURNUM, 12,
	"thirteen", HOURNUM, 13,
	"fourteen", HOURNUM, 14,
	"fifteen", HOURNUM, 15,
	"sixteen", HOURNUM, 16,
	"seventeen", HOURNUM, 17,
	"eighteen", HOURNUM, 18,
	"nineteen", HOURNUM, 19,
	"twenty", HOURNUM, 20,
	"twenty-one", HOURNUM, 21,
	"twenty-two", HOURNUM, 22,
	"twenty-three", HOURNUM, 23,
	"twenty-four", HOURNUM, 24,
	0,
};

/*
 * Look up a word by linear search (slow).
 */
static lookup(t)
char *t;
{
	char *s;
	struct word *w, *x;

	for(s = t; *s; s++) if(isupper(*s)) *s = tolower(*s);
	x = NULL;
	for(w = words; w->name; w++)
	if(strcmp(t, w->name) == 0) {
		x = w;
		break;
	}
	if(x == NULL) {
		yyerror("bad word");
		return(0);
	}
	switch(x->type) {
	case MONTH:
		month = x->value;
		break;
	case UNIT:
		unit = x->value;
		break;
	case WEEKDAY:
		weekday = x->value;
		break;
	case NUMBER: case DAYNUM: case HOURNUM: case YEARNUM:
		number = x->value;
		break;
	}
	return(x->type);
}

/*
 * See if the character c is in the string s.
 */
static index(s, c)
char *s;
char c;
{
	while(*s) if(*s++ == c) return(1);
	return(0);
}

static int montab[] = { 31, 0, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

/*
 * Handle the words 'this', 'next', and 'last' when applied to time units.
 */
static tnl(unit, tense)
{
	int t, m, y;

	switch(unit) {
	case 0: /* second */
		return(now + tense);
	case 1: /* minute */
		t = now;
		t -= have->tm_sec;
		return(t + tense*60);
	case 2: /* hour */
		t = now;
		t -= have->tm_sec;
		t -= 60 * have->tm_min;
		return(t + tense*60*60);
	case 3: /* day */
		return(today + tense*24*60*60);
	case 4: /* week */
		t = today;
		t -= have->tm_wday * 24*60*60;
		return(t + tense*7*24*60*60);
	case 5: /* month */
		m = 1 + have->tm_mon;
		y = have->tm_year;
		m += tense;
		if(m > 12) {
		        y++;
			m -= 12;
		}
		if(m <= 0) {
			y--;
			m += 12;
		}
		return(date(m, 1, y));
	case 6: /* year */
		return(date(1, 1, have->tm_year + tense));
	}
}

/*
 * Generate time given month, day, and possibly year.
 */
static date(m, d, y)
{
	int t, i;
	struct timeb timeb;

	if(y == -1) {
		switch(req_tense) {
		case 0: /* present */
			y = have->tm_year;
			break;
		case -1: /* past */
			if(m <= have->tm_mon+1)
				y = have->tm_year;
			else
				y = have->tm_year - 1;
			break;
		case 1: /* future */
			if(m > have->tm_mon+1)
				y = have->tm_year;
			else
				y = have->tm_year + 1;
			break;
		}
	}
	if(y >= 1970 && y < 2000)
		y -= 1900;
	else if(y < 70 || y > 99)
		yyerror("bad year");
	if(m < 1 || m > 12)
		yyerror("bad month");
	t = 0;
	for(i = 70; i < y; i++) {
		t += 365;
		if((i % 4) == 0) t += 1;
	}
	if((y % 4) == 0)
		montab[1] = 29;
	else
		montab[1] = 28;
	for(i = 1; i < m; i++) {
		t += montab[i-1];
	}
	if(d > montab[m-1])
		yyerror("bad day");
	t += d-1;
	ftime(&timeb);
	t *= 24*60*60;
	t += timeb.timezone*60;
	abstime = 1;
	return(t);
}

/*
 * Generate time given hour, minute, and second.
 */
static htime(h, m, s)
{
	int th, tw;

	switch(req_tense) {
	case 0: /* present */
		if(h < 12 && have->tm_hour >= 12)
			hday += 12*60*60;
		break;

	case -1: /* past */
		tw = 3600*h + 60*m + s;
		if(h > 12) { /* 24 hour time */
                        th = 3600*have->tm_hour + 60*have->tm_min + have->tm_sec;
			if(tw >= th)
				hday -= 24*60*60;
			break;
		}
		th = 3600*(have->tm_hour%12) + 60*have->tm_min + have->tm_sec;
		if(tw < th) {
			if(have->tm_hour >= 12)
				hday += 12*60*60;
		} else {
			if(have->tm_hour < 12)
				hday -= 12*60*60;
		}
		break;

	case 1: /* future */
		tw = 3600*h + 60*m + s;
		if(h > 12) { /* 24 hour time */
                        th = 3600*have->tm_hour + 60*have->tm_min + have->tm_sec;
			if(tw <= th)
				hday += 24*60*60;
			break;
		}
		th = 3600*(have->tm_hour%12) + 60*have->tm_min + have->tm_sec;
		if(tw > th) {
			if(have->tm_hour >= 12)
				hday += 12*60*60;
		} else {
			if(have->tm_hour < 12)
				hday += 12*60*60;
			else
				hday += 24*60*60;
		}
		break;
	}
	return(hday + 3600*h + 60*m + s);
}

/*
 * Generate time given day-of-week and tense.
 */
static dow(w, tense)
{
	int h, t;

	h = have->tm_wday;
	if(tense > 0 && w <= h) w += 7;
	if(tense < 0 && w >= h) w -= 7;
	t = today + (w-h) * 24*60*60;
	return(t);
}

/*
 * Do this, next, or last month_name
 */
static moy(m, tense)
{
	int y;

	switch(tense) {
	case 0: /* present */
		y = have->tm_year;
		break;
	case 1: /* future */
		if(m <= have->tm_mon+1)
			y = have->tm_year+1;
		else
			y = have->tm_year;
		break;
	case -1: /* past */
		if(m >= have->tm_mon+1)
			y = have->tm_year-1;
		else
			y = have->tm_year;
		break;
	}
	return(date(m, 1, y));
}

#define dysize(y) ((y%4) == 0 ? 366 : 365)

/*
 * Determine if tim is in daylight savings or not
 * This code is stolen and compressed from ctime(2)
 */
static isdst(tim)
{
	register int day, y, d;
	int hour, wday, daylb, dayle;
	struct timeb timeb;

	ftime(&timeb);
	if(timeb.dstflag == 0)
		return(0);
	tim -= timeb.timezone*60;
	hour = tim / 3600;
	day = hour / 24;
	hour = hour % 24;
	wday = (day+7340036) % 7;
	for(y=70; day >= dysize(y); y++)
		day -= dysize(y);
	d = 119 + dysize(y) - 365;
	daylb = d - (d - day + wday + 700) % 7; /* last sun in apr */
	d = 303 + dysize(y) - 365;
	dayle = d - (d - day + wday + 700) % 7; /* last sun in oct */
	if((day > daylb || (day == daylb && hour > 2)) &&
	   (day < dayle || (day == dayle && hour <= 1)))
		return(1);
	return(0);
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 27,
	262, 51,
	-2, 44,
	};
# define YYNPROD 52
# define YYLAST 145
short yyact[]={

   3,  55,  57,  56,  55,  24,  56,   6,   7,   8,
  15,  21,  22,  12,  16,  19,  20,  17,  18,   9,
  25,  26,  27,  13,  24,  57,   6,   7,   8,  15,
  21,  22,  12,  16,  19,  20,  17,  18,   9,  25,
  26,  27,  13,  49,  50,  51,  15,  66,  35,  36,
  16,  19,  45,  17,  18,  48,  21,  22,  32,  42,
  43,  20,  34,  35,  36,  40,  37,  46,  41,  42,
  39,  33,  39,  34,  52,  60,  61,  54,  41,  38,
  53,  38,  33,  58,  59,  28,  29,  30,  31,   2,
  10,  23,  11,  14,   5,   4,   1,   0,   0,   0,
   0,   0,  47,  44,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  62,  63,
   0,   0,   0,   0,  64,   0,   0,   0,   0,   0,
   0,  65,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  67 };
short yypact[]={

-256,-1000,-1000,-1000,-1000,-172,-204,-196,-197,-206,
-211,-220,-1000,-1000,-188,-275,-1000,-1000,-1000,-1000,
-184,-1000,-1000,-192,-1000,-1000,-1000,-1000,-237,-237,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-272,-1000,-219,-1000,-1000,-1000,-193,
-194,-207,-1000,-252,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-225,-1000,-252,-1000 };
short yypgo[]={

   0,  96,  89,  95,  94,  93,  80,  77,  90,  92,
  91 };
short yyr1[]={

   0,   1,   1,   2,   2,   2,   2,   2,   4,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   8,
   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,
   8,   8,   8,   8,   9,   9,   9,   9,   9,   9,
   9,   9,   9,   9,  10,   6,   6,   7,   5,   5,
   5,   5 };
short yyr2[]={

   0,   1,   1,   1,   3,   3,   2,   2,   2,   2,
   2,   2,   5,   1,   1,   2,   2,   1,   1,   2,
   1,   3,   2,   1,   1,   1,   1,   1,   2,   2,
   2,   2,   2,   2,   1,   2,   2,   1,   2,   1,
   2,   1,   2,   2,   1,   1,   1,   1,   1,   1,
   1,   1 };
short yychk[]={

-1000,  -1,  -2, 256,  -3,  -4, 263, 264, 265, 275,
  -8,  -9, 269, 279,  -5, 266, 270, 273, 274, 271,
 272, 267, 268, -10, 261, 276, 277, 278, 257, 258,
 259, 260, 262, 275, 266, 267, 268, 262, 275, 266,
 262, 275, 266, 266,  -9, 263, 278,  -8, 275, 263,
 264, 265, 262,  -6,  -7, 276, 278, 277, 267, 268,
 267, 268,  -2,  -2,  -6,  -7, 272,  -7 };
short yydef[]={

   0,  -2,   1,   2,   3,   0,   0,   0,   0,  27,
  13,  14,  17,  18,   0,  20,  23,  24,  25,  26,
  34,  37,  39,  41,  48,  49,  50,  -2,   0,   0,
   6,   7,   9,  28,  31,  38,  40,  10,  29,  32,
  11,  30,  33,   0,  15,   0,  44,  16,  27,   0,
   0,   0,   8,  19,  22,  45,  46,  47,  35,  36,
  42,  43,   4,   5,   0,  21,   0,  12 };
#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

int yydebug = 0; /* 1 for debugging */
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

			if( yydebug ) printf( "error recovery discards char %d\n", yychar );

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

		if( yydebug ) printf("reduce %d\n",yyn);
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 73 "timec.y"
 { tcval = yypvt[-0]; } break;
case 2:
# line 74 "timec.y"
 { tcerr = 1; } break;
case 3:
# line 75 "timec.y"
 { yyval = yypvt[-0]; } break;
case 4:
# line 76 "timec.y"
 { yyval = yypvt[-0] - yypvt[-2]; } break;
case 5:
# line 77 "timec.y"
 { yyval = yypvt[-0] + yypvt[-2]; } break;
case 6:
# line 78 "timec.y"
 { yyval = now - yypvt[-1]; } break;
case 7:
# line 79 "timec.y"
 { yyval = now + yypvt[-1]; } break;
case 8:
# line 80 "timec.y"
 { yyval = yypvt[-1] * unitval[unit]; } break;
case 9:
# line 81 "timec.y"
 { yyval = tnl(unit, 0); } break;
case 10:
# line 82 "timec.y"
 { yyval = tnl(unit, 1); } break;
case 11:
# line 83 "timec.y"
 { yyval = tnl(unit, -1); } break;
case 12:
# line 84 "timec.y"
 {
				/* inverse of ctime */
				yyval = date(month,yypvt[-2],yypvt[-0]) + colont - hday;
			} break;
case 15:
# line 90 "timec.y"
 { yyval = yypvt[-1] + yypvt[-0] - hday; } break;
case 16:
# line 91 "timec.y"
 { yyval = yypvt[-0] + yypvt[-1] - hday; } break;
case 17:
# line 92 "timec.y"
 { yyval = now; } break;
case 18:
# line 93 "timec.y"
 { yyval = 0; } break;
case 19:
# line 94 "timec.y"
 { yyval = date(month, yypvt[-0], -1); } break;
case 20:
# line 95 "timec.y"
 { yyval = date(month, 1, -1); } break;
case 21:
# line 96 "timec.y"
 { yyval = date(month, yypvt[-1], yypvt[-0]); } break;
case 22:
# line 97 "timec.y"
 { yyval = date(month, 1, yypvt[-0]); } break;
case 23:
# line 98 "timec.y"
 { yyval = today; } break;
case 24:
# line 99 "timec.y"
 { yyval = today + 24*60*60; } break;
case 25:
# line 100 "timec.y"
 { yyval = today - 24*60*60; } break;
case 26:
# line 101 "timec.y"
 { yyval = slashd; } break;
case 27:
# line 102 "timec.y"
 { yyval = dow(weekday, req_tense); } break;
case 28:
# line 103 "timec.y"
 { yyval = dow(weekday, 0); } break;
case 29:
# line 104 "timec.y"
 { yyval = dow(weekday, 1); } break;
case 30:
# line 105 "timec.y"
 { yyval = dow(weekday, -1); } break;
case 31:
# line 106 "timec.y"
 { yyval = moy(month, 0); } break;
case 32:
# line 107 "timec.y"
 { yyval = moy(month, 1); } break;
case 33:
# line 108 "timec.y"
 { yyval = moy(month, -1); } break;
case 34:
# line 109 "timec.y"
 { yyval = colont; } break;
case 35:
# line 110 "timec.y"
 { yyval = colont - hday + today; hday = today; } break;
case 36:
# line 111 "timec.y"
 { yyval = colont - hday + today + 12*60*60; hday = today; } break;
case 37:
# line 112 "timec.y"
 { yyval = hday; } break;
case 38:
# line 113 "timec.y"
 { yyval = hday; } break;
case 39:
# line 114 "timec.y"
 { yyval = hday + 12*60*60; } break;
case 40:
# line 115 "timec.y"
 { yyval = hday + 12*60*60; } break;
case 41:
# line 116 "timec.y"
 { yyval = htime(yypvt[-0], 0, 0); } break;
case 42:
# line 117 "timec.y"
 { yyval = hday + (yypvt[-1]%12)*60*60; } break;
case 43:
# line 118 "timec.y"
 { yyval = hday + ((yypvt[-1]%12)+12)*60*60; } break;
case 44:
# line 119 "timec.y"
 { yyval = number; } break;
case 45:
# line 120 "timec.y"
 { yyval = number; } break;
case 46:
# line 121 "timec.y"
 { yyval = number; } break;
case 47:
# line 122 "timec.y"
 { yyval = number; } break;
case 48:
# line 123 "timec.y"
 { yyval = number; } break;
case 49:
# line 124 "timec.y"
 { yyval = number; } break;
case 50:
# line 125 "timec.y"
 { yyval = number; } break;
case 51:
# line 126 "timec.y"
 { yyval = number; } break;
		}
		goto yystack;  /* stack new state and value */

	}
