#include <stdio.h>
#include <stdioerr.h>

FILE *
_endopen(file, mode, iop)
	char *file, *mode;
	register FILE *iop;
{
	extern int errno;
	extern char *strcpy();
	register int rw, f;

	rw = mode[1] == '+';

	switch (*mode) {

	case 'w':
		f = create(file, rw);
		break;

	case 'a':
		if ((f = open(file, rw? 2: 1)) < 0) {
			if (errno == ENOENT)
				f = create(file, rw);
		} else
                        seek(f, 0, 2);
		break;

	case 'r':
		f = open(file, rw? 2: 0);
		break;

	default:
		return(_stdioerr(EMODE, NULL, file));
	}

	if (f < 0)
		return(_stdioerr(errno, NULL, file));

	iop->_cnt = 0;
	iop->_file = f;
	if (!_okalloc())
                iop->_filename = "(name unknown)";
	else
                iop->_filename = strcpy(malloc(strlen(file)+1), file);

	if (rw)
		iop->_flag |= _IORW;
	else if (*mode == 'r')
		iop->_flag |= _IOREAD;
	else
		iop->_flag |= _IOWRT;

	return(iop);
}

static int
create(file, rw)
	register char *file;
	int rw;
{
	register int f;

	f = creat(file, 0666);
	if (rw && f>=0) {
		close(f);
		f = open(file, 2);
	}
	return(f);
}

/*
 * setalloc sets the "_allocflag" variable,
 * parameter as 0 means fopen can't do a malloc, otherwise it can
 *
 * this is a kludge in the name of compatibility with sbrk
 */

static int _allocflag = 1;

setalloc(flag)
int flag;
{
	_allocflag = flag;
}

_okalloc()
{
	return(_allocflag != 0);
}
