/
/ Function:
/   RINDEX returns the ptr in sp at which the character c last appears;
/   or NULL if not found.
/
/ Calling Sequence:
/   ptr = rindex(sp, c)  { char *sp, c }
/

.comm   _strwork,256

	entry   rindex
	using   rindex,15
rindex:
	lr      r0,sp
	s       sp,=f'64'
	stm     r0,r15,0(sp)
	st      0,52(,sp)
	lr      r12,sp

	l       r0,64(,sp)          / Get string address
	lr      r3,r0
        l       r6,68(,sp)          / Get character
        l       r4,=v(_strtabl)     / Get trt NULL table address
	l       r5,=a(_strwork)     / Get trt work table address
        ar      r6,r5               / Turn on byte in table
        mvi     0(r6),1
        sr      r0,r0               / Init found pointer
        sr      r1,r1               / Clear high order byte (trt don't)
0:
	trt     0(256,r3),0(r4)     / Scan for null
	bc      8,3f                / CC=0?  No null found
        sr      r1,r3               / Get remaining length
        ex      r1,5f               / Execute the trt instruction
        bc      8,2f                / CC=0?  Not found
	lr      r0,r1               / EUREKA!  We have found it!
        lr      r3,r1               / Reset address
        cli     0(r3),0             / If it is NULL char, all done
        be      2f
        la      r3,1(r3)            / Bump past this character
        b       0b                  / Continue scan
2:
        mvi     0(r6),0             / Turn table byte back off
	lm      r1,r15,4(r12)       / and return
	br      r14
3:
        trt     0(256,r3),0(r5)     / Scan for given character
        bc      8,4f                / CC=0?  Character not found
        lr      r0,r1               / Else EUREKA!
        lr      r3,r1               / Reset address
        la      r3,1(r3)            / Bump past this character
        b       0b                  / Continue scan
4:
	la      r3,256(r3)          / Increment address
	b       0b                  / Continue scan
5:
        dc      x'dd0030005000'     / Model trt 0(0,r3),0(r5)
