#include "../h/conf.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/buf.h"
#include "../h/proc.h"
#include "../h/stats.h"
#include "../h/inode.h"
#include "../h/text.h"
#include "../h/file.h"
 
/*
 * Memory special file
 * minor device 0 is physical memory
 * minor device 1 is EOF/RATHOLE
 * minor device 2 is process table
 * minor device 3 is statistics structure
 * minor device 4 is inode table
 * minor device 5 is text table
 * minor device 6 is file table
 */
 
extern struct proc proc[NPROC];
extern struct inode inode[NINODE];
extern struct text text[NTEXT];
extern struct file file[NFILE];
/*
 * Kernel data areas accessible by user programs
 * Indexed by minor device number minus 2
 */
struct area {
	caddr_t start;
	int     length;
} area[] = {
	(caddr_t)&proc[0],  sizeof proc,
	(caddr_t)&stats,    sizeof stats,
	(caddr_t)&inode[0], sizeof inode,
	(caddr_t)&text[0],  sizeof text,
	(caddr_t)&file[0],  sizeof file,
};
#define NAREA (sizeof area/sizeof(struct area))

/*
 * Read from memory
 */
mmread(dev)
{
	register d;

	d = minor(dev);
	if(d == 0)
		mmio((caddr_t)0, memlim+1, B_READ);
	else if(d == 1)
		return;
	else if((d -= 2) < NAREA)
		mmio(area[d].start, area[d].length, B_READ);
	else
		u.u_error = ENXIO;
}

/*
 * Write to memory
 */
mmwrite(dev)
{
	register d;

	d = minor(dev);
	if(d == 0)
		mmio((caddr_t)0, memlim+1, B_WRITE);
	else if(d == 1) {
                u.u_base += u.u_count;
                u.u_offset += u.u_count;
                u.u_count = 0;
                return;
        } else if((d -= 2) < NAREA)
	        mmio(area[d].start, area[d].length, B_WRITE);
	else
		u.u_error = ENXIO;
}
 
/*
 * Do the memory to memory transfer
 */
mmio(start, length, flag)
caddr_t start;
int length, flag;
{
        register off_t off;
        register cc;

        off = u.u_offset;
        cc = u.u_count;
        if (off > length || off < 0)
		return;
        if((off+cc) > length)
		cc = length - off;
	iomove(start+off, cc, flag);
}
