/*
 * Virtual Console Function Driver:
 * Uses VM Release 6 diagnose code 8 to obtain
 * CP output from CP command.
 * CP command is written to this device; response is read from it.
 */

#include "../h/conf.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/tty.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/ioconf.h"

#define CLEN 132     /* Maximum length allowed (by CP) for VCF commands */

struct vcf {
	char    v_cbuf[CLEN];   /* command buffer */
	int     v_clen;         /* command length */
	char    *v_obuf;        /* output buffer page */
	char    *v_cptr;        /* command char ptr */
	struct clist v_q;       /* response char queue */
} vcfs[NVCF];

extern char etatab[], atetab[];

/*
 * Open VCF device
 */
/* ARGSUSED */
vcfopen(dev, mode)
{
	struct vcf *vp;

	if(minor(dev) >= NVCF || !vm) {
		u.u_error = ENXIO;
		return;
	}
	vp = &vcfs[minor(dev)];
	if(vp->v_obuf) {
		u.u_error = EBUSY;
		return;
	}
	vp->v_obuf = getpage();
	vp->v_cptr = vp->v_cbuf;
	vp->v_clen = 0;
}

/*
 * Close VCF device
 */
vcfclose(dev)
{
	struct vcf *vp;

	vp = &vcfs[minor(dev)];
	while(vp->v_q.c_cc > 0)
		getc(&vp->v_q);
	freepag(vp->v_obuf);
	vp->v_obuf = 0;
}

/*
 * Write to VCF device
 * (Issue CP commands)
 */
vcfwrite(dev)
{
	struct vcf *vp;
	int c, i, len;
	char *cp;

	vp = &vcfs[minor(dev)];
	while((c = cpass()) != -1) {
		if (vp->v_clen >= CLEN) {
			u.u_error = EINVAL;
			vp->v_cptr = vp->v_cbuf;
			vp->v_clen = 0;
			return;
		}
		if(c == '\n') {
			if(vp->v_clen > 0) {
				len = d_vcf(vp->v_cbuf, vp->v_obuf, vp->v_clen, PSIZE);
				if (len < 0)
					len = PSIZE;
				cp = vp->v_obuf;
				for(i = 0; i < len; i++)
					putc(etatab[*cp++], &vp->v_q);
			}
			vp->v_cptr = vp->v_cbuf;
			vp->v_clen = 0;
		} else {
			*vp->v_cptr++ = atetab[c];
			vp->v_clen++;
		}
	}
}

/*
 * Read from VCF device
 * (Obtain CP output)
 */
vcfread(dev)
{
	struct vcf *vp;

	vp = &vcfs[minor(dev)];
	while(vp->v_q.c_cc > 0 && u.u_count != 0 && u.u_error == 0)
		passc(getc(&vp->v_q));
}
