/ set up the device address for further use
/
        entry   initio
initio:
        using   initio,r15
        st      r6,temp6             / save r6 for short time
        l       r6,0(r13)            / put addr of i/o device into r6
        st      r6,auaddr            / store dev addr for later access
        sr      r6,r6
        st      r6,row               / init the full screen row
        l       r6,temp6             / put r6 back together
        br      r14                  / return to caller, io is ready??
        drop    r15
/
/ display the passed in string and prompt the user,
/  return the response..
/
        entry   aptio
aptio:
        using   aptio,r12
        stm     r0,r15,gprsa-24(r15) / save gprs
        lr      r12,r15              / use 12 as the base register
/
/ set up the external interrupt stuff
/
        mvc     savpsw(8),EXTNPSW    / save Au's external new psw
        mvc     intcode(2),EXTCODE   / save Au's external int code
        mvc     audev(4),IOADDR      / save Au's device address
        la      r1,extrupt           / get addr of our ext. int. handler
        st      r1,extnpsw+4         / store addr into ext. new psw
        mvc     EXTNPSW(8),extnpsw   / set up ext. new psw in low core
        mvc     tmpcaw(4),CAW        / save the current CAW
        mvc     tmpcsw(8),CSW        / save the current CSW
/
/get the parms set up and then
/ check for the type of terminal, console i/o or full screen.
/
        l       r6,0(r13)            / put addr of string into r6
        l       r7,4(r13)            / put addr of response into r7
        l       r8,auaddr            / put device addr into r8
        sr      r1,r1
        l       r1,conaddr           / check for console i/o, dev 9
        cr      r1,r8
        bne     fullscr              / full screen i/o boys
/
/ if there is a 0 in response addr, then just do a display, no input
/ is coming in
/
        sr      r1,r1                / set up r1 for 0 compare
        clr     r7,r1                / check response for 0, if 0 then
        bz      justout              / do just output to tube, no input
/
/ do a write and read to and of the tube, i.e. prompt the user
/
        stcm    r6,7,conscp+1        / put addr of string into ccw
	lr      r1,r6                / set up r1 with the addr of string
        bal     r14,strlen           / get length of string
        sr      r1,r6                / the length is now in r1
        stcm    r1,3,conscp+6        / put length of str into ccw
        lr      r5,r1                / save length of str for later use
        la      r11,atetbl           / r11 needs atetbl addr for execute
        ex      r1,trans             / exec translate, ascii to ebcdic
        stcm    r7,7,conscp+9        / store address of response into ccw
        xc      0(160,r7),0(r7)      / blank out the response area
        la      r1,conscp            / set up for i/o to device
        st      r1,CAW               / store channel address word
        bal     r14,csio             / do the i/o, both write and read
        bal     r14,rest             / wait for the i/o to complete
        b       complete             / all done, quit and head for comak
/
/ do a write of the string to the device
/
justout:
        stcm    r6,7,wrccw+1         / put addr of string into ccw
        lr      r1,r6                / addr of string into r1
        bal     r14,strlen           / get length of string
        lr      r2,r1                / init the counter to current byte
        sr      r1,r6                / length is now in r1
        lr      r5,r1                / save length in r5 for later use
        la      r11,atetbl           / r11 needs atetbl addr for execute
        ex      r1,trans             / translate string, ascii to ebcdic

        la      r3,80(0,r6)          / add 80 to string addr, last byte
blankit:
        mvc     0(1,r2),blank        / blank out byte of record
        la      r2,1(0,r2)           / increment r2 to next byte
        cr      r2,r3                / are we at end of record?
        bne     blankit              / no. blank out next byte
        la      r1,wrccw             / set up for i/o to device
        st      r1,CAW               / store the channel address word
        bal     r14,csio             / do the i/o
        bal     r14,rest             / wait for the i/o to complete
        b       realdone             / all done, reset gpr's and punt
/
/ try the full screen output to some device
/
fullscr:
/
/ if there is a 0 in response addr, then just do a display, no input
/ is coming in
/
        sr      r1,r1                / set up r1 for 0 compare
        st      r1,flag
        clr     r7,r1                / check response for 0, if 0 then
        bz      fullout              / do just output to tube, no input
/
/
/ translate the console prompt to ebcdic so we can translate it
/ back to ascii at realdone (for full screen and then back to console bug)
/
	lr      r1,r6                / set up r1 with the addr of string
        bal     r14,strlen           / get length of string
        sr      r1,r6                / the length is now in r1
        lr      r5,r1                / save length of str for later use
        la      r11,atetbl           / r11 needs atetbl addr for execute
        ex      r1,trans             / exec translate, ascii to ebcdic
/
fprompt:
        la      r1,flprompt
        stcm    r1,7,fullwr+1        / put addr of string into ccw
        la      r1,fullwr            / set up for i/o to device
        st      r1,CAW               / store the channel address word
redocom:
        bal     r14,csio             / do the i/o
        sr      r1,r1
        la      r1,1(0,r1)
        st      r1,flag
        bal     r14,rest             / wait for i/o to complete and attn
        sr      r1,r1                / set up r1 with 0
        st      r1,flag              / reset the flag
/
/ do the read of the buffer
/
        stcm    r7,7,fullrd+1        / store address of response into ccw
        xc      0(160,r7),0(r7)      / blank out the response area
        la      r1,fullrd            / set up for i/o to device
        st      r1,CAW               / store channel address word
        bal     r14,csio             / do the i/o, both write and read
        bal     r14,rest             / wait for the i/o to complete
/
/ check the buffer for the clear key, if so, redo the prompt
/
        sr      r9,r9
        ic      r9,0(,r7)            / get first byte of buffer
        cl      r9,clearky           / was the clear key hit?
        bne     chktreq              / no, check for test req key
        sr      r9,r9                / clear hit, reset buffer addr to 1
        st      r9,row               / row 0 for next write
        b       fprompt              / yes, redo the prompt, etc.
chktreq:
        l       r9,0(,r7)            / get 4 bytes in case of test req hdr
        cl      r9,testreq           / check buffer for test req key
        bne     rddone               / no, on to finish the read
/
/ set up for redisplay
/
        mvc     redisp+18(60),precom / move in the prev com 60 bytes of
        la      r1,redisp
        stcm    r1,7,treqccw+1       / set up for i/o
        la      r1,treqccw           / get ccw string addr to r1
        st      r1,CAW               / set up the caw with ccw addr
        b       redocom              / go to redo the previous command
/
/ the read is complete, now fix up the buffer for the 'C' program on the
/ receiving end, i.e. get rid of 5 bytes that are full screen related
/ and then give back the buffer to 'normal' processing.
/
rddone: lr      r8,r7
        la      r10,6(0,r8)
        l       r9,curtlen
        l       r11,curtlen
        mvcl    r8,r10               / shift left 5 bytes.
        mvc     precom(160),0(r7)    / save the previous command
/
        b       complete             / all done, reset gpr's and punt
/
/ just do full screen output of the string that was passed in.
/
fullout:
        lr      r1,r6                / addr of string into r1
        bal     r14,strlen           / get length of string
        lr      r2,r1                / init the counter to current byte
        st      r2,currbyt           / save this counter for later
        sr      r1,r6                / length is now in r1
        lr      r5,r1                / save length in r5 for later use
        la      r11,atetbl           / r11 needs atetbl addr for execute
        ex      r1,trans             / translate string, ascii to ebcdic
        la      r1,6(0,r1)           / add 6 to length of the string
/
/ figure out the row to write to and set up the proper fullscreen
/  attibute bytes (i.e. the first 4 of the buffer).
/
        l       r3,row               / which row to write to
        c       r3,lastrow           / are we at the last row?
        bne     rowok
goclr:  bal     r10,wrmore           / last row written, write 'more' and
        bal     r10,waitclr          /  wait for clear key to get hit
/
/ check the buffer for the clear key, if so, redo the prompt
/
        sr      r9,r9
        ic      r9,rdclear           / get first byte of buffer
        cl      r9,clearky           / was the clear key hit?
        be      clrk                 / yes, reset the row
        cl      r9,keypa1            / was the pa1 key hit?
        bne     goclr                / no, wait for clear key
        sr      r9,r9                / pa1 hit, reset buffer addr to 1
        la      r9,1(,r9)            / ready to set pa1 key flag
        st      r9,pa1key            / set the flag
        b       goclr
clrk:   sr      r3,r3                / reset to row 1
rowok:  la      r4,bufaddr           / get the row buffer address
        ar      r4,r3                / increment into the table
        mvc     thebuff(4),0(r4)     / move in the 4 attribute bytes
        a       r3,four              / add four to the row count
        st      r3,row               / put in a 'safe' place
/
        la      r3,80(0,r6)          / add 80 to string addr, last byte
        l       r2,currbyt           / restore current byte from save area
blankt:
        mvc     0(1,r2),blank        / blank out byte of record
        la      r2,1(0,r2)           / increment r2 to next byte
        cr      r2,r3                / are we at end of record?
        bne     blankt               / no, blank the next byte
        mvc     thebuff+6(80),0(r6)  / put the string into the buffer
        la      r1,thebuff
        stcm    r1,7,fullio+1        / put addr of string into ccw
        la      r1,fullio            / set up for i/o to device
        st      r1,CAW               / store the channel address word
        bal     r14,csio             / do the i/o
        bal     r14,rest             / wait for the i/o to complete
        b       realdone             / all done.
/
/ the user has input some data (a response), translate to ascii for comak
/
complete:
         lr      r1,r7               / load up r1 with address of string
         bal     r14,strlen          / figure out how many characters
         tr      0(160,r7),etatbl    / trans. response, ebcdic to ascii
         mvc     0(1,r1),nline       / force the line feed char '0a' in
         la      r1,1(r1)            / add 1 to the length of the string
         sr      r1,r7               / length of string into r1
         lr      r0,r1               / were read in, pass back in r0
realdone:
         la      r11,etatbl          / translate output str back to ascii
         ex      r5,trans            / use r5, length of str, for trans.
/
/    restore gpr's, ext. new psw of Au and go back to comak....
/
         mvc     EXTNPSW(8),savpsw   / restore Au's external new psw
         mvc     EXTCODE(2),intcode  / restore Au's external int code
         mvc     IOADDR(4),audev     / restore Au's i/o device addr
         mvc     CAW(4),tmpcaw       / restore Au's CAW
         mvc     CSW(8),tmpcsw       / restore Au's CSW
         lm      r1,r15,gprsa+4      / restore gprs, all except r0
         br      r14                 / fly away to comak
/
/ start the i/o to the appropriate device, r8 has the address
/ loop around the tio and sio until the sio returns with a 0 cc.
/
csio:
        sio     0(r8)                / start i/o
        bc      8,goodio             / o.k. on the sio? yes, cc=0
        bc      4,cswstor            / looks like a cc of 1.
        bc      2,openwide           / have to swallow a complete rupt.
        bc      1,notoper            / no, cc=3, device broke.. die
/
/ Au has issued a sio for 'my' device, do a fix up on the csw and
/  present it to Au later.
/
cswstor:
/       tm      CSW+4,x'10'          / Was the device busy?
/       bz      notbusy
        ni      CSW+4,255-x'10'      / Don't want Au to see that.
        oc      tmpcsw+4(1),CSW+4    / Stick the new in with the old.
        tm      tmpcsw+4,x'04'       / Was the device done?
        bo      testio               / Yep.
        tio     0(r8)                / Hit it on the head.
        bc      4,cswstor            / Try it all again.
        balr    r9,r0                / Oh well.
        b       error
/notbusy:
/                                    / Fall through to 'openwide'.
/
/ need to save Au's state for this device
/  and then restore it before onward.
/
/ the cond code is 2, meaning Omak must pose channel and device end for
/  this device.  If Andy was a real fanatic, he would track down the last
/  CCW for this device, which is often a NO-OP, and point his CAW at that,
/  this would cause the next CSW for this device to look super.
/
openwide:
        sr      r1,r1                / going to set a flag
        la      r1,1(,r1)            / set the flag to 1
        st      r1,stsion            / set start sio for Au flag
        b       testio               / get the csw and clear the device
/
notoper:                             / device dead, hang up here
        balr    r9,r0                / load error address, where we quit
        b       error                / die, device not operational
/
testio:
        tio     0(r8)                / test the device
        bc      8,csio               / tio clean. reissue the sio
        bc      1,notoper            / no, cc=3, device broke.. die
        tm      CSW+4,x'0c'          / channel end and dev end??
        bo      csio                 / do the sio again..
        b       testio               / io not done, check it out again
goodio: br      r14                  / return to continue processing
/
/ the external rest routine.
/
/ after sio issued and working, set up cpu timer and wait.
/
rest:                                /
        stctl   r0,r15,ctlrsa        / save control registers
        stctl   r0,r0,ncr0           / save control register 0 for mod
/
/ set up control register 0 with a 1 in bit 21, first 5 bytes are
/ left alone, could be something of value in them.
/ zero out the other bits having to do with time (i.e. time stops here).
/
        la      r2,x'400'            / this will put a 1 in bit 21 of r2
        sth     r2,ncr0+2            / put the bit in the new cr 0
        lctl    r0,r0,ncr0           / cpu timer only, bit 21 of cr 0
time:
        spt     timer                / set cpu timer, 5 microscnds? or so
        lpsw    waitpsw              / only allow ext. int's and wait
/
/ come here on an external interrupt, hopefully it is the CPU timer.
/
/ the i/o will be cleared by a tio when we arrive, if it has completed,
/ otherwise, just wait for it a bit longer.
/
extrupt:
        mvc     extopsw(8),EXTOPSW   / save the current psw
        lh      r2,EXTCODE           / get the external interrupt code
        ch      r2,cputmr            / check the ext int code, cpu timer??
        bc      8,checkio            / yes, check the i/o for completion
        balr    r9,r0                / load error address, we got trouble
        b       error                / death on the nile
checkio:
        tm      flag+3,1             / is the flag set? i.e. need attn
        bz      tio1
        tio     0(r8)
        bc      8,time
        bc      2,time
        bc      4,chkattn
        balr    r9,r0
        b       error
chkattn:
        tm      CSW+4,x'80'          / attn ?
        bo      tiogood
        b       time
tio1:   tio     0(r8)                / issue the test io for the device
        bc      8,tiogood            / cc=0, tio clean, device available
        bc      4,tiocsw             / cc=1, csw stored, check it out
        bc      2,tiobusy            / cc=2, dev busy, wait, reset timer
        balr    r9,r0                / cc=3, load error addr, dev not good
        b       error                / punt.
tiobusy:
        b       time                 / reset cpu timer and wait
tiocsw:
        tm      CSW+4,x'0c'          / channel end and dev end??
        bc      1,tiogood            / yes, all set up to process
        b       checkio              / all other conditions, reissue tio.
tiogood:
        lctl    r0,r15,ctlrsa        / reset control registers
        br      r14                  / return to 'normal' processing
/
/ returns length of string, not counting the ending null
/
strlen:
	la      r0,1       / increment
next:
	cli     0(r1),0    / do we have a null??
	be      figure     / yes.
	ar      r1,r0      / no, increment string pointer
	b       next       / check next character.
figure:
	br	r14

wrmore:
        la      r1,clrbuff
        stcm    r1,7,fullclr+1       / put addr of string into ccw
        la      r1,fullclr           / set up for i/o to device
        st      r1,CAW               / store the channel address word
        bal     r14,csio             / do the i/o
                                     / wait for attn from device
        sr      r1,r1                / zero to r1
        la      r1,1(0,r1)           / ready to set flag
        st      r1,flag              / set flag so wait is for attn
        bal     r14,rest             / wait for the i/o to complete
        sr      r1,r1                / set up r1 with 0
        st      r1,flag              / reset the flag
        br      r10                  / return to sender
waitclr:
        la      r1,rdclear
        stcm    r1,7,fullrd+1        / store read buffer addr into ccw
        xc      0(160),0(r1)         / blank out the read area
        la      r1,fullrd            / set up for read
        st      r1,CAW               / almost ready for read
        bal     r14,csio             / issue i/o
        bal     r14,rest             / wait for chan end dev end
        br      r10                  / return to sender
/
/ all punts come hither
/
error:
        st      9,errpsw+4
        lpsw    errpsw
/
/       tr      0(0,r6),atetbl    / what translate instr looks like
trans:  ds      0d                / translate string, ascii to ebcdic
        dc      x'dc006000b000'

CSW = 64
CAW = 72
IOOPSW = 56
IONPSW = 120
IOADDR = 184
EXTOPSW = 24
EXTNPSW = 88
EXTCODE = 134

         entry   stsion
stsion:  ds      1f           / start sio for Au flag.
         dc      xl4'0'
         entry   pa1key
pa1key:  ds      1f           / flag for pa1 key, 0 not hit, 1 hit
         dc      xl4'0'
temp6:   ds      1f
row:     ds      1f
four:    dc      xl4'4'
lastrow: dc      xl4'54'      / last row is 84/4 is 21
flag:    ds      1f
currbyt: ds      1f
tmpcaw:  ds      1f
tmpcsw:  ds      2f
intcode: ds      1h
audev:   ds      1f
nline:   dc      x'0a'
blank:   dc      x'00'
clearky: dc      xl4'6d'              / clear key depressed
keypa1:  dc      xl4'6c'              / pa1 key depressed
testreq: dc      x'016c6102'          / test req depressed
conaddr: ds      0f
         dc      xl4'009'
curtlen: dc      xl4'a0'              / 160 bytes.
precom:  ds      40f                  / 160 bytes for previous command
         entry   auaddr
auaddr:  ds      1f
junk:    ds      0d
gprsa:   ds      16f                  / general reg save area
ctlrsa:  ds      16f                  / control reg save area
ncr0:    ds      1f
junk1:   ds      0d
timer:   ds      1d
         dc      x'0000000000005000'  / 5 microseconds?? for timer
cputmr:
         dc      x'1005'              / ext. int. code for cpu timer
/
/ data areas that are not altered (too much)
/
waitpsw:ds      0d
        dc      x'010a000000000000'    / ext int's, ecmode and wait state
errpsw:
        dc      x'0002000000000000'
extnpsw:
        dc      x'0008000000000000'
extopsw:
        ds      d
savpsw:
        ds      d
conscp:
        ccw     x'09',0,x'60',0   / store address and length at the 0's
        ccw     x'0a',0,x'60',160
        ccw     x'03',0,x'20',1
wrccw:
        ccw     x'09',0,x'00',80                / 80 bytes output
        ccw     x'03',0,x'20',1
fullwr:
        ccw     x'01',0,x'60',23                / write to 3270
        ccw     x'03',0,x'20',1                 / no-op
fullrd:
        ccw     x'06',0,x'60',160               / read (modified) of 3270
        ccw     x'03',0,x'20',1                 / no-op
fullio:
        ccw     x'01',0,x'60',80                / write to 3270
        ccw     x'03',0,x'20',1                 / no-op
treqccw:
        ccw     x'01',0,x'60',84                / write to 3270
        ccw     x'03',0,x'20',1                 / no-op
fullclr:
        ccw     x'01',0,x'60',27                / write 'Omak more...'
        ccw     x'03',0,x'20',1                 / no-op
thebuff:
        dc      x'c31140401d60'
        ds      20f
clrbuff:
        dc      x'c3115d6b125d7d115d6b1d60d694819240949699854b4b4b'
        dc      x'115be61d4013'
                / "Omak more..." in EBCDIC
flprompt:
/
/ cc  =  write (01)
/ wcc =  reset mdt, keyboard restore (c3)
/ sba =  0x11
/ sf  =  0x1d
/
        dc      x'c3115b60125d6b115b601d60d69481927a'
        dc      x'115be61d4013'
                / "Omak:" in EBCDIC
redisp:
        dc      x'c3115b60125d6b115b601d60d69481927a40'
        ds      60b
        dc      x'115be61dc113'             / the c1 sets the mdt on
                / "Omak: + previous command" in EBCDIC
/
         ds      0d
rdclear: ds      40f
        end
