#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/signal.h"
#include "../h/proc.h"
#include "../h/inode.h"
#include "../h/reg.h"
#include "../h/370.h"
#include "../h/bitmap.h"
#include "../h/buf.h"
#include "../h/mon.h"
 
#define max(A, B)       ((A) > (B)? (A): (B))
#define min(A, B)       ((A) < (B)? (A): (B))

/*
 * Priority for tracing
 */
#define IPCPRI  PZERO
 
/*
 * Tracing variables.
 * Used to pass data between parent and child.
 * This data base cannot be
 * shared and is locked
 * per user.
 */
struct
{
        short   ip_lock;
        short   ip_req;
        caddr_t ip_addr;
        struct buf *ip_buf;
} ipc;

/*
 * sigtrace system call
 * Turns on or off tracing of specified signal.
 */
sigtrace()
{
	register struct proc *p;
	register struct a {
		int     pid;
		int     sig;
		int     flag;
	} *uap;
	uap = (struct a *)u.u_ap;
	if(uap->sig <= 0 || uap->sig > NSIG) {
		u.u_error = EINVAL;
		return;
	}
	if(uap->pid == 0) {
		if(uap->flag) {
			bset(u.u_sigtr, uap->sig);
			u.u_procp->p_flag |= STRC;
		} else {
			bclr(u.u_sigtr, uap->sig);
		}
		return;
	}

	for(p = proc; p < &proc[NPROC]; p++)
	if(p->p_pid == uap->pid && (p->p_flag & STRC) &&
		p->p_ppid == u.u_procp->p_pid) {
		if(uap->flag) {
			bset(p->p_addr->u_sigtr, uap->sig);
		}
		else {
			bclr(p->p_addr->u_sigtr, uap->sig);
		}
		return;
	}
	u.u_error = ESRCH;
}
 
/*
 * sys-trace system call.
 */
ptrace()
{
        register struct proc *p;
	register struct user *cu;
	int e, ps;
	register struct a {
		int     pid;
		int     flag;
		caddr_t up;
	} *uap;
 
	uap = (struct a *)u.u_ap;
        for (p = proc; p < &proc[NPROC]; p++)
        if (p->p_pid == uap->pid && p->p_stat == SSTOP &&
                 p->p_ppid==u.u_procp->p_pid)
                        goto found;
        u.u_error = ESRCH;
        return;
 
found:
	cu = p->p_addr;
	e = 0;
	if(uap->flag == 0) {       /* get state */
		e |= copyout((caddr_t)cu->u_ar0, uap->up, SZREGS);
		e |= copyout((caddr_t)&cu->u_ps, uap->up+SZREGS, sizeof cu->u_ps);
		e |= copyout((caddr_t)&cu->u_utime, uap->up+SZREGS+sizeof cu->u_ps, 4*8);
	} else {      /* set state and start */
		ps = cu->u_ar0[RPS];
		e |= copyin(uap->up, (caddr_t)cu->u_ar0, SZREGS);
		e |= copyin(uap->up+SZREGS, (caddr_t)&cu->u_ps, sizeof cu->u_ps);
		cu->u_ar0[RPS] = (ps & ~PSMASK) | (cu->u_ar0[RPS] & PSMASK);
		cu->u_ar0[RPC] &= PCMASK;
		cu->u_ps.ps_cr8 &= CR8MASK;
		cu->u_ps.ps_cr9 &= CR9MASK;
		cu->u_ps.ps_cr10 &= CR10MASK;
		cu->u_ps.ps_cr11 &= CR11MASK;
                cu->u_ps.ps_tslice = max(cu->u_ps.ps_tslice, MIN_TSLICE);
		cu->u_ps.ps_tslice = min(cu->u_ps.ps_tslice, MAX_TSLICE);
                cu->u_chreg = 1;
		p->p_flag &= ~SWTED;
		setrun(p);
	}
	if(e) u.u_error = EFAULT;
}

/*
 * Process image I/O
 * Used by a parent to read from and write to a child being traced.
 */
pio()
{
	register rdwr;
	register struct proc *p;
	int n;
	struct buf *bp;
	register struct a {
		int     pid;
		int     rdwr;
		caddr_t addr;
		caddr_t bufp;
		int     n;
	} *uap;

	uap = (struct a *)u.u_ap;
	if(uap->rdwr)
		rdwr = B_WRITE;
	else
		rdwr = B_READ;
	for(p = proc; p < &proc[NPROC]; p++)
	if(p->p_pid == uap->pid && p->p_stat == SSTOP &&
		p->p_ppid == u.u_procp->p_pid)
			goto found;
	u.u_error = ESRCH;
	return;
found:
	while(ipc.ip_lock)
		sleep((caddr_t)&ipc, IPCPRI);
	ipc.ip_lock = uap->pid;
	ipc.ip_req = !rdwr;
	bp = ipc.ip_buf = geteblk();
	u.u_segflg = 0;
	u.u_offset = (off_t)uap->addr;
	u.u_base = uap->bufp;
	u.u_count = uap->n;
	while(u.u_count != 0 && u.u_error == 0) {
		ipc.ip_addr = (caddr_t)u.u_offset;
		bp->b_bcount = n = min(BSIZE, u.u_count);
		if(rdwr == B_WRITE) iomove(bp->b_un.b_addr, n, B_WRITE);
		if(u.u_error) break;
		bp->b_flags &= ~(B_DONE+B_ERROR);
		setrun(p);
		iowait(bp);
		if(rdwr == B_READ && u.u_error == 0)
			iomove(bp->b_un.b_addr, n, B_READ);
	}
	brelse(bp);
	ipc.ip_lock = 0;
	wakeup((caddr_t)&ipc);
}
 
/*
 * Code that the child process
 * executes to implement the pio command
 * of the parent process in tracing.
 */
procxmt()
{
	register struct buf *bp;
	register rdwr;
	int base, offset, count, segflg;

	if(ipc.ip_lock != u.u_procp->p_pid)
		return(1);
	rdwr = ipc.ip_req;
	bp = ipc.ip_buf;
	base = (int) u.u_base;
	offset = u.u_offset;
	count = u.u_count;
	segflg = u.u_segflg;
	u.u_segflg = 0;
	u.u_base = ipc.ip_addr;
	if(rdwr == B_READ && u.u_base < (caddr_t)ctob(u.u_tseg.u_size))
		u.u_error = EFAULT;
	else
	        iomove(bp->b_un.b_addr, (int)bp->b_bcount, rdwr);
	if(u.u_error) {
		bp->b_flags |= B_ERROR;
		u.u_error = 0;
	}
	iodone(bp);
	u.u_base = (caddr_t) base;
	u.u_offset = offset;
	u.u_count = count;
	u.u_segflg = segflg;
	return(0);
}
