/*------------ source/s4/util/xmsg.c --------*/
/* char Sccsid [] "@(#)xmsg  1.1"; */
/*
        Call fatal with an appropriate error message
        based on errno.  If no good message can be made up, it makes
        up a simple message.
        The second argument is a pointer to the calling functions
        name (a string); it's used in the manufactured message.
*/
 
# include       <errno.h>
# include       "macros.h"
 
xmsg(file,func)
char *file, *func;
{
        register char *str;
        extern int errno;
        extern char Error[];
 
        switch (errno) {
        case ENFILE:
                str = "no file (help sys.3)";
                break;
        case ENOENT:
                sprintf(str = Error,"'%s' nonexistent (help sys.4)",file);
                break;
        case EACCES:
                str = malloc(size(file));
                copy(file,str);
                file = str;
                sprintf(str = Error,"directory '%s' unwritable (help sys.2)",
                        dname(file));
		free(file);
                break;
        case ENOSPC:
                str = "no space! (help sys.10)";
                break;
        case EFBIG:
                str = "write error (help sys.8)";
                break;
        default:
                sprintf(str = Error,"errno = %d, function = '%s' (help sys.11)",errno,
                        func);
                break;
        }
        return(fatal(str));
}
