	subroutine vrshft(l3, z, conv)

c carries out the third stage iteration.
c l3 - limit of steps in stage 3
c z - on entry contains the initial iterate, if the
c iteration converges it contains the final iterate on exit.
c conv - if true, iteration converged

	common /global/ p, h, qp, qh, shr, shi, s, t, pv, are,
&		mre, eta, infin, nn
	doublecomplex s, t, pv, p(15), h(15), qp(15), qh(15)
	doubleprecision are, mre, eta, infin, shr(15), shi(15)

	doublecomplex z
	doubleprecision mp, ms, omp, relstp, r1, errev, tp
	logical conv, b, bool

	conv = .false.
	b = .false.
	s = z

c main loop for stage 3

	do 60 i = 1, l3

c evaluate p at s and test for convergence

		call polyev(nn, s, p, qp, pv)
		mp = dcabs(pv)
		ms = dcabs(s)
		if (mp .gt. 20.0d0*errev(nn, qp, ms, mp, are, mre))
&						goto 10

c polynomial value is smaller in value than a bound on the error
c in evaluating p, terminating the iteration

			conv = .true.
			z = s
			return
10		if (i.eq.1) goto 40
			if (b .or. mp.lt.omp .or. relstp.ge. .05d0)
&						goto 30

c iteration has stalled. probably a cluster of zeros. do 5 fixed
c shift steps into the cluster to force one zero to dominate.

				tp = relstp
				b = .true.
				if (relstp .lt. eta) tp = eta
				r1 = dsqrt(tp)
				s = s*dcmplx(r1+1, r1)
				call polyev(nn, s, p, qp, pv)
				do 20 j = 1,5
					call calct(bool)
					call nexth(bool)
20				continue
				omp = infin
				goto 50

c exit if polynomial value increases significantly

30			if (mp*.1d0 .gt. omp) return
40		omp = mp

c calculate next iterate

50		call calct(bool)
		call nexth(bool)
		call calct(bool)
		if (bool) goto 60
		relstp = dcabs(t)/dcabs(s)
		s = s+t
60	continue
	return
	end
