#
/*****************************************************************
 **								**
 **		   U C L A  Data Secure Unix			**
 **								**
 **			Copyright 1977				**
 **								**
 **    Mark Kampe, Charles Kline, Gerald Popek, Evelyn Walton	**
 **								**
 *****************************************************************/
#define true 0177777
#define false 000000
#define then /* */

#include "../../shared/constants.h"
#include "../../shared/shared.h"
#include "../../shared/fscom.h"
#include "../conf.h"
#include "../param.h"
#include "../blkdev.h"
#include "../param.h"
#include "../user.h"

gcap();
/* name:
	blkopen

function:
	to open a  block device

algorithm:
	make sure the unit number is reasonable
	if it is already open with adequate access, return true
	build a message to the filesystem process
	call gcap

parameters:
	device number
	access

returns:
	true or false and a setting of u.u_error

globals:
	u.u_error
	fsmsg

calls:
	gcap

called by:
	iinit
	smount

history:
	Designed and coded by Mark Kampe
*/

struct fsmsg fsmsg;

blkopen( dev , access )
 int dev, access;
{	register int d;
	register struct blkdevtab *bp;

	d = dev;
	if (d >= NBLKDEV) then
	{	u.u_error = ENODEV;
		return( false );
	}
	else	bp = &blkdevtab[d];

	if (bp->b_open && ((bp->b_access & access) == access)) then
	{	if (access & _READ_ACCESS)
		then	bp->b_r_refcount++;
		if (access & _WRITE_ACCESS)
		then	bp->b_w_refcount++;
		return( true );
	}

	/* we will have to dicker with the file system process */
	fsmsg.fs_opcode = FS_GRANT;
	fsmsg.fs_type = _SWAP_DEVICE;
	fsmsg.fs_cap1 = -1;
	fsmsg.fs_cap0 = dev;
	fsmsg.fs_id[1] = dev;
	fsmsg.fs_id[0] = 0;
	fsmsg.fs_pid = _proc_index;
	fsmsg.fs_access = access | bp->b_access;

	if (gcap()) then
	{	bp->b_access = access;
		bp->b_open = true;
		if (access & _READ_ACCESS)
		then	bp->b_r_refcount++;
		if (access & _WRITE_ACCESS)
		then	bp->b_w_refcount++;
		return( true );
	}
	else
	{	u.u_error = EACCES;
		return( false );
	}
}
/* name:
blkclose

function:
	to close a reference to a block device

algorithm:
	see if it is an open device (error if not)
	decrement the reference count
	if the count went to zero, surrender the device

parameters:
	device
	access device was open with

returns:
	true or false and a setting of u.u_error

globals:
	u.u_error
	blkdevtab
	fsmsg

calls:
	gcap

called by:
	sumount

history:
	Designed and coded by mark kampe
*/

blkclose( dev , access )
 int dev;
 int access;
{	register int d;
	register struct blkdevtab *bp;

	d = dev;
	if (( d >= NBLKDEV ) || (blkdevtab[d].b_open == false)) then
	{	u.u_error = ENODEV;
		return( false );
	}

	bp = &blkdevtab[d];

	if (access & _READ_ACCESS)
	then	bp->b_r_refcount--;
	if (access & _WRITE_ACCESS)
	then	bp->b_w_refcount--;

/* FIX me to surrender individual accesses when access counts go 0 */
	if ((bp->b_r_refcount+bp->b_w_refcount) > 0)
	then	return( true );

	bp->b_open = false;
	bp->b_access = _NULL_ACCESS;

	fsmsg.fs_opcode = FS_REVOKE;
	fsmsg.fs_type = _SWAP_DEVICE;
	fsmsg.fs_cap1 = -1;
	fsmsg.fs_cap0 = d;
	fsmsg.fs_id[1] = d;
	fsmsg.fs_id[0] = 0;
	fsmsg.fs_pid = _proc_index;
	fsmsg.fs_access = _NULL_ACCESS;

	return( gcap() );
}
