#include "astro.h"

double
dist(p1, p2)
struct object *p1, *p2;
{
	register struct object *p, *q;
	double a;

	p = p1;
	q = p2;
	a = sin(p->decl2)*sin(q->decl2) +
		cos(p->decl2)*cos(q->decl2)*cos(p->ra-q->ra);
	a = fabs(atan2(pyth(a), a)) / radsec;
	return(a);
}

rline(f)
{
	register char *p;
	register c;

	p = line;
	do {
		c = getc(f);
		if(c < 0)
			return(1);
		*p++ = c;
	} while(c != '\n');
	return(0);
}

double
sunel(t)
double t;
{
	register i;

	i = floor(t);
	if(i < 0 || i > NPTS+1)
		return(-90.);
	t = osun.point[i].el +
		(t-i)*(osun.point[i+1].el - osun.point[i].el);
	return(t);
}

double
rise(op)
struct object *op;
{
	register struct object *p;
	register i;
	double e1, e2;

	p = op;
	for(i=0; i<=NPTS; i++) {
		e1 = e2;
		e2 = p->point[i].el;
		if(i >= 1 && e1 < 0. && e2 > 0.)
			goto found;
	}
	return(-1.);

found:
	return(i - 1. - e1/(e2-e1));
}

double
set(op)
struct object *op;
{
	register struct object *p;
	register i;
	double e1, e2;

	p = op;
	for(i=0; i<=NPTS; i++) {
		e1 = e2;
		e2 = p->point[i].el;
		if(i >= 1 && e1 > 0. && e2 < 0.)
			goto found;
	}
	return(-1.);

found:
	return(i - 1. + e1/(e1-e2));
}

double
solstice(n)
{
	register i;
	double d1, d2, d3;

	d3 = (n*pi)/2 - pi;
	if(n == 0)
		d3 =+ pi;
	for(i=0; i<=NPTS; i++) {
		d1 = d2;
		d2 = osun.point[i].ra;
		if(n == 0) {
			d2 =- pi;
			if(d2 < -pi)
				d2 =+ 2.*pi;
		}
		if(i >= 1 && d3 >= d1 && d3 < d2)
			goto found;
	}
	return(-1.);

found:
	return(i - (d3-d2)/(d1-d2));
}

double
betcross(b)
float b;
{
	register i;
	double d1, d2;

	for(i=0; i<=NPTS; i++) {
		d1 = d2;
		d2 = osun.point[i].mag;
		if(i >= 1 && b >= d1 && b < d2)
			goto found;
	}
	return(-1.);

found:
	return(i - (b-d2)/(d1-d2));
}

double
melong(op)
struct object *op;
{
	register struct object *p;
	register i;
	double d1, d2, d3;

	p = op;
	for(i=0; i<=NPTS; i++) {
		d1 = d2;
		d2 = d3;
		d3 = dist(&p->point[i], &osun.point[i]);
		if(i >= 2 && d2 >= d1 && d2 >= d3)
			goto found;
	}
	return(-1.);

found:
	return(i - 2.);
}

struct event
{
	char	*format;
	char	*arg1;
	char	*arg2;
	double	tim;
	int	flag;
} events[100], *eventp;

event(format, arg1, arg2, tim, flag)
char *format, *arg1, *arg2;
double tim;
{
	register struct event *p;

	if(flag & DARK) {
		if(sunel(tim) > -12.)
			return;
	}
	if(flag & LIGHT) {
		if(sunel(tim) < 0.)
			return;
	}
	if(eventp == 0)
		eventp = events;
	p = eventp;
	eventp++;
	p->format = format;
	p->arg1 = arg1;
	p->arg2 = arg2;
	p->tim = tim;
	p->flag = flag;
}

evflush()
{
	register struct event *p;

	qsort(events, eventp-events, sizeof *p, evcomp);
	for(p = events; p<eventp; p++) {
		if(p->flag & SIGNIF && flags & SPEAK)
			printf("ding ding ding ");
		printf(p->format, p->arg1, p->arg2);
		if(p->flag & PTIME)
			ptime(day + p->tim*deld);
		printf("\n");
	}
	eventp = 0;
}

evcomp(p1, p2)
struct event *p1, *p2;
{
	double t1, t2;

	t1 = p1->tim;
	t2 = p2->tim;
	if(p1->flag & SIGNIF)
		t1 =- 1000.;
	if(p2->flag & SIGNIF)
		t2 =- 1000.;
	if(t1 > t2)
		return(1);
	if(t2 > t1)
		return(-1);
	return(0);
}

double
pyth(x)
double x;
{

	x =* x;
	if(x > 1.)
		x = 1.;
	return(sqrt(1.-x));
}

skip(n)
{
	register i;
	register char *cp;

	cp = line;
	for(i=0; i<n; i++) {
		while(*cp == ' ' || *cp == '\t')
			cp++;
		while(*cp != '\n' && *cp != ' ' && *cp != '\t')
			cp++;
	}
	while(*cp == ' ' || *cp == '\t')
		cp++;
	return(cp);
}
