#include "cx.h"

bagen()
{
	register *p1, *p2, *p3;

	p1 = lmp;
	if((flag&BOO) != 0)
	if(board[5]==0 && board[6]==0)
	if(wattack(4) && wattack(5) && wattack(6))
		bcheck(4, 6);
	if((flag&BOOO) != 0)
	if(board[1]==0 && board[2]==0 && board[3]==0)
	if(wattack(2) && wattack(3) && wattack(4))
		bcheck(4, 2);
	bgen();
	p2 = p1;
	p3 = p1;
	while(p2 != lmp) {
		bmove(*p2);
		if(wattack(bkpos))
			*p1++ = *p2;
		p2++;
		bremove();
	}
	lmp = p1;
}

bgen()
{
	int j, k;
	register d, i, *p;

	i = 64;
	while(i--)
	switch(board[i]) {

	/* pawn */
	case BPAWN1:
	case BPAWN2:
	case BPAWN3:
	case BPAWN4:
	case BPAWN5:
	case BPAWN6:
	case BPAWN7:
	case BPAWN8:
		if(((d=dir[i])&DLEFT)==0) {
			if(ispiece[board[i+7]] > 0)
				bcheck(i, i+7);
			if(eppos == i+7)
				bcheck(i, i-1);
		}
		if((d&DRIGHT)==0) {
			if(ispiece[board[i+9]] > 0)
				bcheck(i, i+9);
			if(eppos == i+9)
				bcheck(i, i+1);
		}
		if(board[i+8]==0) {
			bcheck(i, i+8);
			if((d&RANK7)!=0)
			if(board[i+16]==0)
				bcheck(i, i+16);
		}
		continue;

	/* knight */
	case BKNIG1:
	case BKNIG2:
		p = attab;
		goto jump;

	/* king */
	case BKING:
		p = attab+16;

	jump:
		d = dir[i];
		for(j=8; j--; p=+2)
			if((d&p[0])==0)
				bcheck(i, i+p[1]);
		continue;

	/* bishop */
	case BBISH1:
	case BBISH2:
		p = attab+16;
		j = 4;
		goto slide;

	/* rook */
	case BROOK1:
	case BROOK2:
		p = attab+24;
		j = 4;
		goto slide;

	/* queen */
	case BQUEEN:
		p = attab+16;
		j = 8;

	slide:
		while(j--) {
			k = i;
			while((dir[k]&p[0]) == 0)
				if(bcheck(i, k=+p[1]))
					break;
			p =+ 2;
		}
		continue;
	}
}

bcheck(from, to)
{
	register b;
	register char *p;

	b = board[to];
	if(ispiece[b] < 0)
		return(TRUE);
	p = lmp;
	*p++ = from;
	*p++ = to;
	lmp = p;
	return(b);
}

bmove(mov)
{
	int pfrom, pto;
	register from, to;
	register struct mstr *lp;

	lp = amp;
	amp++;
	from = mov.pfrm;
	to = mov.pto;
	lp->mval = value;
	lp->mflg = flag & ~NOREP;
	lp->mepp = eppos;
	lp->mfrm = from;
	lp->mto = to;
	pto = board[to];
	if(lp->mpto = pto) {
		if(ispawn[pto])
			value.valpwn =- 1; else
			value.valpce =+ pval[pto];
		lp->mflg =| NOREP;
		if(pto == WROOK1)
			flag =& ~WOOO; else
		if(pto == WROOK2)
			flag =& ~WOO;
	}
	board[to] = pfrom = board[from];
	board[from] = 0;
	eppos = -1;
	switch(pfrom) {

	case 0:
		for(to=0; movlst[to].movnam; to++)
			if(movlst[to].movval == mov) {
				lp->mtyp = movlst[to].movtyp;
				return;
			}
		abort();

	/* pawn */
	case BPAWN1:
	case BPAWN2:
	case BPAWN3:
	case BPAWN4:
	case BPAWN5:
	case BPAWN6:
	case BPAWN7:
	case BPAWN8:
		lp->mflg =| NOREP;
		switch(from-to) {

		case 1:
		case -1:
			board[to] = 0;
			board[to+8] = pfrom;
			lp->mtyp = TEP;
			return;

		case -16:
			eppos = from+8;
			break;
		}
		if((dir[from]&RANK2)!=0) {
			value.valpce =+ pval[BQUEEN];
			value.valpwn =- 1;
			board[to] = BQUEEN;
			lp->mpar = pfrom;
			lp->mtyp = TQPRO;
			return;
		}
		break;

	/* queen rook */
	case BROOK1:
		flag =& ~BOOO;
		break;

	/* king rook */
	case BROOK2:
		flag =& ~BOO;
		break;

	/* king */
	case BKING:
		bkpos = to;
		flag =& ~(BOO|BOOO);
		switch(from-to) {

		case -2:
			board[5] = BROOK2;
			board[7] = 0;
			lp->mtyp = TOO;
			return;

		case 2:
			board[3] = BROOK1;
			board[0] = 0;
			lp->mtyp = TOOO;
			return;
		}
		lp->mtyp = TKING;
		return;
	}
	if(ispiece[pfrom] >= 0)
		abort();
	lp->mtyp = TMOVE;
}

bremove()
{
	int t, p;
	register from, to;
	register struct mstr *lp;

	amp--;
	lp = amp;
	t = lp->mtyp;
	p = lp->mpto;
	to = lp->mto;
	from = lp->mfrm;
	eppos = lp->mepp;
	flag = lp->mflg;
	value = lp->mval;
	board[from] = board[to];
	board[to] = p;

	switch(t) {

	/* king move */
	case TKING:
		bkpos = from;
		return;

	/* o-o */
	case TOO:
		board[7] = BROOK2;
		board[5] = 0;
		bkpos = 4;
		return;

	/* o-o-o */
	case TOOO:
		board[0] = BROOK1;
		board[3] = 0;
		bkpos = 4;
		return;

	/* ep */
	case TEP:
		board[from] = board[to+8];
		board[to+8] = 0;
		return;

	/* (q) */
	case TQPRO:
		board[from] = lp->mpar;
		return;
	}
}

battack(pos)
{
	int b, d;
	register i, j, *p;

	p = attab;
	d = dir[pos];

	/* attack by knight */
	i = 8;
	do {
		if((d & p[0]) == 0)
		if(isknig[board[pos+p[1]]] < 0)
			return(FALSE);
		p =+ 2;
	} while(--i);

	/* attack along diagonal */
	b = 4;
	do {
		j = pos;
		while((dir[j]&p[0]) == 0) {
			j =+ p[1];
			if(i = board[j])
			if(isdiag[i] < 0)
				return(FALSE); else
				break;
		}
		p =+ 2;
	} while(--b);

	/* attack at RIGHT angles */
	b = 4;
	do {
		j = pos;
		while((dir[j]&p[0]) == 0) {
			j =+ p[1];
			if(i = board[j])
			if(isrigh[i] < 0)
				return(FALSE); else
				break;
		}
		p =+ 2;
	} while(--b);

	/* attack by king */
	p =- 16;
	i = 8;
	do {
		if((d & p[0]) == 0)
		if(board[pos+p[1]] == BKING)
			return(FALSE);
		p =+ 2;
	} while(--i);

	/* attack by pawns */
	if((d & ULEFT) == 0)
	if(ispawn[board[pos-9]] < 0)
		return(FALSE);
	if((d & URIGHT) == 0)
	if(ispawn[board[pos-7]] < 0)
		return(FALSE);

	return(TRUE);
}
