#
/*****************************************************************
 **								**
 **		   U C L A  Data Secure Unix			**
 **								**
 **			Copyright 1977				**
 **								**
 **    Mark Kampe, Charles Kline, Gerald Popek, Evelyn Walton	**
 **								**
 *****************************************************************/
/* module name:
	image.c

function:
	This module contains routines which construct and modify
	a user's image in core.

globals contained:

routines contained:
	makeuser
	destroyuser
	growstack

modules referenced:
	seg.h

modules referencing:
	trap.c
	sys1.c

history:
	Designed (badly) and coded (hardly) by Mark Kampe

 */



#define true 0177777
#define false 000000
#define then /* */

#include "../../shared/constants.h"
#include "../../shared/shared.h"
#include "../seg.h"
#include "../param.h"
#include "../user.h"
/* name:
	makeuser

function:
	To allocate and map segments into the user address space adequate
	to the needs of his program

algorithm:

parameters:
	tsize	number of 64 byte segments in text segment
	dsize	number of 64 byte segments in data segment
	ssize	number of 64 byte segments in stack segment
	sep	whether or not module is to be separated

returns:
	true	-	map has been altered accordingly
	false	-	it was not possible to fulfill request
			a setting of u.u_error

globals:
	frametab

calls:
	segfetch

called by:
	exec

history:
*/
makeuser( tsize, dsize, ssize, sep )
 int tsize, dsize, ssize, sep;
{	register int framex;
	register int id0;
	register int id1;


	if (sep)
	then	return( false );

	/* current kluge - fill his space with segments */
	for( framex = USERI; framex < USERD; framex++ )
	{	segfetch( 0, 0, _READ_WRITE_ACCESS, framex,
			8192, _PAGE_GROWS_UP_FROM_ZERO );
		if (u.u_error)
		then	return( false );
		id0 = frametab[ framex ].f_id[0];
		id1 = frametab[ framex ].f_id[1];
		segfetch( id0, id1, _READ_WRITE_ACCESS, framex+8,
			8192, _PAGE_GROWS_UP_FROM_ZERO );
		if (u.u_error)
		then	return( false );
	}
	return( true );
}
/* name:
	destroyuser

function:
	to deallocate (and unmap) all of the segments from the
	user's memory space

algorithm:
	for each frame,
		if there is anything there,
		release it

parameters:
	none

returns:

globals:
	_segcap

calls:
	segrelse

called by:
	exec

history:
*/

destroyuser()
{	register int framex;

	for(framex = USERI; framex < SUPERI; framex++)
		if (_segcap[ framex ] >= 0 )
		then	segrelse( framex );

	return( true );
}
/* name:
	growstack

function:
	to grow the users's stack ( allocating and mapping segs as necessary )

algorithm:

parameters:
	address which the stack should grow to include

returns:
	true	-	done
	false	-	not a reasonable request

globals:

calls:

called by:
	trap

history:
*/

growstack( newsp )
 int *newsp;
{	return( true );
}
