#

/*
 *	TRANSFORMATION MODULE OF GPAC
 */

#include "../gpac.h"
#include "../error_codes.h"

pushstate()
	{
	register i;

	if((i = alloc(sizeof *Gstate_sp)) == -1)
		return(Gerror(ALLOC_ERR, "pushstate"));
	i->next_state = Gstate_sp;
	Gstate_sp = i;
	Gstate_sp->colour = Gcolour;
	Gstate_sp->lwidth = Glwidth;
	Gstate_sp->intensity = Gintensity;
	Gstate_sp->xxx = Gx_beg;
	Gstate_sp->yyy = Gy_beg;
	Gstate_sp->wcx = Gwcx;
	Gstate_sp->wcy = Gwcy;
	Gstate_sp->wsx = Gwsx;
	Gstate_sp->wsy = Gwsy;
	Gstate_sp->vcx = Gvcx;
	Gstate_sp->vcy = Gvcy;
	Gstate_sp->vsx = Gvsx;
	Gstate_sp->vsy = Gvsy;
	Gstate_sp->wv_mod = Gwv_mod;
	GOOD_RETURN;
	}


popstate()
	{
	register i;
	register j, k;
	int l, m;

	if(Gstate_sp == 0)
		return(Gerror(POP_EMPTY, "popstate"));
	Gcolour = Gstate_sp->colour;
	Glwidth = Gstate_sp->lwidth;
	Gintensity = Gstate_sp->intensity;
	Gx_beg = Gstate_sp->xxx;
	Gy_beg = Gstate_sp->yyy;
	window(Gstate_sp->wcx, Gstate_sp->wcy, Gstate_sp->wsx, Gstate_sp->wsy);
	viewport((j = Gstate_sp->vcx), (k = Gstate_sp->vcy), (l = Gstate_sp->vsx), (m = Gstate_sp->vsy));
	Gwv_mod = Gstate_sp->wv_mod;
	i = Gstate_sp->next_state;
	free(Gstate_sp);
	Gstate_sp = i;
	GOOD_RETURN;
	}


initstate()
	{
	register i;

	Gcolour = 0;
	Glwidth = 1;
	Gintensity = 15;
	if(Gcontrol_status & SEG_OPEN)
		moveto(0., 0.);
	   else
		{
		Gx_beg = 0.0;
		Gy_beg = 0.0;
		}
	window(511.5, 511.5, 511.5, 511.5);
	viewpin(.5, .5, .5, .5);
	while(Gstate_sp != 0)
		{
		i = Gstate_sp->next_state;
		free(Gstate_sp);
		Gstate_sp = i;
		}
	GOOD_RETURN;
	}
