#define	PARALLEL	0

struct lpdlock
{
	short lpd_pid;		/* pid of the daemon */
	short lpd_uid;		/* owner of currently printing job */
	short lpd_state;	/* state of the daemon */
	short lpd_pages;	/* total number of pages in queue */
};

struct printer
{
	char	ident;		/* printer identifying letter */
	char	push;		/* page feeds to push job out of printer */
	short	pagewidth;
	short	pagelength;
	short	realpagelen;	/* same as pagelength for la180 */
	char	translate;	/* whether to translate curly brackets etc */
	char	pagemult;	/* multiplication factor for the page limit */
	short	baudrate;
	short	modes;		/* modes for la180 types, e.g. parity. */
	short	autoselect;	/* set if a candidate for automatic queue selection */
}
printer[] =
{
	{ '0', 4, 136, 60, 68, 1, 10, PARALLEL,	0,		0 },
	{ '1', 1, 132, 51, 51, 0,  3, B2400, 	EVENP | XTABS,	1 },
	{ '4', 1, 132, 51, 51, 0,  3, B2400, 	EVENP | XTABS,	0 },
	{ '5', 1, 132, 51, 51, 0,  3, B2400, 	EVENP | XTABS,	1 },
};

#define NPRINTERS (sizeof printer/sizeof printer[0])
#define	PAR_PR		/* define if you have a parallel printer */

#define	LPDDIR	"/tmp/lpd"

#define	SIGKICK		SIGILL
#define	SIGSTOP		SIGTRAP
#define	SIGRESTART	SIGIOT

/*
 * daemon states
 */
#define	IDLE	0	/* waiting for something to do */
#define	PR_OP	1	/* trying to open the printer */
#define	PRINT	2	/* printing */
#define	CLDN	3	/* closing down */

/*
 * control file codes
 */
#define	LP_UID		'I'
#define	LP_BANNER	'L'
#define	LP_PUSH		'P'
#define	LP_COPIES	'N'
#define	LP_NOSKIP	'Y'
#define	LP_FILE		'F'
#define	LP_RM		'U'
#define	LP_RM_C		'C'
#define	LP_MESG		'M'
#define	LP_TTY		'T'
#define	LP_PAGES	'S'

#define	LPDMSZ		40	/* size of each entry in control file */
