
#include "const.h"

/*
 * conversion routines
 *	atoli(ptr)	long integer conversion
 *	atolo(ptr)	long octal conversion
 *	atolh(ptr)	long hexadecimal conversion
 *	atoh(ptr)	integer hex conversion
 *	lpack(ptr)	pack four ascii characters into a long location
 */
long	atoli(ptr)
register char	*ptr;
{
	register int	sign;
	long	result;

	result = 0;
	sign = 1;

	if( *ptr == '-' )
	{
		sign = -1;
		ptr++;
	}

	while( (*ptr >= '0') && (*ptr <= '9') )
	{
		if( (result < 214748364) || ((*ptr < '7') && (result == 214748364)) )
			result = (result * 10) + (*ptr++ - '0');
		else
		{
			if( (result == 214748364) && (sign == -1) && (*ptr++ == '7') )
			{
				if( (*ptr < '0') || (*ptr > '9') )	return( -2147483647 );
			}
			else
			{
				printf("Long conversion overflow.\nResult truncated to %ld\n",result);
				break;
			}
		}
	}
	return( sign * result );
}

long	atolh(ptr)
register char	*ptr;
{
	long	result;

	result = 0;

	while( ((*ptr >= '0') && (*ptr <= '9')) || ((*ptr >= 'a') && (*ptr <= 'f')) )
	{
		if( !(result & 0xF0000000) )
		{
			if( *ptr >= 'a' )	*ptr -= 'a' - '9' - 1;
			result = (result << 4) + (*ptr++ - '0');
		}
		else
		{
			printf("Long conversion overflow.\nResult truncated to %lx\n",result);
			break;
		}
	}
	return( result );
}

long	atolo(ptr)
register char	*ptr;
{
	long	result;

	result = 0;
	if( *ptr == 'x' )	result = atolh(++ptr);
	else
	{
		while( (*ptr >= '0') && (*ptr <= '7') )
		{
			if( !(result & 034000000000) )	result = (result << 3) + (*ptr++ - '0');
			else
			{
				printf("Long conversion overflow.\nResult truncated to %lo\n",result);
				break;
			}
		}
	}
	return( result );
}

int	atoh(ptr)
register char	*ptr;
{
	register unsigned int	result;

	result = 0;

	while( ((*ptr >= '0') && (*ptr <= '9')) || ((*ptr >= 'a') && (*ptr <= 'f')) )
	{
		if( result < 0xFFF )
		{
			if( *ptr >= 'a' )	*ptr -= 'a' - '9' - 1 ;
			result = (result << 4) + (*ptr++ - '0');
		}
		else
		{
			printf("Integer conversion overflow.\nResult truncated to %x\n",result);
			break;
		}
	}
	return( result );
}

long	lpack(ptr)
register char	*ptr;
{
	long	result;
	register char	i;

	result = 0;

	for( i=0 ; i<4 ; i++ )
	{
		if( *ptr == '\\' )	ptr++;		/* escape character */
		if( *ptr == '\0' )	return( result );
		result = (result << 8) + *ptr++;
	}
	return( result );
}
