#include	"../h/local.h"

/*
 * (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * Explicit permission is hereby granted to universities to use or duplicate
 * this program for educational or research purposes.  All other use or dup-
 * lication  by universities,  and all use or duplication by other organiza-
 * tions is expressly prohibited unless written permission has been obtained
 * from the Vrije Universiteit. Requests for such permissions may be sent to
 * 
 *      Dr. Andrew S. Tanenbaum
 *      Wiskundig Seminarium
 *      Vrije Universiteit
 *      Postbox 7161
 *      1007 MC Amsterdam
 *      The Netherlands
 * 
 * Organizations wishing to modify part of this software for subsequent sale
 * must  explicitly  apply  for  permission.  The exact arrangements will be
 * worked out on a case by case basis, but at a minimum will require the or-
 * ganization to include the following notice in all software and documenta-
 * tion based on our work:
 * 
 *           This product is based on the Pascal  system  developed  by
 *      Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
 *      of the Vrije Universiteit, Amsterdam, The Netherlands.
 */

#ifdef CEM
void	printf(());
#endif

#ifdef V7
#define		EQ		=

/* stripped <stdio.h>: */
#define	_NFILE	20
extern	struct	_iobuf {
	char	*_ptr;
	int	_cnt;
	char	*_base;
	char	_flag;
	char	_file;
} _iob[_NFILE];

#define	NULL	0
#define	FILE	struct _iobuf
#define	EOF	(-1)

#define	stdin	(&_iob[0])
#define	stdout	(&_iob[1])
#define	stderr	(&_iob[2])
#define	getc(p)		(--(p)->_cnt>=0? *(p)->_ptr++&0377:_filbuf(p))
#define	getchar()	getc(stdin)

FILE	*freopen();

/* stripped <sys/types.h> and <sys/stat.h>: */
typedef	unsigned int	ino_t;     	/* i-node number */
typedef	long       	time_t;   	/* a time */
typedef	int        	dev_t;    	/* device code */
typedef	long       	off_t;    	/* offset in file */
struct	stat
{
	dev_t	st_dev;
	ino_t	st_ino;
	unsigned short st_mode;
	short	st_nlink;
	short  	st_uid;
	short  	st_gid;
	dev_t	st_rdev;
	off_t	st_size;
	time_t	st_atime;
	time_t	st_mtime;
	time_t	st_ctime;
}	statbuf;
#endif

#ifndef V7
#define		EQ		/* nothing */
#define		EOF		0
extern	int	getchar();
struct stat {
	char	minor,major;
	int	inumber;
	int	flags;
	char	nlinks,uid;
	char	gid,size0;
	int	size1;
	int	addr[8];
	int	actime[2];
	int	modtime[2];
} statbuf;
#endif

struct descr {
	char	*path;
	char	*tab;
	int	flag;
	int	cnt;
};

struct descr	last	EQ { "em1_last",	0,	0,	0 };
struct descr	flow	EQ { "em1_flow",	0,	0,	0 };
struct descr	count	EQ { "em1_count",	0,	0,	0 };
struct descr	profile	EQ { "em1_profile",	0,	0,	0 };

char	*progname;
int	line	EQ 0;
int	args	EQ 0;
int	nolist;

extern	char	*sbrk();
extern	int	open();
extern	int	read();
extern	int	close();
extern	int	fstat();

main(argc,argv) char **argv; {
	register fd,c;

	progname = argv[0];
	while (argc>=2 && argv[1][0]=='-') {
		switch (argv[1][1]) {
			case 'l': flg(argv[1], &last); break;
			case 'f': flg(argv[1], &flow); break;
			case 'c': flg(argv[1], &count); break;
			case 'p': flg(argv[1], &profile); break;
			default: usage();
		}
		argc--;
		argv++;
	}

	nolist = (argc==1 && flow.flag==0 && count.flag==0 && profile.flag==0);
	if (nolist && last.flag==0)
		flg("-l", &last);
	find(&last);
	find(&flow);
	find(&count);
	find(&profile);
	last.cnt =/ 2;
	if (last.cnt)
		last.cnt--;
	flow.cnt =* 8;
	count.cnt =/ 4;
	profile.cnt =/ 4;

	if (nolist==0) {
		if (argc != 2)
			usage();
#ifdef V7
		if (freopen(argv[1],"r",stdin) == NULL)
#endif
#ifndef V7
		close(0);
		if ((open(argv[1], 0)) != 0)
#endif
			fatal("Can't open %s\n",argv[1]);
		line = 0;
		while ((c = getchar()) != EOF) {
			line++;
			if (c != '\n')
				printline(c,line);
			printf("\n");
		}
		if (last.flag)
			printf("\n");
	}

	if (last.flag)
		printlast();
#ifndef V7
	flush();
#endif
}

flg(s,dp) struct descr *dp; char *s; {

	dp->flag = 1;
	args = 1;
	if (s[2] != '\0')
		dp->path = &s[2];
}

find(dp) struct descr *dp; {
	register char *p;
	register sz,fd;

	if (args) {
		if (dp->flag == 0)
			return;
		if ((fd = open(dp->path,0)) < 0)
			fatal("Can't open %s\n",dp->path);
	} else {
		if ((fd = open(dp->path,0)) < 0)
			return;
		dp->flag = 1;
	}
	if (fstat(fd, &statbuf) < 0)
		fatal("Can't stat %s\n", dp->path);
#ifdef V7
	sz = statbuf.st_size;
	if (statbuf.st_size > 077777)
#endif
#ifndef V7
	sz = statbuf.size1;
	if (sz < 0 || statbuf.size0)
#endif
		fatal("%s too big\n",dp->path);
	dp->cnt = sz;
	if ((p = sbrk(sz)) == -1)
		fatal("%s does not fit in memory\n",dp->path);
	dp->tab = p;
	if (read(fd, p, sz) != sz)
		fatal("read error on %s\n",dp->path);
	if (close(fd) < 0)
		;
}

printline(ch,lin) {
	register c,i;

	i = lin; c = ch;
	printf("%4d",i);
	if (flow.flag)
		if (flow.cnt>=i && (flow.tab[i>>3] & (1<<(i&07))))
			printf(" *");
		else
			printf("  ");
	if (count.flag)
		printlong(&count,i);
	if (profile.flag)
		printlong(&profile,i);
	printf("\t");
	do
		printf("%c",c);
	while ((c = getchar()) != EOF && c != '\n');
}

printlong(dp,i) struct descr *dp; {
#ifdef V7
	register long *lp;
#endif
#ifndef V7
	register *ip;
	extern char *locv();
#endif

	if (i >= dp->cnt) {
		printf("        ");
		return;
	}
#ifdef V7
	lp = dp->tab;
	printf("%8D",lp[i]);
#endif
#ifndef V7
	ip = dp->tab;
	printf("%8s",locv(ip[2*i],ip[2*i+1]));
#endif
}

printlast() {
	register i,j;
	register *p;

	p = last.tab;
	printf("Last executed lines (read horizontally):\n");
	j = last.cnt - (p[last.cnt]>>1) - 2;
	for (i=0; i<last.cnt; i++) {
		if ((i % 8) == 0)
			printf("\n");
		printf("%5d%c", p[j], (i==last.cnt-1 ? '\n' : ','));
		if (--j < 0)
			j = last.cnt - 1;
	}
}

fatal(s,a) char *s,*a; {

#ifdef V7
	fprintf(stderr,s,a);
#endif
#ifndef V7
	extern fout;

	flush();
	fout = 2;
	printf(s,a);
	flush();
#endif
	exit(-1);
}

usage() {
	fatal("Usage: %s [-lxxx] [-fxxx] [-cxxx] [-pxxx] [source.p]\n", progname);
}
