#include	"../h/local.h"

/*
 * (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * Explicit permission is hereby granted to universities to use or duplicate
 * this program for educational or research purposes.  All other use or dup-
 * lication  by universities,  and all use or duplication by other organiza-
 * tions is expressly prohibited unless written permission has been obtained
 * from the Vrije Universiteit. Requests for such permissions may be sent to
 * 
 *      Dr. Andrew S. Tanenbaum
 *      Wiskundig Seminarium
 *      Vrije Universiteit
 *      Postbox 7161
 *      1007 MC Amsterdam
 *      The Netherlands
 * 
 * Organizations wishing to modify part of this software for subsequent sale
 * must  explicitly  apply  for  permission.  The exact arrangements will be
 * worked out on a case by case basis, but at a minimum will require the or-
 * ganization to include the following notice in all software and documenta-
 * tion based on our work:
 * 
 *           This product is based on the Pascal  system  developed  by
 *      Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
 *      of the Vrije Universiteit, Amsterdam, The Netherlands.
 */

#ifdef NC6
#define C7	1
#endif

#ifdef C7
typedef	struct	file	FILE;
#endif
#ifndef C7
#define	FILE		struct file
#endif

#ifdef CEM
extern	void	printf(());
#endif
#ifndef CEM
#define	void	int
extern	void	printf();
#endif

/*
 * value returning routines
 */
int	getchar();
int	getword();

/*
 * used library routines
 */
extern	int	read();
extern	int	write();
extern	int	open();
extern	void	exit();

#define	CCMAGIC		(172|(0<<8))
#define	ARCCMAGIC	(172|(1<<8))
#define	ARGUARD		(172|(2<<8))

#define	MAXPROC		100
#define	MAXGLO		100

char	procs[MAXPROC][8];
char	glos[MAXGLO][8];
int	nprocs;
int	nglos;
char	ent[10];

#define	NULL			0
#define	EOF			(-1)
#define	BUFSIZ			512
struct	file {
	int	fd;
	int	nleft;
	char	*nextp;
	char	buff[BUFSIZ];
};
FILE	stdout;
FILE	stdin;

int	libfil;
char	*progname;

main(argc,argv) char **argv; {
	register char *p,*q;
	register n;
	
	if(argc < 2 || argc > 3)
		fatal("Usage: makelib compact [ externals ]",0);
	if ((n = open(argv[1],0)) < 0)
		fatal("Can't open %s",argv[1]);
	finit(&stdin,n);
	finit(&stdout,1);
	if ((libfil = open(argc==3 ? argv[2] : "externals",0)) < 0)
		fatal("Can't open externals file",0);
	if (getword() != CCMAGIC)
		fatal("Bad input file",0);
	putword(ARCCMAGIC);
	while (read(libfil,ent,9) == 9)
		switch (ent[0]) {
		case 'p':
			p = &ent[1];
			if (nprocs>=MAXPROC)
				fatal("Too many external procs",0);
			q = procs[nprocs++];
			n = 8;
			while (*q++ = *p++)
				n--;
			while (n--)
				*q++ = 0;
			break;
		case 'g':
			p = &ent[1];
			if (nglos>=MAXGLO)
				fatal("Too many external glos",0);
			q = glos[nglos++];
			n = 8;
			while (*q++ = *p++)
				n--;
			while (n--)
				*q++ = 0;
			break;
		default:
			fatal("Bad character in externals file",0);
		}

	/*
	 * end of the externals file
	 */
	putword(nglos);
	putword(nprocs);
	q = glos[nglos];
	for (p = glos[0]; p < q; p++)
		putchar(*p);
	q = procs[nprocs];
	for (p = procs[0]; p < q; p++)
		putchar(*p);
	putword(ARGUARD);
	while ((n = getchar()) >= 0)
		putchar(n);
	flush();
	exit(0);
}

/* ------------------- IO routines -------------------------- */

finit(af,fd) FILE *af; {
	register FILE *f;
	/*
	 * initialize file structure
	 */
	f = af;
	f->fd = fd;
	f->nleft = 0;
	f->nextp = 0;
}

int fill() {
	/*
	 * read in next block
	 */
	stdin.nextp = stdin.buff;
	return(stdin.nleft = read(stdin.fd,stdin.buff,BUFSIZ) - 1);
}

flush() {
	/*
	 * write out a (partial) filled block; fatal if error
	 */
	if (stdout.nextp)
		if (write(stdout.fd,stdout.buff,stdout.nextp-stdout.buff) < 0)
			if (stdout.fd != 2)
				fatal("write error",0);
	stdout.nextp = stdout.buff;
	stdout.nleft = BUFSIZ;
}

int getchar() {

	if (--stdin.nleft < 0)
		if (fill() < 0)
			return(EOF);
	return(*(stdin.nextp)++ & 0377);
}

int getword() {
	register n;

	n = getchar();
	return(n | (getchar() << 8));
}

putchar(c) {
	/*
	 * write next character
	 */
	if (--stdout.nleft < 0) {
		flush();
		--stdout.nleft;
	}
	*(stdout.nextp)++ = c;
}

putword(n) int n; {
	putchar(n);
	putchar(n>>8);
}

fatal(s,a1) char *s; {

	flush();
	finit(&stdout,2);
	printf("%s: ",progname);
	printf(s,a1);
	putchar('\n');
	flush();
	exit(-1);
}
