#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * read compact code and fill in tables
 */

/* These constants are close to sp_cend for fast switches */
#define	INST	256
#define	PSEU	257
#define	ILBX	258
#define	DLBX	259
#define	CSTX	260

int	tabval;
int	bssodd;
int	dataodd;

int table3(n) int n; {

	switch (n) {
	case sp_ilb1:	tabval = readbyte(); return(ILBX);
	case sp_ilb2:	tabval = readword(); return(ILBX);
	case sp_dlb1:	make_string(readbyte()); return(DLBX);
	case sp_dlb2:	make_string(readword()); return(DLBX);
	case sp_dnam:	inident(GLO_UNIQUE); return(DLBX);
	case sp_pnam:	inident(PRO_UNIQUE); return(n);
	case sp_cst1:	tabval = readbyte(); return(CSTX);
	case sp_cst2:	tabval = readword(); return(CSTX);
	case sp_cstm:	tabval = -readbyte(); return(CSTX);
	default:	return(n);
	}
}

int table1() {
	register n;

	n = readbyte();
	if ((n <= sp_lmnem) && (n >= sp_fmnem)) {
		tabval = n;
		return(INST);
	}
	if ((n <= sp_lpseu) && (n >= sp_fpseu)) {
		tabval = n;
		return(PSEU);
	}
	if ((n < sp_filb0 + sp_nilb0) && (n >= sp_filb0)) {
		tabval = n - sp_filb0;
		return(ILBX);
	}
	return(table3(n));
}

int table2() {
	register n;

	n = readbyte();
	if ((n < sp_fcst0 + sp_ncst0) && (n >= sp_fcst0)) {
		tabval = n - sp_fcst0;
		return(CSTX);
	}
	return(table3(n));
}

char *inproname() {
	if (table2() != sp_pnam)
		fatal("proname expected");
	return(string);
}

glob_t *getlab(status) {
	if (table2() != DLBX)
		fatal("global label expected ");
	return(glolookup(string,status));
}

int getint() {
	if (table2() != CSTX)
		fatal("int expected");
	return(tabval);
}

do_compact (alnp) line_t *alnp; {
	register line_t *lnp;
	register byte;

	/*
	 * read one instruction line in compact code.
	 */
	complines++;
	lnp = alnp;
	curglosym=0;
	switch (table1()) {
	default:
		fatal("unknown instruction byte");	return;
	case INST:
		lnp->instr_num = tabval;
		if ((mnemon[tabval].m_flags&MNXYZ)==MNZ) {
			lnp->type1 = MISSING;
			lnp->ad.ad_i = 0;
			return;
		}
		/*
		 * This instruction should have an opcode, so read it after
		 * this switch.
		 */
		break;
	case DLBX:
		lastglosym=curglosym=
			glolookup(string,DEFINING);
		curglosym->g_status =| REL;
		if (table1() != PSEU)
			fatal("no pseudo after global label");
	case PSEU:
		lnp->instr_num = tabval;
		lnp->type1 = PSEUDO;	/* only used in dump_line */
		lnp->ad.ad_i = 0;
		do_pseudo(lnp);
		return;
	case ILBX:
		lnp->ad.ad_lp = loclookup(tabval,DEFINING);
		lnp->type1 = LOCSYM;
		lnp->instr_num = op_lab;
		return;
	}
	switch (table2()) {
	default:
		fatal("unknown offset byte");	return;
	case CSTX:
		if((mnemon[lnp->instr_num&0377].m_flags&MNABCEM)==MNB) {
		/* i.e. a constant (=local label) of a branch instr.? */
			lnp->ad.ad_lp=loclookup(tabval,OCCURRING);
			lnp->type1=LOCSYM;
		} else {
			lnp->ad.ad_i=tabval;
			lnp->type1=CONST;
		}
		return;
	case ILBX:
		lnp->ad.ad_lp = loclookup(tabval,OCCURRING);
		lnp->type1 = LOCSYM;
		return;
	case DLBX:
		lnp->ad.ad_gp = glolookup(string,OCCURRING);
		lnp->type1 = GLOSYM;
		return;
	case sp_pnam:
		lnp->ad.ad_pp = prolookup(string,PRO_OCC);
		lnp->type1 = PROCNAME;
		break;
	}
}

do_pseudo(alnp) line_t *alnp; {
	register glob_t *gbp,*gbp1;
	register a;
	int b,byte;
	int par1,par2;
	char *pars;

	/*
	 * get operands of pseudo (if needed) and process it.
	 */

	dump_line(complines,alnp);
	a = alnp->instr_num&0377;
	inrom=0;
	alnp->instr_num=op_nul;
	switch(a) {
	case ps_bss:
		a = getint();	/* number of bytes */
		byte = a&01;	/* byte used as an 'oddflag' */
		set_mode(BSS);
		if(curglosym) pglob();
		pputs(MEM_INCR); pputo(a);
		bssodd = byte;
		pline();
		break;
	case ps_rom:
		++inrom;
		if(curglosym)
			curglosym->g_rom= &rom[lastrom];
	case ps_con:
		set_mode(DATA);
		if(curglosym) pglob();
		b = 0;	/* b = stopcondition */
		while(!b) {
			switch (table2()) {
			case CSTX:
				even();
				pputo(tabval);
				if (inrom)
					if (lastrom<MAXROM)
						rom[lastrom++]=tabval;
					else {
						lastglosym->g_rom=0;
						fatal("out of rom");
					}
				break;
			case ILBX:
				even();
				pputc(LOC_PREFIX);
				pputd(loclookup(tabval, OCCURRING)->l_val);
				break;
			case DLBX:
				even();
				pputs(glolookup(string,OCCURRING)->g_name);
				break;
			case sp_pnam:
				even();
				pputs(procdesc[
				 prolookup(string,PRO_OCC)].p_name);
				break;
			case sp_scon:
				/* no 'even()' */
				pstring();
				break;
			case sp_rcon:
				even();
				preal();
				break;
			case sp_lcon:
				even();
				plong();
				break;
			case sp_cend:
				b = 1;	/* exit */
				break;
			default:fatal("unknown CON/ROM byte");
			}
			if(!b) pline();
		}
		break;
	case ps_eof:
		++eof_seen;
	case ps_end:
		++end_seen;
		break;
	case ps_mes:
		switch(getint()) {
		case 0:ertrap();break;
		case 2:error("VIR not implemented",0);break;
		}
		while (table2() != sp_cend)
			;
		break;
	case ps_exc:
		fatal("EXC illegal in pdp");
		break;
	case ps_exd:
		gbp = getlab(EXPORTING);
		break;
	case ps_ima:
	case ps_imc:
		gbp = getlab(IMPORTING);
		break;
	case ps_fwa:
	case ps_fwc:
		gbp = getlab(FORWARDING);
		break;
	case ps_hol:
		set_mode(BSS);
		pputs("ep"); pputd(holnum); pputc(':');
		pputs(MEM_INCR); pputo(getint());
		pputs("\nep=ep"); pputd(holnum++);
		pline();
		EB = "ep";
		break;
	case ps_let:
		gbp = getlab(DEFINING);
		pputs(gbp->g_name); pputc('=');
		switch (table2()) {
		case CSTX:
			pputo(tabval);
			break;
		case DLBX:
			gbp1=glolookup(string,OCCURRING);
			if(gbp1->g_status&REL)
				gbp->g_status =| REL;
			pputs(gbp1->g_name);
			break;
		default:
			fatal("error in LET");
		}
		pline();
		break;
	case ps_pro:
		pars = inproname();
		par1 = getint();
		par2 = getint();
		a = prolookup(pars,par2?PRO_DFX:PRO_DFL);
		strcpy(module,pars);
		set_mode(TEXT);
		if(par2) {
			pputs(GLOBL); pputs(pars); pline();
		}
		plabel(pars); pline();
		gen2(MOV,SPX,LB);
		switch (par1) {
		case 0: break;
		case 2: gen1(TST,MINLB); break;
		case 4: gen2(op_cmi,MINLB,MINLB); break;
		default:gen2(op_sub,imm(par1),LB);
		}
		break;
	case ps_fwp:
		a = prolookup(inproname(),PRO_LCL);
		break;
	default:
		fatal("unknown pseudo");
	}
}

instring() {
	register a;
	register char *p;

	a=readbyte();
	if(a==255)
		a=readword();
	if(a+1>MAXSTRING)
		fatal("string too long");
	strlngth=a;
	for(p=string+1;a--; )
		*p++ = readbyte();
	*p=0;	/* for terminating a <name> */
}

inident(c0) {

	instring();
	string[0] = c0;
	string[MAXIDENT] = '\0';
}

make_string (n) {
	register char *s;

	s = string;
	*s++ = GLO_PREFIX;
	strcpy(s,int10(n));
}

pglob () {
	even();
	plabel(curglosym->g_name);
}

pstring() {
	register char *s;
	register n;

	instring();
	s = string + 1;
	n=strlngth;
	dataodd = n&01;
	if(n--) {
		pputs(BYTES); pputo(*s++);
		while(n--) {
			pputc(','); pputo(*s++);
	}	}
}

preal() {
	register int *p;
	register i;
	REALTYPE f;

	instring();
	f=atof(string + 1);
	for (i = sizeof(f)>>1, p = iip_cast &f; i>0; i--) {
		pputo(*p++);
		if (i>1)
			pputc(';');
	}
}

plong() {
	register int *p;
	register i;
	LONGTYPE l;

	instring();
#ifdef V6
	atol(string+1, &l);
#endif
#ifndef V6
	l = atol(string+1);
#endif
	for (i = sizeof(l)>>1, p = iip_cast &l; i>0; i--) {
		pputo(*p++);
		if (i>1)
			pputc(';');
	}
}

set_mode (storage) {

	if(storage!=curr_mode) {
		if(!eoln) pline();
		switch(storage) {
		case TEXT:	pputs(".text"); break;
		case DATA:	pputs(".data"); break;
		case BSS:	pputs(".bss");
		}
		pline();
		curr_mode=storage;
	}
}

char EVENSTR[]	EQ ".even";

even () {
	if(dataodd && curr_mode==DATA) {
		pputs(EVENSTR); pline();
		dataodd=FALSE;
	} else if(bssodd && curr_mode==BSS) {
		pputs(EVENSTR); pline();
		bssodd=FALSE;
}	}
