/*	PAR - The POP11 System Archiver
 *	/ p o p / c c c / p a r . c
 *
 *	This program creates POP11 library files,for use with
 *	the popmess(Liblist) command.
 *
 *	Typical call:
 *		par file1 file2 ... >libfile
 *
 *	PAR, like CAT, takes a number of file names
 *	as argument and concatenates them to its
 *	standard output. Unlike CAT, PAR processes
 *	the subfiles (removing comments, redundant spaces etc)
 *	for faster compilation.  Furthermore, PAR precedes the
 *	subfiles by an 'index' understood by the POP11 system.
 *	If invoked with NO arguments PAR treats its
 *	standard input as a set of filenames (one per line).
 *
 *	New version 22 May 1981, by C. Sammut
 */

#include <stdio.h>

typedef struct
{
	char name[14];
	short size;
} entry;


main(argc,argv)
int argc;
char  **argv;
{
	register total;
	register entry *index;

	total = sizeof(entry) * argc;
	index = (entry *) malloc(total);
	trim(&(index[0].name), "[INDEX]");
	index[0].size = total;
	fseek(stdout, (long) total, 0);
	while (--argc)
	{
		trim(&(index[argc].name), argv[argc]);
		index[argc].size = process(argv[argc]);
	}
	fflush(stdout);
	fseek(stdout, 0L, 0);
	fwrite(index, (unsigned) total, 1, stdout);
}


char last;
int count;					/* Incremented by "put" */
process(name)
{
	register char this;

	last = '\n';
	count = 0;
	if (freopen(name, "r", stdin) == NULL)
		error("unable to open input file",name);
	this = getchar();
	while (this != EOF)
		if (this == ';')
		{	if ((this = getchar()) == ';'
					&& (this = getchar()) == ';')
				while ((this = getchar()) !=  '\n');
			else put(';');
		}
		else
		{	if (this == ' ' || this == '\t' || this == '\n')
				this = '\n';
			put(this);
			if (this == '\'')
			{	while ((this = getchar()) != '\'')
				{	put(this);
					if (this == '\\')
						put(getchar());
				}
				put(this);
			}
			this = getchar();
		}
	if (count & 1) put(';');
	return(count);
}
put(c)
char c;
{
	if (c != '\n' || last != '\n')
		{count++; putchar(c); last = c;}
}


trim(trimbuff, name)
char *trimbuff, *name;
{
	register char c,*p,*q;

	p = name;
	q = trimbuff;
	while (c = *p++)
	{
		if (c == '.') break;
		else if (c == '/') q = trimbuff;
		else *q++ = c;
	}
	while (q < &trimbuff[14]) *q++ = 0;
}

error(message,culprit)
char *message, *culprit;
{
	fprintf(stderr, "par -- %s, %s\n", message, culprit);
	exit();
}
