/	SUBTITLE	b-garbage.s	The garbage collector
/	Written by Steven Hardy on 20 April 1976
/
/	This function collects together all in use records at the bottom end of the heap.
/	The marking algorithm used is to mark all records pointed to by the
/	stacks etc and then 'walk' through the heap looking for marked records.
/	When such a record is found the records it points to are marked.
/	If these records are behind the walk pointer the walk pointer should
/	be pulled back to that record; To avoid this such records
/	are marked recursively until the auxiliary stack overflows - then the walk pointer
/	is - reluctantly - pulled back.
/	After marking is complete the first word of each free block immediately
/	following a block of in use records is filled with a relocation offset
/	i.e. the amount the preceding block of in use records are to be relocated,
/	then all pointers are adjusted and finally the in use records are moved down the heap.
/	At some time soon I will put in code to extend or contract the size of the heap
/	area as the user programs's core requirements change. This will require the user
/	stack to be shuffled upwards for it and the heap occupy the same area of core,
/	growing towards one another. Notice that this means that the garbage collector
/	can be invoked either by a store request or by the stack check routine.
/
	ksfunction
fgarbage:
	br	sgarbage
	false; false; rts pc
sgarbage:
	mov	berrfile,r0		/ close error file
	sys	close
	mov	$-1,berrfile
	clr	ptriples		/ clear stored triples list
	tst	bgcflg			/ recursive call?
	beq	1f			/ br if not
	rts	pc			/ if so just guve up
1:
	inc	bgcflg			/ set in gc flag
	mov	bhphi,r0		/ address  of last record to r0
	mov	$4,okey(r0)
	mov	$sgcclear,brecfn	/ set up to clear all marks
	mov	bhplo,r1		/ start point for gcrecrd
	jsr	pc,sgcrecrd		/ clear all marks
	mov	bhphi,r1		/ set walk point to top of heap
	mov	bhplo,bgclo		/ and lowest interesting point for gcscan
	mov	$sgcmark,bpntfn		/ set up for marking
	jsr	pc,sgcpoint		/ mark all pointers
1:
	cmp	r1,bhphi		/ is the walk over?
	bhis	1f			/ br if so
	mov	okey(r1),r0		/ key of current record to r0
	mov	r1,r2			/ current record to r2
	bic	$mbutsize,r0		/ clear all but size
	add	r0,r1			/ move walk pointer on
	bit	r4,okey(r2)		/ was record marked?
	beq	1b			/ br if not
	tst	okey(r2)		/ does it need scanning
	bge	1b			/ br if not
	mov	r1,r3			/ end point for gcscan
	sub	$2,r3			/ start point is already in r2
	jsr	pc,sgcscan		/ scan the record
	br	1b			/ loop back for more
1:					/ end of marking
	clr	r3			/ r3 is free space so far
	mov	bhphi,bgclo		/ set default low interesting point
	mov	$sgcoffst,brecfn	/ set up to compute relocations
	mov	bhplo,r1		/ start point for gcrecrd
	jsr	pc,sgcrecrd		/ compute offsets
	mov	r3,*bhphi		/ note final relocation
	mov	bhphi,bgclused
	mov	$sgcalter,bpntfn	/ set up to adjust pointers
	mov	bhplo,r1		/ start point for gcrecrd
	mov	$177777,bgclused	/ set last in use record veryhigh
	jsr	pc,sgcpoint		/ adjust pointers
	mov	bgclo,r1		/ first free to r1
	tst	-(r1)			/ pull back to key word
	mov	r1,r2			/ r2 will be next used record
1:
	cmp	r2,bhphi		/ movement finished?
	bhis	4f			/ br if so
	mov	(r2),r0			/ key of next 'in use' to r0
	bic	$mbutsize,r0		/ r0 is size of next 'in use'
	bit	r4,(r2)			/ is r2 really in use?
	beq	3f			/ br if not
	asr	r0			/ r0 to words from bytes
2:
	mov	(r2)+,(r1)+		/ move word of record
	sob	r0,2b			/ loop back if more to go
3:
	add	r0,r2			/ advance r2 to next 'in use' record
	br	1b			/ loop back
4:
	tst	(r1)+			/ make r1 point to record, not key
	mov	$2*ozone,br5zn		/ reset user stack zone
	mov	r1,bhphi		/ set high point of heap
	add	br5zn,r1		/ add safe user stack zone
	mov	r1,br5lo
	mov	r5,r0			/ compute free space
	sub	bhphi,r0
	cmp	r0,$ohigh		/ is it a bit high?
	bhi	1f			/ br if so
	cmp	r0,$olow		/ is it a bit low?
	bhi	2f			/ br  if okay
1:
	jsr	pc,sexpand		/ shrink core
2:
	mov	bhphi,r0		/ compute in use amount
	sub	bhplo,r0		/ size of heap
	add	br5hi,r0
	sub	r5,r0			/ size of user stack
	ash	$-9.,r0			/ convert to kilobytes
	bic	$177600,r0
	bis	r4,r0			/ set mnumber
	mov	r0,pgcusd
	mov	r5,r0			/ compute free space
	sub	bhphi,r0		/ subtract heap
	ash	$-9.,r0			/ convert to kilobytes
	bic	$177600,r0
	bis	r4,r0			/ convert to POP11 integer
	mov	r0,pgcfre		/ and store
	asl	btime
	add	btime,pgctime
	clr	btime			/ clear time
	cmp	r5,br5lo		/ stack overflow?
	blos	1f			/ don't apply user function if so
	mov	pgcfun,-(r5)		/ user garbage collection function
	jsr	pc,sapply		/ apply it
1:
	dec	bgcflg
	rts	pc
