;;;	/ p o p / u s r / l i b / a b s y s . p
;;;
function float(x);
	x * 1.0
end;
;;;
function isnumber(x);
	isinteger(x) or isreal(x)
end;
;;;
vars joblist; [] -> joblist;		;;; A list of jobs waiting to be run.
;;;
function runjobs();			;;; The job scheduler.
	vars thisjob;			;;; The current job
	until joblist == [] then		;;; until no more jobs
		dest(joblist) -> joblist -> thisjob;	;;; get next job
		unless fnprops(thisjob) == true then	;;; Unless this job has been run
			true -> fnprops(thisjob);	;;; mark this job as run
			thisjob();	;;; and run it
		close
	close
end;
;;;
function attach(var);			;;; attach current job to a variable
	false -> fnprops(thisjob);	;;; mark job as runnable
	thisjob :: tl(var) -> tl(var);	;;; add job to variables job list
end;
;;;
function value(var);			;;; function to get value of a variable
	if isnumber(var) then
		var
	elseif isnumber(hd(var)) then	;;; if variable has a value
		hd(var)			;;; then return its value
	else				;;; otherwise
		hd(var)			;;; return false
	close
end;;
;;;
lambda (val, var);			;;; updater to set value of a variable
	if isnumber(value(var)) then	;;; if variable already has a value
		unless val == value(var) then	;;; check value is not being altered
			error(0, 'inconsistent')	;;; report error
		close
	else				;;; otherwise
		[%hd(var)% is %val%] =>
		val -> hd(var);		;;; set value
		tl(var) <> joblist -> joblist;	;;; put variables jobs onto global joblist
		[] -> tl(var);		;;; clear variables joblist
	close
end -> updater(value);
"value" -> fnprops(updater(value));
;;;
function defined(var);
	isnumber(value(var))
end;
;;;
function doeq(x, y);			;;; process x == y
	if defined(x) then
		value(x) -> value(y)
	elseif defined(y) then
		value(y) -> value(x)
	else
		attach(x);
		attach(y)
	close
end;
;;;
operation 7 #== x y;			;;; users function to assert equality
	doeq(%x, y%) :: joblist -> joblist;	;;; add a job to the joblist
	runjobs()			;;; run any runnable jobs
end;
;;;
function dorel(x, y, z, fx, fy, fz);	;;; function to check a relation
					;;; fx(y, z) gives x
					;;; fy(x, z) gives y
					;;; fz(x, y) gives z
	if defined(x) then
		if defined(y) then
			fz(value(x), value(y)) -> value(z)
		elseif defined(z) then
			fy(value(x), value(z)) -> value(y)
		else
			attach(y);
			attach(z);
		close
	elseif defined(y) then
		if defined(z) then
			fx(value(y), value(z)) -> value(x)
		else
			attach(x);
			attach(z)
		close
	else
		attach(x);
		attach(y);
		unless defined(z) then
			attach(z);
		close
	close
end;
;;;
operation 4 #+ x y => z;
	[[%value(x)% + %value(y)%]] -> z;
	dorel(%	x,
		y,
		z,
		lambda (y, z); z - y end,
		lambda (x, z); z - x end,
		lambda (x, y); x + y end%)
	:: joblist -> joblist
end;
;;;
operation 4 #- x y => z;
	[[%value(x)% - %value(y)%]] -> z;
	dorel(%	x,
		y,
		z,
		lambda (y, z); z + y end,
		lambda (x, z); x - z end,
		lambda (x, y); x - y end%)
	:: joblist -> joblist
end;
;;;
operation 3 #* x y => z;
	[[%value(x)% * %value(y)%]] -> z;
	dorel(%	x,
		y,
		z,
		lambda (y, z); float(z) / y end,
		lambda (x, z); float(z) / x end,
		lambda (x, y); x * y end%)
	:: joblist -> joblist
end;
;;;
operation 3 #/ x y => z;
	[[%value(x)% / %value(y)%]] -> z;
	dorel(%	x,
		y,
		z,
		lambda (y, z); y * z end,
		lambda (x, z); float(x) / z end,
		lambda (x, y); float(x) / y end%)
	:: joblist -> joblist
end;
;;;
macro $ => name;
	itemread() -> name;
	0 -> identprops(name);
	[%name%] -> valof(name)
end;
;;;
cancel +; vars operation 4 +; nonop #+ -> nonop +;
cancel -; vars operation 4 -; nonop #- -> nonop -;
cancel *; vars operation 3 *; nonop #* -> nonop *;
cancel /; vars operation 3 /; nonop #/ -> nonop /;
cancel ==; vars operation 7 ==; nonop #== -> nonop ==;
'absys> ' -> popmess(Prompt);
