;;;	/ p o p / u s r / l i b / t r a c e a l l . p
;;;	by Aaron Sloman 	10 March 1978
;;; The function appdictionary applies its argument to every item in the
;;; dictionary
;;; The operation traceall causes all user functions to be traced. This is
;;; useful for beginners.
;;; The operation untraceall causes all traced user functions to be untraced.
;;; This is useful for both beginners and others.
;;; Unfortunately, it is impossible to prevent traceall tracing subsidiary
;;; functions from library files, unless their names start with a
;;; capital letter.
;;; Also, since the macro trace doesn't at present deal adequately with
;;; functions which have updaters, traceall doesn't trace functions with
;;; updaters
function appdictionary(F);
	appdata(popmess(Dictionary),
		lambda(X);
			if X then
				if atom(X) then F(X)
				else
					applist(X,F)
				close
			close
		end)
end;

function Startsuppercase (X);
	;;; X is a word. Does it start with an upper case character?
	subscrc(1,X><'') -> X;
	`A <= X and X <= `Z
end;

function Trytrace(X);
	function errfun(X);
		erase();
		erase();
		exitto(Trytrace)
	end;
	if isword(X) and identprops(X).isinteger and isfunc(valof(X))
		and not(isfunc(updater(valof(X))))
		and not(Startsuppercase(X))
		and not(Readable('/pop/lib/' >< X >< '.p'))
		and X /= "exitto" and X /= "subscrc"
		and X /= "cucharout"
		and X /= "proglist"
		and X /= "isclosure"
		and X /= "traceall" and X /= "untraceall"
		and X /= "appdictionary"
	then popval([trace %X% ;])
	close
end;
function Tryuntrace(X);
	function errfun(X);
		erase();
		exitto(Tryuntrace)
	end;
	if isword(X) and isinteger(identprops(X)) and isclosure(valof(X))
		and not(Startsuppercase(X))
	then erase([% popval([untrace %X% ;]) %])
	close
end;
operation 2 traceall;
	appdictionary(Trytrace)
end;
operation 2 untraceall;
	appdictionary(Tryuntrace)
end;
