/*
 *	banner [-] [ "string" ... ]
 */

#include <stdio.h>


#define	SHORTSET 64	/*number of chars in short set*/
#define FULLSET	96	/*number of chars in full set*/
#define	SHORTCH 6	/*number of lines per char in short set*/
#define LONGCH	9	/*number of lines per char in full set*/
#define	TOTPP	129*11+1	/*accumulate 11 lines before throwing out
				plus 1 char for 1 null*/
#define	POSPCH	8	/*number of char positions per banner char*/
#define	UPPER	1	/*translate all upper case to lower*/
#define	LOWER	2	/*translate all upper case to lower*/

/*
** below is the short character set table
*/
char shortbl[SHORTSET][SHORTCH]	={
	000,000,000,000,000,000,	/* */
	010,010,010,010,000,010,	/*!*/
	022,022,000,000,000,000,	/*"*/
	022,077,022,022,077,022,	/*#*/
	036,054,036,015,055,036,	/*$*/
	001,062,064,013,023,040,	/*%*/
	014,022,014,024,042,035,	/*&*/
	010,010,000,000,000,000,	/*'*/
	004,010,010,010,010,004,	/*(*/
	010,004,004,004,004,010,	/*)*/
	000,022,014,014,022,000,	/***/
	000,010,010,076,010,010,	/*+*/
	000,000,000,014,004,010,	/*,*/
	000,000,000,037,000,000,	/*-*/
	000,000,000,000,014,014,	/*.*/
	001,002,004,010,020,040,	/*/*/
	014,022,045,051,022,014,	/*0*/
	010,030,010,010,010,034,	/*1*/
	034,042,002,014,020,076,	/*2*/
	034,042,014,002,042,034,	/*3*/
	020,020,024,037,004,004,	/*4*/
	037,040,036,001,001,036,	/*5*/
	004,010,026,031,021,016,	/*6*/
	037,001,002,004,010,020,	/*7*/
	016,021,016,021,021,016,	/*8*/
	016,021,023,015,002,004,	/*9*/
	000,014,014,000,014,014,	/*:*/
	000,014,000,014,004,010,	/*;*/
	000,004,010,020,010,004,	/*<*/
	000,000,037,000,037,000,	/*=*/
	000,010,004,002,004,010,	/*>*/
	016,021,006,004,000,004,	/*?*/
	036,041,047,051,046,036,	/*@*/
	014,022,041,077,041,041,	/*A*/
	076,041,076,041,041,076,	/*B*/
	036,041,040,040,041,036,	/*C*/
	076,041,041,041,041,076,	/*D*/
	077,040,076,040,040,077,	/*E*/
	077,040,076,040,040,040,	/*F*/
	036,041,040,047,041,036,	/*G*/
	041,041,077,041,041,041,	/*H*/
	004,004,004,004,004,004,	/*I*/
	001,001,001,001,041,036,	/*J*/
	041,042,074,044,042,041,	/*K*/
	040,040,040,040,040,077,	/*L*/
	041,063,055,041,041,041,	/*M*/
	041,061,051,045,043,041,	/*N*/
	036,041,041,041,041,036,	/*O*/
	076,041,041,076,040,040,	/*P*/
	036,041,041,045,042,035,	/*Q*/
	076,041,041,076,042,041,	/*R*/
	036,040,036,001,041,036,	/*S*/
	037,004,004,004,004,004,	/*T*/
	041,041,041,041,041,036,	/*U*/
	041,041,041,041,022,014,	/*V*/
	041,041,041,055,063,041,	/*W*/
	041,022,014,014,022,041,	/*X*/
	021,012,004,004,004,004,	/*Y*/
	077,002,004,010,020,077,	/*Z*/
	016,010,010,010,010,016,	/*[*/
	040,020,010,004,002,001,	/*\*/
	034,004,004,004,004,034,	/*]*/
	004,012,000,000,000,000,	/*^*/
	000,000,000,000,000,077,	/*_*/
};
/*
** it is too much trouble to type in the character next to
** pattern so just look it up in the ascii table, starting
** with ' '
*/
char fulltbl[FULLSET][LONGCH]	={
0000,0000,0000,0000,0000,0000,0000,0000,0000,
0010,0010,0010,0010,0010,0010,0000,0000,0010,
0044,0044,0044,0044,0000,0000,0000,0000,0000,
0024,0024,0177,0024,0024,0024,0177,0024,0024,
0024,0077,0124,0124,0076,0025,0025,0176,0024,
0040,0121,0042,0004,0010,0020,0042,0105,0002,
0060,0110,0110,0060,0060,0112,0106,0102,0075,
0014,0014,0010,0020,0000,0000,0000,0000,0000,
0004,0010,0020,0020,0020,0020,0020,0010,0004,
0020,0010,0004,0004,0004,0004,0004,0010,0020,
0010,0111,0052,0034,0010,0034,0052,0111,0010,
0000,0010,0010,0010,0177,0010,0010,0010,0000,
0000,0000,0000,0000,0000,0000,0010,0010,0020,
0000,0000,0000,0000,0177,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0014,0014,
0000,0001,0002,0004,0010,0020,0040,0100,0000,
0034,0042,0103,0105,0111,0121,0141,0042,0034,
0010,0030,0050,0010,0010,0010,0010,0010,0076,
0076,0101,0001,0002,0034,0040,0100,0100,0177,
0076,0101,0001,0001,0016,0001,0001,0101,0076,
0004,0014,0024,0044,0104,0104,0177,0004,0004,
0177,0100,0100,0100,0176,0001,0001,0101,0076,
0036,0041,0100,0100,0136,0141,0101,0101,0076,
0177,0001,0001,0002,0004,0010,0020,0040,0100,
0076,0101,0101,0042,0034,0042,0101,0101,0076,
0076,0101,0101,0103,0075,0001,0001,0102,0074,
0000,0000,0000,0010,0000,0000,0010,0000,0000,
0000,0000,0000,0010,0000,0000,0010,0010,0020,
0002,0004,0010,0020,0040,0020,0010,0004,0002,
0000,0000,0000,0177,0000,0177,0000,0000,0000,
0040,0020,0010,0004,0002,0004,0010,0020,0040,
0076,0101,0001,0001,0006,0010,0010,0000,0010,
0036,0041,0115,0125,0125,0137,0100,0041,0036,
0010,0024,0042,0101,0101,0177,0101,0101,0101,
0174,0042,0041,0042,0074,0042,0041,0042,0174,
0036,0041,0100,0100,0100,0100,0100,0041,0036,
0174,0042,0041,0041,0041,0041,0041,0042,0174,
0177,0100,0100,0100,0174,0100,0100,0100,0177,
0177,0100,0100,0100,0174,0100,0100,0100,0100,
0036,0041,0100,0100,0100,0107,0101,0043,0034,
0101,0101,0101,0101,0177,0101,0101,0101,0101,
0076,0010,0010,0010,0010,0010,0010,0010,0076,
0001,0001,0001,0001,0001,0001,0101,0042,0034,
0101,0102,0104,0110,0120,0150,0104,0102,0101,
0100,0100,0100,0100,0100,0100,0100,0100,0177,
0101,0101,0143,0125,0111,0111,0111,0101,0101,
0101,0101,0141,0121,0111,0105,0103,0101,0101,
0034,0042,0101,0101,0101,0101,0101,0042,0034,
0176,0101,0101,0101,0176,0100,0100,0100,0100,
0034,0042,0101,0101,0101,0111,0105,0042,0035,
0176,0101,0101,0101,0176,0110,0104,0102,0101,
0036,0041,0100,0040,0034,0002,0001,0102,0074,
0177,0111,0010,0010,0010,0010,0010,0010,0010,
0101,0101,0101,0101,0101,0101,0101,0042,0034,
0101,0101,0101,0042,0042,0042,0024,0024,0010,
0101,0101,0101,0101,0111,0111,0111,0125,0042,
0101,0101,0042,0024,0010,0024,0042,0101,0101,
0101,0101,0042,0024,0010,0010,0010,0010,0010,
0177,0001,0002,0004,0010,0020,0040,0100,0177,
0177,0140,0140,0140,0140,0140,0140,0140,0177,
0000,0100,0040,0020,0010,0004,0002,0001,0000,
0177,0003,0003,0003,0003,0003,0003,0003,0177,
0000,0000,0000,0010,0024,0042,0101,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0177,
0030,0030,0010,0004,0000,0000,0000,0000,0000,
0000,0000,0000,0074,0002,0076,0102,0102,0075,
0100,0100,0100,0134,0142,0102,0102,0142,0134,
0000,0000,0000,0074,0102,0100,0100,0102,0074,
0002,0002,0002,0072,0106,0102,0102,0106,0072,
0000,0000,0000,0074,0102,0176,0100,0100,0074,
0014,0022,0020,0020,0174,0020,0020,0020,0020,
0000,0072,0106,0102,0102,0106,0072,0002,0074,
0100,0100,0100,0134,0142,0102,0102,0102,0102,
0000,0010,0000,0030,0010,0010,0010,0010,0076,
0000,0006,0002,0002,0002,0002,0002,0042,0034,
0100,0100,0100,0104,0110,0120,0150,0104,0102,
0030,0010,0010,0010,0010,0010,0010,0010,0076,
0000,0000,0000,0166,0111,0111,0111,0111,0111,
0000,0000,0000,0134,0142,0102,0102,0102,0102,
0000,0000,0000,0074,0102,0102,0102,0102,0074,
0000,0134,0142,0102,0102,0142,0134,0100,0100,
0000,0072,0106,0102,0102,0106,0072,0002,0002,
0000,0000,0000,0134,0142,0100,0100,0100,0100,
0000,0000,0000,0074,0102,0060,0014,0102,0074,
0000,0020,0020,0174,0020,0020,0020,0022,0014,
0000,0000,0000,0102,0102,0102,0102,0106,0072,
0000,0000,0000,0042,0042,0042,0042,0024,0010,
0000,0000,0000,0101,0101,0111,0111,0111,0066,
0000,0000,0000,0102,0044,0030,0030,0044,0102,
0000,0102,0102,0102,0102,0106,0072,0002,0074,
0000,0000,0000,0176,0004,0010,0020,0040,0176,
0014,0020,0020,0020,0040,0020,0020,0020,0014,
0010,0010,0010,0000,0000,0010,0010,0010,0000,
0030,0004,0004,0004,0002,0004,0004,0004,0030,
0060,0111,0006,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000
};

char	plot		='@';
char	altchar 	='\0';	/* indicates alternate plotting character */
char	alphaflag	=0;	/* indicates upper or lower case translation */
char	Fflag		=0;	/* font change flag */
short	charht		=11;	/* height of character */
char	msk		=0100;	/* mask at seventh bit */
short	chpln		=10;	/*number of banner characters per line*/
char	buf[512];

main(argc,argv)
	register int argc;
	register char **argv;
{
	register char c;
	register int i;
	char	buf[BUFSIZ];

	while(--argc > 0 && **++argv == '-'){
		while((c = *(++argv[0])) != '\0'){
			switch(c){
			case 'F':
				charht = 6;	/* shortie chars */
				msk = 040;	/* sixth bit for short chars */
				Fflag = 1;
				break;
			case 'c':
				c = *(++argv[0]);
				altchar = (c > ' ' && c <= '~') ? c : '#';
				break;
			case 'l':
				alphaflag = LOWER;
				break;
			case 'u':
				alphaflag = UPPER;
				break;
			case 'w':
				chpln = 16;
				break;
				}
			}
		}

	setbuf(stdout, buf);

	if(argc <= 0)
		while(i = fread(buf,sizeof(*buf),512,stdin)){
			buf[i-1] = '\0';
			banner(buf);
			}
	else
		while ( argc-- ){
			banner(*argv++);
			}

	fflush(stdout);
	return 0;
}

banner(s)
	char *s;
{
	char buff[TOTPP],c;
	register char *l,*p;
	register short i,j,descend;
	short vcol,col;

	l = buff;
	for(i = 0; i < charht; i++){
		for(p = s; c = *p++;){
			if((int)(p - s) > chpln)
				break;
			c &= 0177;
			if(c < ' ')
				c = '#';
			if((c >= 'A' && c <= 'Z') && alphaflag == LOWER)
				c += 'a' - 'A';
			if((c >= 'a' && c <= 'z') && alphaflag == UPPER)
				c -= 'a' - 'A';
			if(c == 'g' || c == 'j' || c == 'p' || c == 'q'
				|| c == 'y')
				descend = 1;
			else
				descend = 0;
			plot = altchar ? altchar : c;
			c -= ' ';	/* shift down to suit base of table */
			if(Fflag == 0){
				if(descend == 0)
					c = i < 9 ? fulltbl[c][i] : 0;
				else
					c = i >= 2 ? fulltbl[c][i-2] : 0;
				}
			else{
				if(c >= 64)
					c -= 32;
				c = shortbl[c][i];
				}
			for(j = 0; j < POSPCH; j++)
				*l++ = ((c << j) & msk) ? plot : ' ';
			}
		while(*--l == ' ')
			;
		l++;
		*l++ = '\n';
		}
	*l = '\0';
	p = l = buff;
	vcol = col = 0;
	while(c = *l++){
		switch(c){
			case '\t':
				vcol |= 7;
			case ' ':
				vcol++;
				continue;
			case '\n':
				vcol = col = 0;
				break;
			default:
				while( (vcol & ~7) > col){
					*p++ = '\t';
					col |= 7;
					col++;
					}
				while(vcol > col){
					*p++ = ' ';
					col++;
					}
				col++;
				vcol++;
			}
		*p++ = c;
		}
	fwrite(buff,sizeof(*buff),(unsigned)(p-buff),stdout);
}
