/*
 * gomoko - converted from basic to assembler by John Lowe -
 *	converted to C by KFH
 */

#include	<signal.h>
#include	<setjmp.h>
#include	<stdio.h>

jmp_buf	env;
unsigned	r0, r1, r2, r3, r4, r5;
unsigned	boardsize, i, j, m1, m2, x0, x1, x2;
unsigned	x, y, p, s, t, v, x, y, d, l, m, f;

int	noshell;

char	board[362];
char	obuf[1280];

rubout()
{
	signal(SIGINT, SIG_IGN);
	printf("\n\nAha! You forfeit the game!\n");
	x1++;
	longjmp(env, 1);
}

mshell()
{
	register pid;

	if (noshell)
	{
		printf("Not permitted\n");
		return;
	}
	signal(SIGINT, SIG_IGN);
	if ((pid = fork()) == 0)
	{
		signal(SIGINT, SIG_DFL);
		execl("/bin/sh", "sh", "-t", 0);
		exit();
	}
	if (pid != -1)
		wait((int *)0);
	signal(SIGINT, rubout);
	printf("!\n");
}

main(ac, av)
char	**av;
{
	char	outbuf[BUFSIZ];

	if (ac >= 1 && av[0][0] == '-')
		noshell++;
	setbuf(stdout, outbuf);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	printf("\n\nWelcome to the oriental game of go-moko.\n\n");
	printf("Do you want the instructions: ");
	fflush(stdout);
	if (read(0, obuf, sizeof obuf) <= 0)
		exit();
	if (obuf[0] == 'y')
		instr();
	play();
}

play()
{
	for (;;)
	{
		signal(SIGINT, SIG_IGN);
		printf("\nWhat is your board size\n(minimum 7, maximum 18): ");
		do
		{
			r4 = 0;
			iread();
		} while (r2 == 'e');
		endline();
		if (r1 < 7 || r1 > 18)
		{
			printf("I said minimum size is 7,\nmaximum is 18.\n");
			continue;
		}
		r3 = sizeof(board) - 1;
		do
			board[r3] = -1;
		while (--r3);
		board[0] = -1;
		boardsize = r1;
		r5 = r1;
		printf("\nWe play alternate moves.\nYou go first.\n\n");
		if (setjmp(env) == 0)
		{
			register fred;

			signal(SIGINT, rubout);
			while ((fred = game()) == 0);
			if (fred < 0)
			{
				S2170();
				printf("\nBoo hoo! You win the game!\n\n");
				fflush(stdout);
				sleep(3);
				x0++;
			}
		}
		signal(SIGINT, SIG_DFL);
		printf("\nThanks for the game!\n\nThe score to date is:\n");
		printf("  You have won %2d game(s)\n", x0);
		printf("    I have won %2d game(s)\n", x1);
		printf(" We have drawn %2d game(s)\n", x2);
		printf("\nDo you want another game?\n(y for yes, anything else for no): ");
		fflush(stdout);
		if (read(0, obuf, sizeof obuf) <= 0)
			exit();
		if (obuf[0] != 'y')
		{
			printf("\nGoodbye!\n");
			exit();
		}
	}
}

game()
{
	printf("Enter your move: ");
	do
	{
		do
		{
			r4 = 1;
			iread();
		} while (r2 == 'e');
		if (r0 == 0)
		{
			if (r3 == '!')
			{
				mshell();
				return(0);
			}
			if (r3 == 'b')
			{
				S2170();
				return(0);
			}
			instr();
			return(0);
		}
		i = r1;
		r4 = 1;
		iread();
	} while (r2 == 'e');
	endline();
	if (r0 == 0)
	{
		if (r3 == '!')
		{
			mshell();
			return(0);
		}
		if (r3 == 'b')
		{
			S2170();
			return(0);
		}
		instr();
		return(0);
	}
	j = r1;
	if ((r1 = i) <= 0)
		return(1);
	x = r1;
	y = j;
	S2290();
	if (l == 0)
	{
		printf("That was an illegal move.\n");
		printf("Try again ....\n");
		return(0);
	}
	r1 = i;
	r1--;
	r1 = r1 * r5;
	r1 += j;
	r1--;
	if (board[r1] >= 0)
	{
		printf("That square was occupied\nTry again ....\n");
		return(0);
	}
	board[r1] = 0;
	if (m >= 250)
	{
		s = t = p = 1;
		S0990();
		if (d > 3)
			return(-1);
		t = 0;
		S0990();
		if (d > 3)
			return(-1);
		t--;
		S0990();
		if (d > 3)
			return(-1);
		s = 0;
		S0990();
		if (d > 3)
			return(-1);
	}
	m = v = r3 = 0;
	do
	{
		r3++;
		r4 = 0;
		do
		{
			r4++;
			v = 0;
			r1 = r3;
			r1--;
			r1 = r1 * r5;
			r1 = r1 + r4;
			r1--;
			if (board[r1] < 0)
			{
				s = t = 1;
				S1480();
				t = 0;
				S1480();
				t--;
				S1480();
				s = 0;
				S1480();
				if (v > m)
				{
					m = v;
					m1 = r3;
					m2 = r4;
				}
			}
		} while (r5 > r4);
	} while (r5 > r3);
	if (m)
	{
		r1 = m1;
		r1--;
		r1 = r1 * r5;
		r1 = r1 + m2;
		r1--;
		board[r1] = 1;
		S2170();
		printf("My move is %2d,%2d.      ", m1, m2);
		if (m <= 2000)
			return(0);
	}
	else
	{
		S2170();
		printf("\nThe game is a draw, as\n");
		printf("neither of us can place\n");
		printf("five pieces in a line.\n");
		fflush(stdout);
		sleep(3);
		x2++;
		return(1);
	}
	printf("\nHooray! I win the game!\n\n");
	fflush(stdout);
	sleep(3);
	x1++;
	return(1);
}

/*
 *	r0 = 1	if number OK
 *	     0	if [bi!] encountered
 *
 *	r1	number
 *
 *	r2 = 0	if \n encountered
 *
 *	r3	last number - '0'
 *
 *	r4	zero will ignore [bi!]
 */
iread()
{
	char ch;

	r1 = r2 = 0;
	fflush(stdout);
	for (;;)
	{
		if (read(0, &ch, 1) <= 0)
		{
			printf("\n");
			exit();
		}
		r0 = 1;
		switch(r3 = ch)
		{
		case ',':
		case ' ':
		case '\t':
		case '\n':
			if (r2 == 0)
				continue;
			if (r3 != '\n')
				r2 = 0;
			r0 = 1;
			return;

		case 'b':
		case 'i':
			if (r4)
			{
				r2 = 0;
				endline();
				r0 = 0;
				return;
			}
			break;

		case '!':
			if (r4)
			{
				r2 = r0 = 0;
				return;
			}
			break;
		}

		if ((r3 -= '0') >= 0 && r3 <= 9)
		{
			r1 = r1 * 10 + r3;
			r2++;
			continue;
		}
		r2 = 0;
		endline();
		printf("\nIllegal characters entered - try again: ");
		r2 = 'e';
		return;
	}
}

endline()
{
	if (r2)
		return;
	read(0, obuf, sizeof obuf);
	r2++;
}

instr()
{
	printf("\nThe game is played on an n by n grid of a size that you specify.\n");
	printf("During your play you may cover one grid intersection with a mark-\n");
	printf("er.  The object of the game is to get five adjacent markers in  a\n");
	printf("row  -  horizontally, vertically or along either diagonal. On the\n");
	printf("board diagram your moves are marked with a  'X' and my moves with\n");
	printf("a  'O'.  I will terminate the game if you or I win or if the game\n");
	printf("is a draw.  Alternatively, you can end  the  game  by  typing  in\n");
	printf("'0,0' for your move.  If you want the board again you can type in\n");
	printf("a 'b', also for the instructions, type in a 'i'.  If you want  to\n");
	printf("make  a  UNIX command, then type in a '!.....' where ..... is the\n");
	printf("command you want executed by the UNIX shell.\n");
}

S0990()
{
	d = 0;
	x = i;
	y = j;
	for (;;)
	{
		x += s;
		y += t;
		S2290();
		if (l)
		{
			calc();
			if (board[r1] == 0)
			{
				d++;
				continue;
			}
		}
		x = i;
		y = j;
		for (;;)
		{
			x -= s;
			y -= t;
			S2290();
			if (l == 0)
			{
				L184();
				return;
			}
			calc();
			if (board[r1] == 0)
			{
				d++;
				continue;
			}
			return;
		}
	}
}

calc()
{
	r1 = x;
	r1--;
	r1 = r1 * r5;
	r1 += y;
	r1--;
}

S1480()
{
	p = 1;
	S1730();
	if (f >= 4)
	{
		if (d)
		{
			v += 10;
			if (d != 1)
			{
				v += 20;
				if (d != 2)
				{
					v += 102;
					if (d != 3)
						v += 400;
				}
			}
		}
		v += f;
	}
	p = 2;
	S1730();
	if (f < 4)
		return;
	if (d)
	{
		v += 20;
		if (d != 1)
		{
			v += 20;
			if (d != 2)
			{
				v += 80;
				if (d != 3)
					v += 2000;
			}
		}
	}
	v += f;
}

S1730()
{
	d = f = 0;
	x = r3;
	y = r4;
	for (;;)
	{
		x += s;
		y += t;
		S2290();
		if (l == 0)
		{
			L184();
			return;
		}
		calc();
		r2 = p;
		r2--;
		if (board[r1] != r2)
		{
			L184();
			return;
		}
		d++;
	}
}

L184()
{
	x = r3;
	y = r4;
	for (;;)
	{
		x -= s;
		y -= t;
		S2290();
		if (l == 0)
			break;
		calc();
		r2 = p;
		r2--;
		if (board[r1] != r2)
			break;
		d++;
	}
	r2 = 3;
	r2 -= p;
	p = r2;
	x = r3;
	y = r4;
	for (;;)
	{
		x += s;
		y += t;
		S2290();
		if (l == 0)
			break;
		calc();
		r2 = p;
		r2--;
		if (board[r1] == r2)
			break;
		f++;
	}
	x = r3;
	y = r4;
	for (;;)
	{
		x -= s;
		y -= t;
		S2290();
		if (l == 0)
			return;
		calc();
		r2 = p;
		r2--;
		if (board[r1] == r2)
			return;
		f++;
	}
}

/*
 *	print out the board
 */
S2170()
{
	register char *cp;

	cp = obuf;
	cp = column(cp);
	*cp++ = '\n';
	r1 = -1;
	r2 = 0;
	do
	{
		r2++;
		*cp++ = '\n';
		cp = row(cp);
		r3 = 0;
		do
		{
			r3++;
			*cp++ = ' ';
			*cp++ = ' ';
			r1++;
			if (board[r1] >= 0)
				if (board[r1])
					*cp++ = 'O';
				else
					*cp++ = 'X';
			else
				*cp++ = '.';
		} while (r5 > r3);
		*cp++ = ' ';
		cp = row(cp);
	} while (r5 > r2);
	*cp++ = '\n';
	cp = column(cp);
	*cp++ = '\n';
	*cp++ = '\n';
	write(1, obuf, cp - obuf);
}

/*
 *	Is the move legal?
 */
S2290()
{
	l = 1;
	if (x < 1 || y < 1 || x > r5 || y > r5)
		l = 0;
}

/*
 *	write number of row
 */
row(cp)
register char *cp;
{
	if (r2 >= 10)
	{
		*cp++ = '1';
		*cp++ = r2 - 10 + '0';
	}
	else
	{
		*cp++ = ' ';
		*cp++ = r2 + '0';
	}
	return(cp);
}

/*
 *	write number of column
 */
column(cp)
register char *cp;
{
	*cp++ = '\n';
	*cp++ = ' ';
	*cp++ = ' ';
	r3 = 0;
	do
	{
		r3++;
		*cp++ = ' ';
		if (r3 >= 10)
		{
			*cp++ = '1';
			*cp++ = r3 - 10 + '0';
		}
		else
		{
			*cp++ = ' ';
			*cp++ = r3 + '0';
		}
	} while (r5 > r3);
	return(cp);
}
