/*LINTLIBRARY*/

/*
**	ptime	put time in string in form "nnnXnnY" where X&Y can be any of 'w', 'd', 'h', 'm', 's'
**	=====
*/

static int	zero;


char *
ptime( time, sp )
	register long	time;		/** 31 bit time **/
	register char	*sp;		/** pointer to 8 character buffer where string will be placed (zero terminated) **/
{
	char		s[8];
	extern char *	ptn();

  if ( time < 0 )
	goto negativ;

  {
	register	trac, sepc, divn;

	sepc = 'm';
	trac = 's';
	divn = 60;

	if ( time >= 3600 )	/* more than 1 hour */
	{
		trac = sepc;
		sepc = 'h';
		time /= 60;

		if ( time >= 1440 )	/* more than 1 day */
#		ifdef	TIME_IN_DAYS
		{
			trac = sepc;
			sepc = 'd';
			divn = 24;
			time /= 60;

			if ( time >= 168 )	/* more than 1 week */
			{
				trac = sepc;
				sepc = 'w';
				divn = 7;
				time /= 24;

				if( time >= 7000 )	/* more than 1000 weeks */
					trac = 0;
			}
		}
#		else	TIME_IN_DAYS
			trac = 0;
#		endif	TIME_IN_DAYS
	}

	zero = 1;

	if ( !trac )
	{
		time /= divn;
		if ( time > 999999l )
			goto overflo;
		ptn( time, s, 6 );
		s[6] = sepc;
	}
	else
	{

		ptn( time/divn, s, 3 );
		s[3] = zero ? ' ' : sepc;
		ptn( time%divn, &s[4], 2 );
		s[6] = zero ? '0' : trac;
	}
	s[7] = 0;
  }
  {
	register char	*cp1, *cp2;

	cp1 = s;
out:
	for ( cp2=sp ; *cp2++ = *cp1++ ; );
	return( sp );

negativ:
	cp1 = "negativ";
	goto out;
overflo:
	cp1 = "overflo";
	goto out;
  }
}



/*
**	ptn	put a decimal number into string with leading spaces
**	=====
*/

static char *
ptn( t, s, n )
	register long		t;
	register char		*s;
	register		n;
{
	if ( --n )
		s = ptn( t/10, s, n );
	if ( (t %= 10) || !zero )
	{
		zero = 0;
		*s++ = t + '0';
	}
	else
		*s++ = ' ';
	return( s );
}
