/*LINTLIBRARY*/

/*
**	This function adds the entry pointed to by "pe" to a
**	password file. If the pointer at uidtable(pe->pw_limits.l_uid)==NULL
**	then this is the new uid. If not then new uid is allocated.
**	Returns the new uid or PWERROR for error
*/ 

#include	<pwr.h>


addpwent(pe)
	register struct pwent *pe;
{
	register struct pwent *rp;

	struct pwent p;
	long t, hte;
	register int ht;
	register int ri;



	ri = PWERROR;

	/*	open and lock */ 

	if ( pwopen( 1 ) == SYSERROR )
		return ri;

	/*	initialise */ 

	do
	{
		rp = &p;
		pe->pw_next = PWENTNULL;
		ht = pwhash(pe->pw_strings[LNAME]);
		if(!gethtab(ht, &pe->pw_last))
			break;

		/*	now list from "pe->pw_last" may/maynot be null and
			may/maynot contain the entry.	*/ 

		if(chkentry(pe, &pe->pw_last) != 1)
			break; /* error, or already exists */

		/*	now "pe->pw_last" is the seek address for the last list element
			or "PWENTNULL" for a null list	*/ 

		if ( !getutab(pe->pw_limits.l_uid, &hte) )
			break;

		while ( hte != PWENTNULL )
			if ( !getutab( ++pe->pw_limits.l_uid, &hte ) )
				goto out;

		/** Set up default group to be same as uid **/

		pe->pw_gid = pe->pw_limits.l_uid;

		if(pe->pw_last == PWENTNULL)
		{
			/* no list, so just add it in */ 
			if(addentry(pe, &t) <= 0)
				break;
			if(!puthtab(ht, &t))
				break;
			if(!pututab(pe->pw_limits.l_uid, &t))
				break;
		}
		else
		{
			/* here for a list at least one long, so ad on at end */ 
			if(!getentry(rp, &pe->pw_last))
				break;
			if(addentry(pe, &rp->pw_next) <= 0)
				break;

			/*	now "pe->pw_last" contains the seek address of the last list
				element stored in "p". "rp->pw_next" contains the seek address
				for the new element contained in "*pe". "pe->pw_limits.l_uid" is the
				new uid, and only remains to write data out */ 

			if(!pututab(pe->pw_limits.l_uid, &rp->pw_next))
				break;
			if(!putentry(rp, &pe->pw_last))
				break;
		}

		/*	return uid and that is all */ 

		ri = pe->pw_limits.l_uid;
	}
	while(0);

out:
	unlock();

	return(ri);
}
