#include	<sys/param.h>
#include	<sys/proc.h>
#include	<sys/dir.h>
#include	<sys/user.h>
#include	<a.out.h>

char	*unixf;
char	*coref;
int	ufd, cfd;
struct proc proc[NPROC];

struct nlist nl[] =
{
	{ "_proc",	0, 0 },
	{ 0,		0, 0 },
};

main(ac, av)
char **av;
{
	register struct nlist *nlp;
	register struct proc *p;
	struct user user;
	unsigned slot;

	if (ac != 3)
	{
		printf("Usage: c unix core\n");
		exit(1);
	}
	unixf = av[1];
	coref = av[2];
	if ((ufd = open(unixf, 0)) == -1)
	{
		perror(unixf);
		exit(1);
	}
	if ((cfd = open(coref, 0)) == -1)
	{
		perror(coref);
		exit(1);
	}
	nlp = nl;
	nlist(unixf, nlp);
	if (nlp->n_value == 0 && nlp->n_type == 0)
	{
		printf("_proc not found\n");
		exit(1);
	}
	lseek(cfd, (long)nl[0].n_value, 0);
	read(cfd, proc, NPROC * sizeof(struct proc));
	slot = 0;
	printf("  Stat Flag Uid  Pid Ppid  Addr  Sz Wchan Pri Textp\n");
	for (p = proc; p < &proc[NPROC]; p++, slot++)
	{
		if (p->p_stat == NULL)
			continue;
		printf("%3d:", slot);
		printf(" %c  ", " SWRIZT"[p->p_stat]);
		printf(" %3o ", p->p_flag);
		printf("%4u ", p->p_uid);
		printf("%4u ", p->p_pid);
		printf("%4u ", p->p_ppid);
		if (p->p_stat == SZOMB)
		{
			printf("\n");
			continue;
		}
		printf("%05o ", p->p_addr);
		printf("%3d ", p->p_size);
		if (p->p_stat == SSLEEP)
			printf("%06o ", p->p_wchan);
		else
			printf("       ");
		printf("%4u ", p->p_pri);
		printf("%05o ", p->p_textp);
		if (p->p_flag & SLOAD)
		{
			lseek(cfd, (long)p->p_addr << 6, 0);
			read(cfd, &user, sizeof user);
			printf("%-14.14s", user.u_comm);
		}
		printf("\n");
	}
	exit(0);
}
