#include	<sys/param.h>
#include	<sys/proc.h>
#include	<a.out.h>

char	*unixf;
char	*coref;
char	ofile[7];
int	ufd, cfd, ofd;
int	crook, exitstat;
unsigned index;

struct nlist nl[] =
{
	{ "_proc",	0, 0 },
#define	NLPROC	0
	{ 0,		0, 0 },
};

main(ac, av)
char **av;
{
	register struct nlist *nlp;

	if (ac != 5)
	{
		printf("Usage: xt unix core table index\n");
		printf("  tables: p(roc), u(ser)\n");
		exit(1);
	}
	unixf = av[1];
	coref = av[2];
	if ((ufd = open(unixf, 0)) == -1)
	{
		perror(unixf);
		exit(1);
	}
	if ((cfd = open(coref, 0)) == -1)
	{
		perror(coref);
		exit(1);
	}
	nlp = nl;
	nlist(unixf, nlp);
	while (nlp->n_name[0])
	{
		if (nlp->n_value == 0 && nlp->n_type == 0)
		{
			printf("Symbol %s not found\n", nlp->n_name);
			crook++;
		}
		nlp++;
	}
	if (crook)
		exit(1);
	index = (unsigned)atoi(av[4]);
	croutput(av[3][0]);
	switch(av[3][0])
	{
    case 'p':	getproc();
		break;
    case 'u':	getuser();
		break;
    default:	printf("Unrecognised table\n");
		exitstat++;
	}
	if (exitstat)
		unlink(ofile);
	exit(exitstat);
}

croutput(c)
{
	register unsigned u;
	register i;
	register char *cp;

	u = index;
	cp = &ofile[6];
	for (i = 0; i < 5; i++)
	{
		*--cp = u % 10 + '0';
		u /= 10;
	}
	*--cp = c;
	ofd = creat(ofile, 0600);
	if (ofd == -1)
	{
		printf("Can't create %s\n", ofile);
		exit(1);
	}
}

getproc()
{
	register struct proc *p;

	if (index >= NPROC)
	{
		printf("0 <= index < %d\n", NPROC);
		exitstat++;
		return;
	}
	p = want(sizeof(struct proc));
	lseek(cfd, (long)nl[NLPROC].n_value + index * sizeof(struct proc), 0);
	read(cfd, p, sizeof(struct proc));
	write(ofd, p, sizeof(struct proc));
}

getuser()
{
	register struct proc *p;
	register n, i;
	char *buf;

	if (index >= NPROC)
	{
		printf("0 <= index < %d\n", NPROC);
		exitstat++;
		return;
	}
	p = want(sizeof(struct proc));
	buf = want(BSIZE);
	lseek(cfd, (long)nl[NLPROC].n_value + index * sizeof(struct proc), 0);
	read(cfd, p, sizeof(struct proc));
	if (p->p_stat == NULL)
	{
		printf("Proc free\n");
		exitstat++;
		return;
	}
	if (p->p_stat == SZOMB)
	{
		printf("Proc dead\n");
		exitstat++;
		return;
	}
	if ((p->p_flag & SLOAD) == 0)
	{
		printf("Proc not in core\n");
		exitstat++;
		return;
	}
	lseek(cfd, (long)p->p_addr << 6, 0);
	i = p->p_size;
	do
	{
		n = i;
		if (n > BSIZE/ctob(1))
			n = BSIZE/ctob(1);
		i -= n;
		n *= ctob(1);
		if (read(cfd, buf, n) != n)
		{
			printf("Read incorrect\n");
			exitstat++;
			return;
		}
		write(ofd, buf, n);
	} while (i);
}

want(sz)
unsigned sz;
{
	register char *n;

	if ((n = malloc(sz)) != NULL)
		return(n);
	printf("Out of memory\n");
	exit(1);
}
